/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GroupActionMenuItem
extends ContributionItem {
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            GroupActionMenuItem.this.fDirty = true;
        }
    };
    private IAction fAction;
    private boolean fDirty = true;

    public GroupActionMenuItem(IAction iAction) {
        super(iAction.getId());
        this.fAction = iAction;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int n) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        MenuItem menuItem = new MenuItem(menu, 64, n);
        menuItem.setText(this.fAction.getText());
        IMenuCreator iMenuCreator = this.fAction.getMenuCreator();
        if (iMenuCreator != null) {
            Menu menu2 = iMenuCreator.getMenu(menu);
            menuItem.setMenu(menu2);
            if (menu2.getItemCount() > 0) {
                boolean bl;
                boolean bl2 = bl = this.fAction.isEnabled() && this.isEnabledAllowed();
                if (bl != this.fAction.isEnabled()) {
                    MenuItem[] menuItemArray = menu2.getItems();
                    for (int i = 0; i < menuItemArray.length; ++i) {
                        menuItemArray[i].setEnabled(bl);
                    }
                }
            }
        }
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean bl = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return bl == null ? true : bl;
    }
}

