/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.actions.AlignmentRetargetAction;
import com.spket.ui.actions.DropDownToolBarItem;
import com.spket.ui.actions.EditorActionGroup;
import com.spket.ui.actions.GroupActionMenuItem;
import com.spket.ui.actions.IDropDownAction;
import com.spket.ui.actions.MatchSizeRetargetAction;
import com.spket.ui.actions.RetargetEditorAction;
import com.spket.ui.actions.SetColorRetargetAction;
import com.spket.ui.actions.TextAlignRetargetAction;
import com.spket.ui.internal.UIImages;
import com.spket.ui.internal.UIMessages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

public class FormatActionGroup
extends EditorActionGroup {
    public static final String FORMAT_KEYBINDING_SCOPE_ID = "com.spket.ui.textFormatScope";
    public static final String M_FORMAT = "format";
    public static final String CMD_BOLD = "com.spket.ui.text.format.bold";
    public static final String CMD_ITALIC = "com.spket.ui.text.format.italic";
    public static final String CMD_UNDERLINE = "com.spket.ui.text.format.underline";
    public static final String BOLD = "fmt.bold";
    public static final String ITALIC = "fmt.italic";
    public static final String UNDERLINE = "fmt.underline";
    public static final String FORECOLOR = "fmt.forecolor";
    public static final String BACKCOLOR = "fmt.backcolor";
    public static final String INDENT = "fmt.indent";
    public static final String OUTDENT = "fmt.outdent";
    public static final String ORDERED_LIST = "list.ordered";
    public static final String UNORDERED_LIST = "list.unordered";
    public static final String TEXT_ALIGN = "fmt.justify";
    public static final String TEXT_ALIGN_LEFT = "fmt.justify.left";
    public static final String TEXT_ALIGN_CENTER = "fmt.justify.center";
    public static final String TEXT_ALIGN_RIGHT = "fmt.justify.right";
    public static final String TEXT_ALIGN_JUSTIFY = "fmt.justify.justify";
    public static final String LAYOUT_ALIGN = "layout.align";
    public static final String LAYOUT_ALIGN_LEFT = "layout.align.left";
    public static final String LAYOUT_ALIGN_CENTER = "layout.align.center";
    public static final String LAYOUT_ALIGN_RIGHT = "layout.align.right";
    public static final String LAYOUT_ALIGN_TOP = "layout.align.top";
    public static final String LAYOUT_ALIGN_MID = "layout.align.mid";
    public static final String LAYOUT_ALIGN_BOTTOM = "layout.align.bottom";
    public static final String MATCH_SIZE = "match.size";
    public static final String MATCH_SIZE_WIDTH = "match.size.width";
    public static final String MATCH_SIZE_HEIGHT = "match.size.height";
    public static final String MATCH_SIZE_BOTH = "match.size.both";
    private boolean forHtml;

    public FormatActionGroup(boolean bl) {
        this.forHtml = bl;
        RetargetEditorAction retargetEditorAction = new RetargetEditorAction(BOLD, UIMessages.Bold_text, 2);
        retargetEditorAction.setToolTipText(UIMessages.Bold_toolTip);
        retargetEditorAction.setActionDefinitionId(CMD_BOLD);
        retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("tool.bold"));
        retargetEditorAction.setDisabledImageDescriptor(UIImages.getImageDescriptor("tool.bold.disabled"));
        this.registerAction(retargetEditorAction);
        retargetEditorAction = new RetargetEditorAction(ITALIC, UIMessages.Italic_text, 2);
        retargetEditorAction.setToolTipText(UIMessages.Italic_toolTip);
        retargetEditorAction.setActionDefinitionId(CMD_ITALIC);
        retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("tool.italic"));
        retargetEditorAction.setDisabledImageDescriptor(UIImages.getImageDescriptor("tool.italic.disabled"));
        this.registerAction(retargetEditorAction);
        retargetEditorAction = new RetargetEditorAction(UNDERLINE, UIMessages.Underline_text, 2);
        retargetEditorAction.setToolTipText(UIMessages.Underline_toolTip);
        retargetEditorAction.setActionDefinitionId(CMD_UNDERLINE);
        retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("tool.underline"));
        retargetEditorAction.setDisabledImageDescriptor(UIImages.getImageDescriptor("tool.underline.disabled"));
        this.registerAction(retargetEditorAction);
        this.registerAction(new SetColorRetargetAction(FORECOLOR));
        this.registerAction(new SetColorRetargetAction(BACKCOLOR));
        this.registerAction(new TextAlignRetargetAction(TEXT_ALIGN));
        if (!bl) {
            this.registerAction(new AlignmentRetargetAction(LAYOUT_ALIGN));
            this.registerAction(new MatchSizeRetargetAction(MATCH_SIZE));
        } else {
            retargetEditorAction = new RetargetEditorAction(INDENT, UIMessages.Indent_text);
            retargetEditorAction.setToolTipText(UIMessages.Indent_toolTip);
            retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("indent.gif"));
            this.registerAction(retargetEditorAction);
            retargetEditorAction = new RetargetEditorAction(OUTDENT, UIMessages.Outdent_text);
            retargetEditorAction.setToolTipText(UIMessages.Outdent_toolTip);
            retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("outdent.gif"));
            this.registerAction(retargetEditorAction);
            retargetEditorAction = new RetargetEditorAction(ORDERED_LIST, UIMessages.Numbered_text, 2);
            retargetEditorAction.setToolTipText(UIMessages.Numbered_toolTip);
            retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("orderedlist.gif"));
            this.registerAction(retargetEditorAction);
            retargetEditorAction = new RetargetEditorAction(UNORDERED_LIST, UIMessages.Bulleted_text, 2);
            retargetEditorAction.setToolTipText(UIMessages.Bulleted_toolTip);
            retargetEditorAction.setImageDescriptor(UIImages.getImageDescriptor("unorderedlist.gif"));
            this.registerAction(retargetEditorAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager = iActionBars.getMenuManager().findMenuUsingPath(M_FORMAT);
        if (iMenuManager == null) {
            iMenuManager = new MenuManager(UIMessages.FormatMenu_Text, M_FORMAT);
            iActionBars.getMenuManager().insertBefore("window", (IContributionItem)iMenuManager);
        }
        this.contributeToMenu(iMenuManager);
        this.contributeToToolBar(iActionBars.getToolBarManager());
    }

    public IContributionItem getContributionItem(String string, boolean bl) {
        if (bl) {
            if (FORECOLOR.equals(string) || BACKCOLOR.equals(string)) {
                return new DropDownToolBarItem((IDropDownAction)this.getAction(string));
            }
        } else if (TEXT_ALIGN.equals(string) || LAYOUT_ALIGN.equals(string) || MATCH_SIZE.equals(string)) {
            return new GroupActionMenuItem(this.getAction(string));
        }
        return super.getContributionItem(string, bl);
    }

    protected void contributeToMenu(IMenuManager iMenuManager) {
        iMenuManager.add(this.getAction(BOLD));
        iMenuManager.add(this.getAction(ITALIC));
        iMenuManager.add(this.getAction(UNDERLINE));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.getAction(FORECOLOR));
        iMenuManager.add(this.getAction(BACKCOLOR));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new GroupActionMenuItem(this.getAction(TEXT_ALIGN)));
        if (!this.forHtml) {
            iMenuManager.add((IContributionItem)new GroupActionMenuItem(this.getAction(LAYOUT_ALIGN)));
            iMenuManager.add((IContributionItem)new GroupActionMenuItem(this.getAction(MATCH_SIZE)));
        }
    }

    protected void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add(this.getAction(BOLD));
        iToolBarManager.add(this.getAction(ITALIC));
        iToolBarManager.add(this.getAction(UNDERLINE));
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IContributionItem)new DropDownToolBarItem((IDropDownAction)this.getAction(FORECOLOR)));
        iToolBarManager.add((IContributionItem)new DropDownToolBarItem((IDropDownAction)this.getAction(BACKCOLOR)));
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add(this.getAction(TEXT_ALIGN));
        if (!this.forHtml) {
            iToolBarManager.add(this.getAction(LAYOUT_ALIGN));
            iToolBarManager.add(this.getAction(MATCH_SIZE));
        } else {
            iToolBarManager.add((IContributionItem)new Separator());
            iToolBarManager.add(this.getAction(ORDERED_LIST));
            iToolBarManager.add(this.getAction(UNORDERED_LIST));
            iToolBarManager.add((IContributionItem)new Separator());
            iToolBarManager.add(this.getAction(OUTDENT));
            iToolBarManager.add(this.getAction(INDENT));
        }
    }
}

