/*
 * Decompiled with CFR 0.152.
 */
package com.spket.internal.win32;

import com.spket.internal.win32.Lib;
import com.spket.util.IRenderer;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Renderer
implements IRenderer {
    private BufferedImage fImage;

    public BufferedImage createImage(int n, int n2) {
        Rectangle rectangle;
        int n3 = (n + 3) / 4 * 4;
        int n4 = n2;
        if (this.fImage != null && this.fImage.getWidth() >= n3 && this.fImage.getHeight() >= n4) {
            return this.fImage;
        }
        Display display = Display.getCurrent();
        if (display != null && (rectangle = display.getBounds()) != null) {
            if (n3 < rectangle.width && (n3 = rectangle.width) % 4 != 0) {
                n3 = (n3 + 3) / 4 * 4;
            }
            if (n4 < rectangle.height) {
                n4 = rectangle.height;
            }
        }
        this.fImage = new BufferedImage(n3, n4, 2);
        return this.fImage;
    }

    public boolean drawImage(GC gC, BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Rectangle rectangle = gC.getClipping();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        if (rectangle == null) {
            rectangle = rectangle2;
            n2 = 0;
            n = 0;
        } else {
            if (!rectangle2.intersects(rectangle)) {
                return true;
            }
            rectangle2.intersect(rectangle);
            if (rectangle2.width == 0 || rectangle2.height == 0) {
                return true;
            }
            n = rectangle2.x - n;
            n2 = rectangle2.y - n2;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster == null) {
            return false;
        }
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer != null) {
            switch (dataBuffer.getDataType()) {
                case 3: {
                    Lib.SetDIBitsToDeviceInt(gC.handle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n, n2, ((DataBufferInt)dataBuffer).getData(), n3, n4);
                    return true;
                }
                case 1: {
                    Lib.SetDIBitsToDeviceShort(gC.handle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n, n2, ((DataBufferUShort)dataBuffer).getData(), n3, n4);
                    return true;
                }
                case 0: {
                    Lib.SetDIBitsToDeviceByte(gC.handle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n, n2, ((DataBufferByte)dataBuffer).getData(), n3, n4);
                    return true;
                }
            }
        }
        return false;
    }
}

