/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.wizards;

import com.spket.xpc.internal.XPCMessages;
import com.spket.xpc.internal.XPCPlugin;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewExtensionProjectPage
extends WizardNewProjectCreationPage {
    private String fPath;
    private Text fPathField;

    public NewExtensionProjectPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Composite composite2 = (Composite)this.getControl();
        Group group = new Group(composite2, 0);
        group.setText(XPCMessages.Firefox_label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(XPCMessages.Firefox_location);
        this.fPathField = new Text((Composite)group, 2052);
        this.fPathField.setLayoutData((Object)new GridData(768));
        IPreferenceStore iPreferenceStore = XPCPlugin.getDefault().getPreferenceStore();
        this.fPath = iPreferenceStore.getString("ff.dir");
        if (this.fPath != null) {
            this.fPathField.setText(this.fPath);
        }
        Button button = new Button((Composite)group, 8);
        button.setText(XPCMessages.Browse_text);
        this.setButtonLayoutData(button);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (24 == event.type) {
                    NewExtensionProjectPage.this.onPathChanged(event);
                } else {
                    NewExtensionProjectPage.this.onBrowse(event);
                }
            }
        };
        this.fPathField.addListener(24, listener);
        button.addListener(13, listener);
    }

    public String getFirefoxDirectory() {
        return this.fPath;
    }

    protected void onPathChanged(Event event) {
        this.fPath = this.fPathField.getText();
        this.setPageComplete(this.validatePage());
    }

    protected void onBrowse(Event event) {
        String string;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fPathField.getShell(), 4096);
        if (this.fPath != null && this.fPath.length() > 0) {
            directoryDialog.setFilterPath(this.fPath);
        }
        if ((string = directoryDialog.open()) != null) {
            this.fPathField.setText(string);
        }
    }

    protected boolean validatePage() {
        boolean bl = super.validatePage();
        if (bl && this.fPath != null && this.fPath.length() > 0) {
            if (Path.ROOT.isValidPath(this.fPath)) {
                File file = new File(this.fPath);
                if (!file.exists() && !file.isDirectory()) {
                    this.setMessage(XPCMessages.Path_not_exists, 2);
                    return true;
                }
            } else {
                this.setErrorMessage(XPCMessages.Path_invalid);
                return false;
            }
        }
        return bl;
    }
}

