/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.cview;

import com.spket.js.internal.JSImages;
import com.spket.js.model.Flags;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSFunction;
import com.spket.util.IDragSource;
import com.spket.xpc.cview.CVElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CVMember
extends CVElement
implements Comparable {
    private static Image imgConst;
    private static Image imgField;
    private static Image imgReadonly;
    private static Image imgFunc;
    private ISlot slot;
    private String name;

    public CVMember(String string, ISlot iSlot) {
        this.name = string;
        this.slot = iSlot;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        int n = this.slot.getFlags();
        if (Flags.isStatic((int)n)) {
            if (imgConst == null) {
                imgConst = JSImages.getImage((ImageDescriptor)JSImages.DESC_OBJS_FIELD, (int)2);
            }
            return imgConst;
        }
        if (this.slot.getObject() instanceof JSFunction) {
            return imgFunc;
        }
        return Flags.isReadonly((int)n) ? imgReadonly : imgField;
    }

    public String toSource(int n) {
        if (3 == n) {
            return this.name;
        }
        if (Flags.isStatic((int)this.slot.getFlags())) {
            return ((IDragSource)this.getParent()).toSource(2) + '.' + this.name;
        }
        if (this.slot.getObject() instanceof JSFunction) {
            return this.name + "()";
        }
        return this.name;
    }

    public String getDocument() {
        Object object = this.slot.getData((Object)ISlot.P_COMMENT);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    protected ISlot getSlot() {
        return this.slot;
    }

    public int compareTo(Object object) {
        CVMember cVMember = (CVMember)object;
        ISlot iSlot = cVMember.slot;
        if (Flags.isStatic((int)this.slot.getFlags())) {
            if (Flags.isStatic((int)iSlot.getFlags())) {
                return this.name.compareTo(cVMember.name);
            }
            return -1;
        }
        if (Flags.isStatic((int)iSlot.getFlags())) {
            return 1;
        }
        if (this.slot.getObject() instanceof JSFunction) {
            if (!(iSlot.getObject() instanceof JSFunction)) {
                return 1;
            }
        } else if (iSlot.getObject() instanceof JSFunction) {
            return -1;
        }
        return this.name.compareTo(cVMember.name);
    }

    static {
        imgField = JSImages.get((String)"c.s.js.field_public_obj.gif");
        imgReadonly = JSImages.get((String)"c.s.js.field_private_obj.gif");
        imgFunc = JSImages.get((String)"c.s.js.function_obj.gif");
    }
}

