/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.util;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.internal.compiler.util.SuffixConstants;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Util
implements SuffixConstants {
    public static final String UTF_8 = "UTF-8";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static char[] LINE_SEPARATOR_CHARS = LINE_SEPARATOR.toCharArray();
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String EMPTY_STRING = new String(CharOperation.NO_CHAR);
    private static final char[] DOUBLE_QUOTES = "''".toCharArray();
    private static final char[] SINGLE_QUOTE = "'".toCharArray();
    private static final int DEFAULT_READING_SIZE = 8192;
    protected static ResourceBundle bundle;
    private static final String bundleName = "com.spket.as.internal.compiler.util.messages";

    public static String bind(String string, String string2, String string3) {
        return Util.bind(string, new String[]{string2, string3});
    }

    public static String bind(String string, String string2) {
        return Util.bind(string, new String[]{string2});
    }

    public static String bind(String string, String[] stringArray) {
        StringBuffer stringBuffer;
        block15: {
            if (string == null) {
                return "No message available";
            }
            String string2 = null;
            try {
                string2 = bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + string + " in: " + bundleName;
            }
            char[] cArray = CharOperation.replace(string2.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (stringArray == null) {
                return new String(cArray);
            }
            int n = cArray.length;
            int n2 = 0;
            int n3 = n;
            stringBuffer = null;
            while ((n3 = CharOperation.indexOf('{', cArray, n2)) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n + stringArray.length * 20);
                }
                stringBuffer.append(cArray, n2, n3 - n2);
                n2 = CharOperation.indexOf('}', cArray, n3 + 1);
                if (n2 > -1) {
                    int n4 = -1;
                    String string3 = new String(cArray, n3 + 1, n2 - n3 - 1);
                    try {
                        n4 = Integer.parseInt(string3);
                        stringBuffer.append(stringArray[n4]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        boolean bl = false;
                        if (!string.equals(string3)) {
                            String string4 = null;
                            try {
                                string4 = bundle.getString(string3);
                                stringBuffer.append(string4);
                                bl = true;
                            }
                            catch (MissingResourceException missingResourceException) {
                                // empty catch block
                            }
                        }
                        if (!bl) {
                            stringBuffer.append(cArray, n3 + 1, n2 - n3);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        stringBuffer.append("{missing " + Integer.toString(n4) + "}");
                    }
                    ++n2;
                    continue;
                }
                stringBuffer.append(cArray, n3, n);
                break block15;
            }
            if (stringBuffer == null) {
                return new String(cArray);
            }
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    public static String bind(String string) {
        return Util.bind(string, (String[])null);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public static char[] bytesToChar(byte[] byArray, String string) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(byArray), byArray.length, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)file.length());
                Object var4_3 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(bufferedInputStream, (int)file.length(), string);
                Object var5_4 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n) throws IOException {
        byte[] byArray;
        if (n == -1) {
            byArray = new byte[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n2 + n4];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                if ((n3 = inputStream.read(byArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 != -1);
            if (n2 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray3, 0, byArray, 0, n2);
            }
        } else {
            byArray = new byte[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStream.read(byArray, n5 += n6, n - n5);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n == -1) {
            int n2;
            cArray = CharOperation.NO_CHAR;
            int n3 = 0;
            int n4 = -1;
            do {
                if (n3 + (n2 = Math.max(inputStream.available(), 8192)) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n3 + n2];
                    System.arraycopy(cArray2, 0, cArray, 0, n3);
                }
                if ((n4 = inputStreamReader.read(cArray, n3, n2)) <= 0) continue;
                n3 += n4;
            } while (n4 != -1);
            n2 = 0;
            if (UTF_8.equals(string) && cArray[0] == '\ufeff') {
                --n3;
                n2 = 1;
            }
            if (n3 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n3];
                System.arraycopy(cArray3, n2, cArray, 0, n3);
            }
        } else {
            cArray = new char[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStreamReader.read(cArray, n5 += n6, n - n5);
            }
            int n7 = 0;
            if (UTF_8.equals(string) && cArray[0] == '\ufeff') {
                --n5;
                n7 = 1;
            }
            if (n5 != n) {
                char[] cArray4 = cArray;
                cArray = new char[n5];
                System.arraycopy(cArray4, n7, cArray, 0, n5);
            }
        }
        return cArray;
    }

    public static int getLineNumber(int n, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return 1;
        }
        if (n3 == -1) {
            return 1;
        }
        int n4 = n2;
        while (n2 <= n3) {
            n4 = n2 + (n3 - n2) / 2;
            int n5 = nArray[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            return n4 + 1;
        }
        if (n < nArray[n4]) {
            return n4 + 1;
        }
        return n4 + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipEntryByteContent(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)zipEntry.getSize());
                Object var5_4 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SuffixConstants.SUFFIX_JAR.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(n2 - i - 1);
            if (c == SuffixConstants.SUFFIX_jar[n3 = n - i - 1] || c == SuffixConstants.SUFFIX_JAR[n3]) continue;
            n = SuffixConstants.SUFFIX_ZIP.length;
            if (n2 < n) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                c = string.charAt(n2 - j - 1);
                if (c == SuffixConstants.SUFFIX_zip[n3 = n - j - 1] || c == SuffixConstants.SUFFIX_ZIP[n3]) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static final boolean isClassFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SuffixConstants.SUFFIX_CLASS.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(n2 - i - 1);
            if (c == SuffixConstants.SUFFIX_class[n3 = n - i - 1] || c == SuffixConstants.SUFFIX_CLASS[n3]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SuffixConstants.SUFFIX_CLASS.length)) {
            return false;
        }
        int n3 = n2 - n;
        for (int i = 0; i < n; ++i) {
            char c = cArray[n3 + i];
            if (c == SuffixConstants.SUFFIX_class[i] || c == SuffixConstants.SUFFIX_CLASS[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaFileName(String string) {
        int n;
        int n2 = string == null ? 0 : string.length();
        if (n2 < (n = SuffixConstants.SUFFIX_JAVA.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            char c = string.charAt(n2 - i - 1);
            if (c == SuffixConstants.SUFFIX_java[n3 = n - i - 1] || c == SuffixConstants.SUFFIX_JAVA[n3]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaFileName(char[] cArray) {
        int n;
        int n2 = cArray == null ? 0 : cArray.length;
        if (n2 < (n = SuffixConstants.SUFFIX_JAVA.length)) {
            return false;
        }
        int n3 = n2 - n;
        for (int i = 0; i < n; ++i) {
            char c = cArray[n3 + i];
            if (c == SuffixConstants.SUFFIX_java[i] || c == SuffixConstants.SUFFIX_JAVA[i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object[] objectArray) {
        return Util.toString(objectArray, new Displayable(){

            public String displayString(Object object) {
                if (object == null) {
                    return "null";
                }
                return object.toString();
            }
        });
    }

    public static String toString(Object[] objectArray, Displayable displayable) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(displayable.displayString(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    public static Boolean toBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        Util.relocalize();
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

