/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.util;

import com.spket.as.core.compiler.CharOperation;

public final class HashtableOfObject
implements Cloneable {
    public char[][] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfObject() {
        this(13);
    }

    public HashtableOfObject(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new Object[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObject hashtableOfObject = (HashtableOfObject)super.clone();
        hashtableOfObject.elementSize = this.elementSize;
        hashtableOfObject.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfObject.keyTable = new char[n][];
        System.arraycopy(this.keyTable, 0, hashtableOfObject.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfObject.valueTable = new Object[n];
        System.arraycopy(this.valueTable, 0, hashtableOfObject.valueTable, 0, n);
        return hashtableOfObject;
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return false;
    }

    public Object get(char[] cArray) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        return null;
    }

    public Object put(char[] cArray, Object object) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n] = object;
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        this.keyTable[n] = cArray;
        this.valueTable[n] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    public Object removeKey(char[] cArray) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                Object object = this.valueTable[n];
                --this.elementSize;
                this.keyTable[n] = null;
                this.valueTable[n] = null;
                this.rehash();
                return object;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return null;
    }

    private void rehash() {
        HashtableOfObject hashtableOfObject = new HashtableOfObject(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfObject.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfObject.keyTable;
        this.valueTable = hashtableOfObject.valueTable;
        this.threshold = hashtableOfObject.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.valueTable[i];
            if (object == null) continue;
            string = string + new String(this.keyTable[i]) + " -> " + object.toString() + "\n";
        }
        return string;
    }
}

