/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.problem;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.CompilationResult;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.lookup.InvocationSite;
import com.spket.as.internal.compiler.problem.ProblemHandler;

public class AbortCompilation
extends RuntimeException {
    private static final long serialVersionUID = 7567959645538552416L;
    public CompilationResult compilationResult;
    public Throwable exception;
    public IProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, IProblem iProblem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = iProblem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable throwable) {
        this();
        this.compilationResult = compilationResult;
        this.exception = throwable;
    }

    public AbortCompilation(boolean bl, RuntimeException runtimeException) {
        this();
        this.isSilent = bl;
        this.silentException = runtimeException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(compilationResult.lineSeparatorPositions, invocationSite.sourceStart()));
        this.compilationResult = compilationResult;
    }

    public void updateContext(ASTNode aSTNode, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(aSTNode.sourceStart());
        this.problem.setSourceEnd(aSTNode.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(compilationResult.lineSeparatorPositions, aSTNode.sourceStart()));
        this.compilationResult = compilationResult;
    }
}

