/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.AttributeStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.lookup.Frame;

public class VariableBinding
extends AttributeStatement {
    public char[] name;
    public Expression type;
    public Expression initializer;
    public boolean constant;

    public VariableBinding(char[] cArray, long l) {
        this.name = cArray;
        this.sourceStart = (int)(l >>> 32);
        this.declarationEnd = this.sourceEnd = (int)l;
    }

    public VariableBinding(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.declarationEnd = this.sourceEnd = n2;
    }

    public int getDeclarationEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceEnd() {
        return this.declarationSourceEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationSourceStart;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.name != null) {
            stringBuffer.append(this.name);
        }
        if (this.type != null) {
            stringBuffer.append(':');
            this.type.printExpression(0, stringBuffer);
        }
        if (this.initializer != null) {
            stringBuffer.append(" = ");
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            if (this.type != null) {
                this.type.traverse(aSTVisitor, frame);
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

