/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.BlockScope;
import com.spket.as.internal.compiler.lookup.Frame;

public class TryStatement
extends Statement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Parameter[] catchParameters;
    public Block finallyBlock;
    BlockScope frame;

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        TryStatement.printIndent(n, stringBuffer).append("try \n");
        this.tryBlock.printStatement(n + 1, stringBuffer);
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                stringBuffer.append('\n');
                TryStatement.printIndent(n, stringBuffer).append("catch (");
                this.catchParameters[i].print(0, stringBuffer).append(") ");
                this.catchBlocks[i].printStatement(n + 1, stringBuffer);
            }
        }
        if (this.finallyBlock != null) {
            stringBuffer.append('\n');
            TryStatement.printIndent(n, stringBuffer).append("finally\n");
            this.finallyBlock.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            this.tryBlock.traverse(aSTVisitor, this.frame);
            if (this.catchParameters != null) {
                int n = this.catchBlocks.length;
                for (int i = 0; i < n; ++i) {
                    this.catchParameters[i].traverse(aSTVisitor, this.frame);
                    this.catchBlocks[i].traverse(aSTVisitor, this.frame);
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(aSTVisitor, this.frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

