/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.Assignment;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.OperatorIds;
import com.spket.as.internal.compiler.lookup.Frame;

public class CompoundAssignment
extends Assignment
implements OperatorIds {
    public int operator;
    public int preAssignImplicitConversion;

    public CompoundAssignment(Expression expression, Expression expression2, int n, int n2) {
        super(expression, expression2, n2);
        expression.bits &= 0xFFFFDFFF;
        expression.bits |= 0x10000;
        this.operator = n;
    }

    public String operatorToString() {
        switch (this.operator) {
            case 14: {
                return "+=";
            }
            case 13: {
                return "-=";
            }
            case 15: {
                return "*=";
            }
            case 9: {
                return "/=";
            }
            case 2: {
                return "&=";
            }
            case 3: {
                return "|=";
            }
            case 8: {
                return "^=";
            }
            case 16: {
                return "%=";
            }
            case 10: {
                return "<<=";
            }
            case 17: {
                return ">>=";
            }
            case 19: {
                return ">>>=";
            }
        }
        return "unknown operator";
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        this.lhs.printExpression(n, stringBuffer).append(' ').append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            this.lhs.traverse(aSTVisitor, frame);
            this.expression.traverse(aSTVisitor, frame);
        }
        aSTVisitor.endVisit(this, frame);
    }
}

