/*
 * Decompiled with CFR 0.152.
 */
package com.spket.util;

public class IntMap
implements Cloneable {
    private int[] modes;
    private Object object;
    private Object[] objects;

    public IntMap() {
        this(4);
    }

    public IntMap(int n) {
        if (n < 0) {
            n = 0;
        }
        this.modes = new int[n];
        this.objects = new Object[n];
    }

    public void clear() {
        this.modes = new int[0];
        this.object = null;
        this.objects = new Object[0];
    }

    public Object get(int n) {
        if (n == 0) {
            return this.object;
        }
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i] != n) continue;
            return this.objects[i];
        }
        return null;
    }

    public void set(int n, Object object) {
        int n2;
        if (n == 0) {
            this.object = object;
            return;
        }
        if (object == null) {
            this.remove(n);
            return;
        }
        int n3 = -1;
        for (n2 = 0; n2 < this.modes.length; ++n2) {
            if (this.modes[n2] == n) {
                this.objects[n2] = object;
                return;
            }
            if (this.modes[n2] != 0) continue;
            n3 = n2;
        }
        if (n3 != -1) {
            this.modes[n3] = n;
            this.objects[n3] = object;
            return;
        }
        n2 = this.modes.length;
        int[] nArray = new int[n2 + 4];
        System.arraycopy(this.modes, 0, nArray, 0, n2);
        this.modes = nArray;
        Object[] objectArray = new Object[n2 + 4];
        System.arraycopy(this.objects, 0, objectArray, 0, n2);
        this.objects = objectArray;
        this.modes[n2] = n;
        this.objects[n2] = object;
    }

    public boolean isSet(int n) {
        if (n == 0) {
            return this.object != null;
        }
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i] != n) continue;
            return true;
        }
        return false;
    }

    public Object remove(int n) {
        Object object = null;
        if (n == 0) {
            object = this.object;
            this.object = null;
        } else {
            for (int i = 0; i < this.modes.length; ++i) {
                if (this.modes[i] != n) continue;
                object = this.objects[i];
                this.modes[i] = 0;
                this.objects[i] = null;
            }
        }
        return object;
    }

    public boolean isEmpty() {
        if (this.modes == null || this.modes.length == 0) {
            return true;
        }
        if (this.object == null) {
            return false;
        }
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntMap intMap = (IntMap)super.clone();
        if (this.modes != null && this.modes.length > 0) {
            intMap.modes = new int[this.modes.length];
            System.arraycopy(this.modes, 0, intMap.modes, 0, this.modes.length);
            intMap.objects = new Object[this.objects.length];
            System.arraycopy(this.objects, 0, intMap.objects, 0, this.objects.length);
        }
        return intMap;
    }
}

