/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.xml.XMLConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class XMLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2 {
    private int fOffset;
    private int fLength;
    private String fText;
    private Image fImage;
    private int fCursorPosition;
    private boolean fIsEmptyTag;
    private String fDisplayString;
    private String fNamespace;
    private String fProposalInfo;
    private char[] fTriggerCharacters;

    public XMLCompletionProposal(int n, int n2, String string, Image image) {
        this(n, n2, string.length(), string, string, image);
    }

    public XMLCompletionProposal(int n, int n2, int n3, String string, String string2, Image image) {
        this.fOffset = n;
        this.fLength = n2;
        this.fText = string;
        this.fDisplayString = string2;
        this.fImage = image;
        this.fCursorPosition = n3;
    }

    public XMLCompletionProposal(int n, int n2, String string, Image image, boolean bl, String string2) {
        this.fOffset = n;
        this.fLength = n2;
        this.fDisplayString = string;
        this.fImage = image;
        this.fIsEmptyTag = bl;
        this.fNamespace = string2;
    }

    public void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.fOffset + this.fLength);
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        if ((n & SWT.MOD1) != 0) {
            this.fIsEmptyTag = !this.fIsEmptyTag;
        }
        this.apply(iTextViewer.getDocument(), c, n2);
    }

    public void apply(IDocument iDocument, char c, int n) {
        this.calc();
        if (this.fText == null) {
            return;
        }
        if (n > this.fOffset + this.fLength) {
            this.fLength = n - this.fOffset;
        }
        if (c != ';' && this.fOffset > 0) {
            try {
                if (iDocument.getChar(this.fOffset - 1) == '&') {
                    this.fText = this.fText + ';';
                    ++this.fCursorPosition;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        switch (c) {
            case ':': {
                int n2 = this.fText.indexOf(c);
                if (n2 == -1) break;
                this.fText = this.fText.substring(0, n2 + 1);
                this.fCursorPosition = n2 + 1;
                break;
            }
            case '<': {
                StringBuffer stringBuffer = new StringBuffer(this.fText);
                stringBuffer.insert(this.fCursorPosition, '<');
                ++this.fCursorPosition;
                this.fText = stringBuffer.toString();
                break;
            }
            case ' ': {
                int n3 = this.fText.length();
                if (n3 > 0 && this.fText.charAt(0) == '<') {
                    if (n3 > 1 && this.fText.charAt(1) == '/') break;
                    StringBuffer stringBuffer = new StringBuffer(this.fText);
                    if (this.fIsEmptyTag) {
                        if (this.fCursorPosition > 1) {
                            --this.fCursorPosition;
                            stringBuffer.insert(this.fCursorPosition - 1, ' ');
                        }
                    } else if (this.fCursorPosition > 0) {
                        stringBuffer.insert(this.fCursorPosition - 1, ' ');
                    }
                    this.fText = stringBuffer.toString();
                    break;
                }
                this.fText = this.fText + ' ';
                this.fCursorPosition = this.fText.length();
                break;
            }
            case '\'': {
                this.fText = this.fText.replace('\"', '\'');
                break;
            }
            case '/': {
                if (n - this.fOffset != 1 || this.fText.length() <= 1 || this.fText.charAt(0) != '<' || this.fText.charAt(1) == '/') break;
                this.fText = "</";
                this.fCursorPosition = 2;
                break;
            }
        }
        try {
            iDocument.replace(this.fOffset, this.fLength, this.fText);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public int getContextInformationPosition() {
        return this.fOffset;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharacters = cArray;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        return this.validate(iDocument, n, null);
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        if (n < this.fOffset) {
            return false;
        }
        boolean bl = this.startsWith(iDocument, n, this.fDisplayString);
        if (bl && documentEvent != null) {
            int n2 = (documentEvent.fText == null ? 0 : documentEvent.fText.length()) - documentEvent.fLength;
            this.fLength += n2;
        }
        return bl;
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public String getAdditionalProposalInfo() {
        return this.fProposalInfo;
    }

    public void setAdditionalProposalInfo(String string) {
        this.fProposalInfo = string;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument iDocument) {
        this.calc();
        return new Point(this.fOffset + this.fCursorPosition, 0);
    }

    protected boolean startsWith(IDocument iDocument, int n, String string) {
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n > this.fOffset + n2 + 1) {
            return false;
        }
        int n4 = n - this.fOffset;
        if (n4 == 0) {
            return this.fLength == 0;
        }
        String string2 = null;
        try {
            string2 = iDocument.get(this.fOffset, n4);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (string2 != null && string != null && string.length() > 0) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            char c = string.charAt(0);
            char c2 = string2.charAt(0);
            if (c == ' ' || c == '<' && c2 != '<') {
                return string.startsWith(string2, 1);
            }
            if (c != '<' && c2 == '<') {
                string2 = string2.substring(1);
            }
            if (string.startsWith(string2)) {
                return true;
            }
            int n5 = string.indexOf(58);
            if (n5 > 0) {
                return string.startsWith(string2, n5 + 1);
            }
        }
        return false;
    }

    protected void calc() {
        if (this.fText == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('<').append(this.fDisplayString);
            if (this.fNamespace != null) {
                int n = this.fDisplayString.indexOf(58);
                stringBuffer.append(' ').append(XMLConstants.PREFIX_XMLNS);
                if (n != -1) {
                    stringBuffer.append(':').append(this.fDisplayString.substring(0, n));
                }
                stringBuffer.append('=').append('\"').append(this.fNamespace).append('\"');
            }
            if (this.fIsEmptyTag) {
                stringBuffer.append("/>");
                this.fCursorPosition = stringBuffer.length();
            } else {
                this.fCursorPosition = stringBuffer.length() + 1;
                stringBuffer.append("></").append(this.fDisplayString).append('>');
            }
            this.fText = stringBuffer.toString();
        }
    }
}

