/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.grammars.xsd;

import com.spket.xml.grammars.CMContent;
import com.spket.xml.grammars.CMDocument;
import com.spket.xml.grammars.CMElement;
import com.spket.xml.grammars.CMNamedNodeMap;
import com.spket.xml.grammars.CMNode;
import com.spket.xml.grammars.NSNodeMap;
import com.spket.xml.grammars.xsd.XSDAttribute;
import com.spket.xml.grammars.xsd.XSDDocument;
import java.util.HashSet;
import java.util.Set;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDElement
implements CMElement {
    private XSDDocument document;
    private XSElementDeclaration elemDecl;
    private CMNamedNodeMap attrs;
    private CMNamedNodeMap children;
    private Set substitutions;

    public XSDElement(XSDDocument xSDDocument, XSElementDeclaration xSElementDeclaration) {
        this.document = xSDDocument;
        this.elemDecl = xSElementDeclaration;
    }

    public CMDocument getDocument() {
        return this.document;
    }

    public String getNodeName() {
        return this.elemDecl.getName();
    }

    public int getNodeType() {
        return 5;
    }

    public String getNamespace() {
        return this.elemDecl.getNamespace();
    }

    public Object getProperty(Object object) {
        if (CMNode.SUBSTITUTIONS.equals(object)) {
            return this.substitutions;
        }
        return null;
    }

    public CMNamedNodeMap getAttributes() {
        if (this.attrs == null) {
            this.prepareAttributes();
        }
        return this.attrs;
    }

    public int getMaxOccur() {
        return 0;
    }

    public int getMinOccur() {
        return 0;
    }

    public CMContent getContent() {
        return null;
    }

    public int getContentType() {
        XSTypeDefinition xSTypeDefinition = this.elemDecl.getTypeDefinition();
        if (xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 15) {
            switch (((XSComplexTypeDefinition)xSTypeDefinition).getContentType()) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 1: {
                    return 5;
                }
            }
        }
        return 1;
    }

    public CMNamedNodeMap getElements() {
        if (this.children == null) {
            this.prepareChildren();
        }
        return this.children;
    }

    protected void prepareAttributes() {
        this.attrs = new NSNodeMap(null);
        XSTypeDefinition xSTypeDefinition = this.elemDecl.getTypeDefinition();
        if (xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 15) {
            XSObjectList xSObjectList = ((XSComplexTypeDefinition)xSTypeDefinition).getAttributeUses();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(i);
                if (xSAttributeUse.getAttrDeclaration() == null) continue;
                this.attrs.put(new XSDAttribute((CMDocument)this.document, xSAttributeUse));
            }
        }
    }

    protected void prepareChildren() {
        XSParticleDecl xSParticleDecl;
        this.children = new NSNodeMap(this.getNamespace());
        XSTypeDefinition xSTypeDefinition = this.elemDecl.getTypeDefinition();
        if (xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 15 && (xSParticleDecl = (XSParticleDecl)((XSComplexTypeDefinition)xSTypeDefinition).getParticle()) != null) {
            this.addParticle(xSParticleDecl, this.children);
        }
    }

    protected void processGroup(XSModelGroup xSModelGroup, CMNamedNodeMap cMNamedNodeMap) {
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            this.addParticle((XSParticleDecl)xSObjectList.item(i), cMNamedNodeMap);
        }
    }

    protected void addParticle(XSParticleDecl xSParticleDecl, CMNamedNodeMap cMNamedNodeMap) {
        if (xSParticleDecl.fType == 1) {
            XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSParticleDecl.getTerm();
            if (xSElementDeclaration.getAbstract()) {
                if (this.substitutions == null) {
                    this.substitutions = new HashSet(4);
                }
                this.substitutions.add(xSElementDeclaration.getName());
                XSNamedMap xSNamedMap = this.document.grammar.getComponents((short)2);
                for (int i = 0; i < xSNamedMap.getLength(); ++i) {
                    XSElementDeclaration xSElementDeclaration2 = (XSElementDeclaration)xSNamedMap.item(i);
                    if (xSElementDeclaration2.getAbstract() || xSElementDeclaration2.getSubstitutionGroupAffiliation() != xSElementDeclaration) continue;
                    this.children.put(new XSDElement(this.document, xSElementDeclaration2));
                }
            } else {
                this.children.put(new XSDElement(this.document, xSElementDeclaration));
            }
        } else if (xSParticleDecl.fType == 3) {
            this.processGroup((XSModelGroup)xSParticleDecl.getTerm(), this.children);
        }
    }
}

