/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.grammars;

import com.spket.util.StringUtils;
import com.spket.xml.PairKey;
import com.spket.xml.grammars.CMNamedNodeMap;
import com.spket.xml.grammars.CMNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NSNodeMap
implements CMNamedNodeMap {
    private String namespace;
    private Map nodes;
    private Map others;

    public NSNodeMap(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CMNode getNamedItem(String string) {
        return this.getNamedItem(this.namespace, string);
    }

    public CMNode getNamedItem(String string, String string2) {
        if (StringUtils.equals((Object)this.namespace, (Object)string)) {
            if (this.nodes == null) {
                return null;
            }
            return (CMNode)this.nodes.get(string2);
        }
        if (this.others == null) {
            return null;
        }
        return (CMNode)this.others.get(new PairKey(string, string2));
    }

    public Iterator iterator() {
        if (this.nodes != null) {
            if (this.others == null) {
                return this.nodes.values().iterator();
            }
            return new Iterators(this.nodes.values().iterator(), this.others.values().iterator());
        }
        if (this.others != null) {
            return this.others.values().iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public void put(CMNode cMNode) {
        String string = cMNode.getNamespace();
        if (StringUtils.equals((Object)this.namespace, (Object)string)) {
            if (this.nodes == null) {
                this.nodes = new HashMap();
            }
            this.nodes.put(cMNode.getNodeName(), cMNode);
        } else {
            if (this.others == null) {
                this.others = new HashMap();
            }
            this.others.put(new PairKey(string, cMNode.getNodeName()), cMNode);
        }
    }

    public int size() {
        int n = 0;
        if (this.nodes != null) {
            n = this.nodes.size();
        }
        return n;
    }

    private static class Iterators
    implements Iterator {
        private int index;
        private Iterator[] iterators;

        public Iterators(Iterator iterator, Iterator iterator2) {
            this.iterators = new Iterator[]{iterator, iterator2};
        }

        public boolean hasNext() {
            if (this.index < this.iterators.length) {
                if (this.iterators[this.index].hasNext()) {
                    return true;
                }
                ++this.index;
                if (this.index < this.iterators.length) {
                    return this.iterators[this.index].hasNext();
                }
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.iterators[this.index].next();
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

