/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.editors;

import com.spket.ui.editors.PlainTextEditor;
import com.spket.ui.text.IFoldingSupport;
import com.spket.ui.text.IProblemRequestor;
import com.spket.ui.text.TextTools;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.editors.XMLOutlinePage;
import com.spket.xml.internal.XMLPlugin;
import com.spket.xml.internal.text.XMLFoldingSupport;
import com.spket.xml.internal.text.correction.TagNameAssistProposal;
import com.spket.xml.text.XMLSourceViewerConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class XMLEditor
extends PlainTextEditor {
    private XMLModel fModel = this.createModel();

    public XMLModel getModel() {
        return this.fModel;
    }

    public void dispose() {
        if (this.fModel != null) {
            this.fModel.dispose();
            this.fModel = null;
        }
        super.dispose();
    }

    public void reconcile() {
        super.reconcile();
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof IProblemRequestor) {
            this.fModel.reconcile((IProblemRequestor)iAnnotationModel);
        }
    }

    public ICompletionProposal findCorrection(String string) {
        if ("com.spket.ui.correction.renameInFile.assist".equals(string)) {
            return new TagNameAssistProposal(this.getModel());
        }
        return super.findCorrection(string);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            this.fModel.setProject(((IFileEditorInput)iEditorInput).getFile().getProject());
        }
        this.fModel.setPath(this.getPath());
    }

    protected XMLModel createModel() {
        return new XMLModel();
    }

    protected void initializeEditor() {
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration(iPreferenceStore));
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = "com.spket.xml.pref.editor";
        stringArray2[1] = "com.spket.xml.pref.color";
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        return stringArray2;
    }

    protected IContentOutlinePage createContentOutlinePage() {
        return new XMLOutlinePage(this);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        return new XMLSourceViewerConfiguration(this, this.getTextTools().getColorManager(), iPreferenceStore, this.getDocumentPartitioning());
    }

    protected String getDocumentPartitioning() {
        return "___xml_partitioning";
    }

    public TextTools getTextTools() {
        return XMLPlugin.getDefault().getTextTools();
    }

    protected boolean isFoldingEnabled() {
        return XMLPlugin.getDefault().getPreferenceStore().getBoolean("xml_folding");
    }

    protected IFoldingSupport createFoldingSupport() {
        return new XMLFoldingSupport(this.getModel());
    }

    protected XMLNode getNode() {
        if (this.fModel == null) {
            return null;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return null;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int n = 0;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            n = iTextViewerExtension5.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int n2 = iSourceViewer.getVisibleRegion().getOffset();
            n = n2 + styledText.getCaretOffset();
        }
        int n3 = n;
        int n4 = 0;
        Point point = iSourceViewer.getSelectedRange();
        if (point != null && point.x != -1 && point.y != -1) {
            n3 = point.x;
            n4 = point.y;
        }
        return this.getNode(n3, n4, n);
    }

    protected XMLNode getNode(int n, int n2, int n3) {
        if (this.fModel == null) {
            return null;
        }
        XMLNode xMLNode = null;
        if (n2 > 0) {
            xMLNode = XMLUtils.findNode(this.fModel, n, null);
            if (xMLNode != null && xMLNode.getNodeType() != 0) {
                INodeRegion iNodeRegion = xMLNode.getRegion();
                if (xMLNode.getNodeType() != 1 && iNodeRegion.contains(n + n2) == 0) {
                    return xMLNode;
                }
                if (iNodeRegion.getStart() == n && iNodeRegion.getLength() == n2) {
                    return xMLNode;
                }
            }
            if (n != n3) {
                xMLNode = XMLUtils.findNode(this.fModel, n3, null);
            }
        } else {
            xMLNode = XMLUtils.findNode(this.fModel, n3, null);
        }
        return xMLNode;
    }

    protected void onSourceSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.fContentOutlinePage == null) {
            return;
        }
        XMLNode xMLNode = this.getNode();
        this.fContentOutlinePage.setSelection((ISelection)(xMLNode == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)xMLNode)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOutlineSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StyledText styledText = null;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null) {
            styledText = iSourceViewer.getTextWidget();
        }
        if (styledText == null) {
            return;
        }
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            int[] nArray = this.getRegion(((IStructuredSelection)iSelection).getFirstElement());
            if (nArray == null || nArray.length < 2) {
                return;
            }
            int n = nArray[0];
            int n2 = nArray[1];
            if (n >= 0 && n2 >= 0) {
                int n3 = nArray.length > 2 ? nArray[2] : 0;
                IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
                IWorkbenchPart iWorkbenchPart = iWorkbenchWindow.getPartService().getActivePart();
                boolean bl = iWorkbenchPart == null || !iWorkbenchPart.equals((Object)this);
                this.setHighlightRange(n, n2, false);
                if (bl) {
                    try {
                        styledText.setRedraw(false);
                        iSourceViewer.revealRange(n, n3);
                        iSourceViewer.setSelectedRange(n, n3);
                    }
                    finally {
                        styledText.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
            }
        }
    }

    protected int[] getRegion(Object object) {
        if (object instanceof XMLNode) {
            INodeRegion iNodeRegion;
            XMLNode xMLNode = (XMLNode)object;
            if (2 == xMLNode.getNodeType()) {
                xMLNode = xMLNode.getParent();
            }
            if (0 != xMLNode.getNodeType() && (iNodeRegion = xMLNode.getRegion()) != null) {
                return new int[]{iNodeRegion.getStart(), iNodeRegion.getLength()};
            }
        }
        return null;
    }

    protected void openDeclaration(int n) {
    }
}

