/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.PairRegion;
import com.spket.xml.ParentNode;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLNode;

public class XMLElement
extends ParentNode {
    protected static final XMLAttr[] EMPTY_ATTRS = new XMLAttr[0];
    protected String fName;
    protected String fNamespace;
    protected boolean fIsEmptyTag;
    protected INodeRegion fEndTagRegion;
    protected int fAttrCount;
    protected XMLAttr[] fAttrs = EMPTY_ATTRS;

    public XMLElement() {
    }

    public XMLElement(String string) {
        this.fName = string;
    }

    public XMLElement(String string, String string2) {
        this.fNamespace = string;
        this.fName = string2;
    }

    public String getName() {
        return this.fName;
    }

    protected void setName(String string) {
        this.fName = string;
    }

    public String getNamespace() {
        return this.fNamespace;
    }

    protected void setNamespace(String string) {
        this.fNamespace = string;
    }

    public String getLocalName() {
        int n = this.fName.indexOf(58);
        return n < 0 ? this.fName : this.fName.substring(n + 1);
    }

    public String getPrefix() {
        int n = this.fName.indexOf(58);
        return n < 0 ? null : this.fName.substring(0, n);
    }

    public short getNodeType() {
        return 1;
    }

    public boolean isEmptyTag() {
        return this.fIsEmptyTag;
    }

    public boolean hasStartTag() {
        return this.fRegion != null;
    }

    public void setEmptyTag(boolean bl) {
        this.fIsEmptyTag = bl;
    }

    public INodeRegion getStartTagRegion() {
        return this.fRegion;
    }

    public void setStartTagRegion(INodeRegion iNodeRegion) {
        this.fRegion = iNodeRegion;
    }

    public INodeRegion getEndTagRegion() {
        return this.fEndTagRegion;
    }

    public void setEndTagRegion(INodeRegion iNodeRegion) {
        this.fEndTagRegion = iNodeRegion;
    }

    public INodeRegion getRegion() {
        if (this.fIsEmptyTag) {
            return this.fRegion;
        }
        if (this.fEndTagRegion == null) {
            return this.fRegion;
        }
        if (this.fRegion == null) {
            return this.fEndTagRegion;
        }
        return new PairRegion(this.fRegion, this.fEndTagRegion);
    }

    public void setRegion(INodeRegion iNodeRegion) {
    }

    public void appendAttribute(XMLAttr xMLAttr) {
        if (this.fAttrCount == this.fAttrs.length) {
            XMLAttr[] xMLAttrArray = new XMLAttr[this.fAttrCount + 2];
            System.arraycopy(this.fAttrs, 0, xMLAttrArray, 0, this.fAttrCount);
            this.fAttrs = xMLAttrArray;
        }
        this.fAttrs[this.fAttrCount] = xMLAttr;
        xMLAttr.fParent = this;
        ++this.fAttrCount;
    }

    public int getAttrCount() {
        return this.fAttrCount;
    }

    public XMLAttr[] getAttrs() {
        return this.fAttrs;
    }

    public XMLAttr[] getAttrNodes() {
        if (this.fAttrCount == this.fAttrs.length) {
            return this.fAttrs;
        }
        XMLAttr[] xMLAttrArray = new XMLAttr[this.fAttrCount];
        System.arraycopy(this.fAttrs, 0, xMLAttrArray, 0, this.fAttrCount);
        return xMLAttrArray;
    }

    public XMLAttr getAttr(String string) {
        if (this.fAttrCount > 0 && string != null) {
            for (int i = 0; i < this.fAttrCount; ++i) {
                if (!string.equals(this.fAttrs[i].getName())) continue;
                return this.fAttrs[i];
            }
        }
        return null;
    }

    protected boolean isSame(XMLNode xMLNode) {
        int n;
        XMLNode[] xMLNodeArray;
        if (this.getNodeType() != xMLNode.getNodeType()) {
            return false;
        }
        XMLElement xMLElement = (XMLElement)xMLNode;
        if (this.isEmptyTag() != xMLElement.isEmptyTag() || this.getAttrCount() != xMLElement.getAttrCount() || this.getChildrenCount() != xMLElement.getChildrenCount()) {
            return false;
        }
        if (!StringUtils.equals((Object)this.getName(), (Object)xMLElement.getName())) {
            return false;
        }
        if (!StringUtils.equals((Object)this.getStartTagRegion(), (Object)xMLElement.getStartTagRegion())) {
            return false;
        }
        if (!StringUtils.equals((Object)this.getEndTagRegion(), (Object)xMLElement.getEndTagRegion())) {
            return false;
        }
        if (this.fAttrCount > 0) {
            xMLNodeArray = xMLElement.getAttrs();
            for (n = 0; n < this.fAttrCount; ++n) {
                if (this.fAttrs[n].isSame(xMLNodeArray[n])) continue;
                return false;
            }
        }
        if (this.fChildrenCount > 0) {
            xMLNodeArray = xMLElement.getChildren();
            for (n = 0; n < this.fChildrenCount; ++n) {
                if (this.fChildren[n].isSame(xMLNodeArray[n])) continue;
                return false;
            }
        }
        return true;
    }
}

