/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferReader;
import com.spket.xml.XMLUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DTD {
    private static final char[] COMMENT = "--".toCharArray();
    private static final char[] ENTITY = "ENTITY".toCharArray();
    private static final char[] SYSTEM = "SYSTEM".toCharArray();
    private Map systems;
    private Map entities;
    private IBuffer buffer;
    private int fOffset;
    private int fLength;

    public DTD(IBuffer iBuffer) {
        this.buffer = iBuffer;
        this.fLength = -1;
    }

    public DTD(IBuffer iBuffer, int n, int n2) {
        this.buffer = iBuffer;
        this.fOffset = n;
        this.fLength = n2;
    }

    public String getValue(String string) {
        this.prepare();
        return (String)this.entities.get(string);
    }

    public Collection getSystems() {
        this.prepare();
        return this.systems.values();
    }

    public Collection getNames() {
        this.prepare();
        return this.entities.keySet();
    }

    public void reset(boolean bl) {
        this.systems = null;
        this.entities = null;
        if (bl) {
            this.buffer = null;
        }
    }

    protected void prepare() {
        if (this.entities == null) {
            IBufferReader iBufferReader;
            this.systems = Collections.EMPTY_MAP;
            this.entities = Collections.EMPTY_MAP;
            if (this.buffer != null && this.buffer.getLength() > 0 && (iBufferReader = this.fLength == -1 ? this.buffer.createReader() : this.buffer.createReader(this.fOffset, this.fLength)) != null) {
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                this.parse(iBufferReader, hashMap2, hashMap);
                if (hashMap.size() > 0) {
                    this.systems = hashMap;
                }
                if (hashMap2.size() > 0) {
                    this.entities = hashMap2;
                }
            }
        }
    }

    protected void parse(IBufferReader iBufferReader, Map map, Map map2) {
        int n;
        this.skipSpaces(iBufferReader);
        do {
            if ((n = iBufferReader.read()) != 60) continue;
            if (iBufferReader.skip('!')) {
                String string;
                if (iBufferReader.skip(COMMENT)) {
                    this.scanComment(iBufferReader);
                    continue;
                }
                if (!iBufferReader.skip(ENTITY)) continue;
                this.skipSpaces(iBufferReader);
                if (iBufferReader.skip('%')) {
                    this.skipSpaces(iBufferReader);
                }
                if ((string = this.scanName(iBufferReader)) != null) {
                    String string2;
                    this.skipSpaces(iBufferReader);
                    boolean bl = false;
                    if (iBufferReader.skip(SYSTEM)) {
                        bl = true;
                        this.skipSpaces(iBufferReader);
                    }
                    if ((string2 = this.scanLiteral(iBufferReader)) != null) {
                        if (bl) {
                            map2.put(string, string2);
                        } else {
                            map.put(string, string2);
                        }
                    }
                }
                while ((n = iBufferReader.read()) != 62 && n != -1) {
                }
                continue;
            }
            if (!iBufferReader.skip('?')) continue;
            this.scanPI(iBufferReader);
        } while (n != -1);
    }

    protected String scanLiteral(IBufferReader iBufferReader) {
        int n = iBufferReader.peek();
        if (n == 39 || n == 34) {
            int n2;
            iBufferReader.read();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = iBufferReader.read()) != n && n2 != 60 && n2 != -1) {
                stringBuffer.append((char)n2);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected boolean skipSpaces(IBufferReader iBufferReader) {
        int n = iBufferReader.read();
        if (XMLUtils.isSpace(n)) {
            while ((n = iBufferReader.read()) != -1) {
                if (XMLUtils.isSpace(n)) continue;
                iBufferReader.unread();
                break;
            }
            return true;
        }
        if (n != -1) {
            iBufferReader.unread();
        }
        return false;
    }

    protected void scanComment(IBufferReader iBufferReader) {
        int n;
        int n2 = -1;
        int n3 = -1;
        do {
            if ((n = iBufferReader.read()) == 62 && n2 == 45 && n3 == 45) {
                return;
            }
            n3 = n2;
            n2 = n;
        } while (n != -1);
    }

    protected String scanName(IBufferReader iBufferReader) {
        int n = iBufferReader.peek();
        if (XMLUtils.isValidNameStartChar(n)) {
            iBufferReader.read();
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append((char)n);
            while (XMLUtils.isValidNameChar(n = iBufferReader.peek())) {
                iBufferReader.read();
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected void scanPI(IBufferReader iBufferReader) {
        int n;
        this.scanName(iBufferReader);
        int n2 = -1;
        while ((n = iBufferReader.read()) != 62 || n2 != 63) {
            n2 = n;
            if (n != -1) continue;
        }
    }
}

