/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import java.io.IOException;
import java.io.Writer;

public class XMLString {
    private static int hash0 = 0;
    private static int hash1 = 0;
    private static final int HASH_0 = 31;
    private static final int HASH_1 = 37;
    static final String EMPTY_STRING = "";

    private XMLString() {
    }

    static int getHash0() {
        return hash0;
    }

    static int getHash1() {
        return hash1;
    }

    static int hash(String s, boolean ignoreWhitespaces, boolean caseSensitive) {
        hash0 = 0;
        hash1 = 0;
        if (s == null) {
            return 0;
        }
        int j = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ignoreWhitespaces && ch <= ' ') continue;
            if (!caseSensitive) {
                ch = Character.toUpperCase(ch);
            }
            hash0 = hash0 * 31 + ch;
            hash1 = hash1 * 37 + ch;
            ++j;
        }
        return j;
    }

    static int hash(String s) {
        hash0 = 0;
        hash1 = 0;
        if (s == null) {
            return 0;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            hash0 = hash0 * 31 + ch;
            hash1 = hash1 * 37 + ch;
        }
        return len;
    }

    static boolean isEmpty(String s) {
        return s == null || EMPTY_STRING.equals(s.trim());
    }

    static void normalize(Writer writer, String s, boolean isAttr) throws IOException {
        if (s != null) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                XMLString.normalize(writer, c, isAttr);
            }
        }
    }

    private static void normalize(Writer writer, char c, boolean isAttr) throws IOException {
        switch (c) {
            case '<': {
                writer.write("&lt;");
                break;
            }
            case '>': {
                writer.write("&gt;");
                break;
            }
            case '&': {
                writer.write("&amp;");
                break;
            }
            case '\r': {
                writer.write("&#xD;");
                break;
            }
            case '\u0001': 
            case '\u0002': {
                if (!isAttr) break;
                writer.write(34);
                break;
            }
            case '\"': {
                if (!isAttr) break;
                writer.write("&quot;");
                break;
            }
            default: {
                writer.write(c);
            }
        }
    }
}

