DECLARE @userID int
SET NOCOUNT ON
INSERT INTO [User] (Name, Password, Email, Active) VALUES ('Administrator', 'XshnEC500MdsGjw38JeJdlN6AII=', '', 1)
SET @userID = (SELECT @@IDENTITY)
SET NOCOUNT OFF
INSERT INTO UserRole (UserRoleID, UserID) VALUES (0, @userID)
GO

INSERT INTO ProductInformation (ProductInformationData)
	   VALUES ('j14UgH9MdAJbV3YVJP91YO/PGNdBgzADoIvGd+qDZclFeaG3G1GZnkQ2uy6Luh/J')
GO

--Item Priorities
INSERT ItemPriority (Name) VALUES ('Low')
INSERT ItemPriority (Name) VALUES ('Medium')
INSERT ItemPriority (Name) VALUES ('High')
INSERT ItemPriority (Name) VALUES ('Immediate')
GO

--Item Severities
INSERT ItemSeverity (Name) VALUES ('Low')
INSERT ItemSeverity (Name) VALUES ('Medium')
INSERT ItemSeverity (Name) VALUES ('High')
INSERT ItemSeverity (Name) VALUES ('None')
GO

--Item Status
INSERT ItemStatus (StartStatus, Name) VALUES (1, 'Open')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Fixed')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Closed')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Reopened')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Not a problem')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Withdrawn')
INSERT ItemStatus (StartStatus, Name) VALUES (1, 'On hold')
INSERT ItemStatus (StartStatus, Name) VALUES (0, 'Duplicate')
GO

--Item Status Transitions
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (1, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (2, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (3, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (3, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (4, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (5, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (6, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (7, -1)
INSERT ItemStatusTransition (FromItemStatusID, ToItemStatusID) VALUES (8, -1)
GO

--Item Types
INSERT [ItemType] (Name) VALUES ('Feature Request')
INSERT [ItemType] (Name) VALUES ('Bug')
GO

--Binary Resource Types
INSERT BinaryResourceType (ID, Name) VALUES (0, 'Document')
INSERT BinaryResourceType (ID, Name) VALUES (1, 'Deployment')
GO

--Filter Types
INSERT FilterType (ID, Name) VALUES (0, 'Item')
INSERT FilterType (ID, Name) VALUES (1, 'Document')
INSERT FilterType (ID, Name) VALUES (2, 'Deployment')
GO

--Document Resource Status
INSERT DocumentResourceStatus (StartStatus, Name) VALUES (1, 'Draft')
INSERT DocumentResourceStatus (StartStatus, Name) VALUES (1, 'Final')
GO

--Document Resource Status Transitions
INSERT DocumentResourceStatusTransition (FromDocumentResourceStatusID, ToDocumentResourceStatusID) VALUES (1, 2)
INSERT DocumentResourceStatusTransition (FromDocumentResourceStatusID, ToDocumentResourceStatusID) VALUES (2, -1)
GO

--Deployment Resource Status
INSERT DeploymentResourceStatus (StartStatus, Name) VALUES (1, 'Dev')
INSERT DeploymentResourceStatus (StartStatus, Name) VALUES (0, 'QA')
INSERT DeploymentResourceStatus (StartStatus, Name) VALUES (0, 'Production')
GO

--Deployment Resource Status Transitions
INSERT DeploymentResourceStatusTransition (FromDeploymentResourceStatusID, ToDeploymentResourceStatusID) VALUES (1, 2)
INSERT DeploymentResourceStatusTransition (FromDeploymentResourceStatusID, ToDeploymentResourceStatusID) VALUES (2, 3)
GO


--Groups
INSERT [Group] (Name) VALUES ('Full Rights')
INSERT [Group] (Name) VALUES ('Change Rights')
INSERT [Group] (Name) VALUES ('Delete Rights')
GO

--Assign the administrator user to 'FULL' group
DECLARE @userID int
SET @userID = (SELECT ID FROM [User] WHERE Name = 'Administrator')
DECLARE @groupID int
SET @groupID = (SELECT ID FROM [Group] WHERE Name = 'Full Rights')
INSERT UserGroup (UserID, GroupID)
       VALUES (@userID, @groupID)
--Setting the permissions for FULL group
SET @groupID = (SELECT ID FROM [Group] WHERE Name = 'Full Rights')
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 0)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 1)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 2)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 3)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 4)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 5)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 6)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 7)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 8)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 9)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 10)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 11)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 12)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 13)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 14)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 15)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 16)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 17)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 18)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 19)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 20)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 21)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 22)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 23)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 24)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 25)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 26)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 27)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 28)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 29)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 30)
              
--Setting the permissions for CHANGE group
SET @groupID = (SELECT ID FROM [Group] WHERE Name = 'Change Rights')
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 0)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 1)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 2)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 9)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 10)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 11)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 12)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 13)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 18)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 19)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 20)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 25)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 26)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 27)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 28)
       
--Setting the permissions for DELETE group
SET @groupID = (SELECT ID FROM [Group] WHERE Name = 'Delete Rights')
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 4)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 6)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 8)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 13)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 15)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 17)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 22)
INSERT GroupPermission (GroupID, PermissionID)
       VALUES (@groupID, 30)
GO
