#include "Libexcel.h"
#include <iostream>
#include <conio.h>

using namespace std;
using namespace Libexcel;

Workbook* xls;

void showPattern(Worksheet* sheet, wstring name, Format::Pattern pattern) 
{
	static int row = 0;		
	Format* format = xls->addFormat();			
	format->setPattern(pattern);	
	sheet->write(row, 0, name);
	sheet->write(row, 1, L"", format);
	row++;
}

void showColor(Worksheet* sheet, wstring name, int color)
{
	static int row = 0;
	Format* format = xls->addFormat();	
	format->setBold();
	format->setTextColor(color);
	sheet->write(row, 0, name, format);
	format = xls->addFormat();	
	format->setBold();
	format->setBgColor(color);
	sheet->write(row, 1, name, format);
	row++;
}

void showBorder(Worksheet* sheet, wstring name, Format::Border border, int color)
{
	static int row = 1;
	sheet->setRow(row, 40);

	Format* format = xls->addFormat();			
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setBorder(border);
	sheet->write(row, 1, name, format);

	format = xls->addFormat();	
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setBorder(border);
	format->setBorderColor(color);
	sheet->write(row, 3, name, format);

	format = xls->addFormat();			
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setBorder(border);
	format->setLeftColor(Format::COLOR_BLACK);
	format->setTopColor(Format::COLOR_RED);
	format->setRightColor(Format::COLOR_BLUE);
	format->setBottomColor(Format::COLOR_GREEN);
	sheet->write(row, 5, name, format);

	format = xls->addFormat();				
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setLeft(Format::BORDER_THIN);
	format->setTop(Format::BORDER_THICK);
	format->setRight(Format::BORDER_SUPERTHICK);
	format->setBottom(Format::BORDER_DOT);
	format->setLeftColor(Format::COLOR_BLACK);
	format->setTopColor(Format::COLOR_RED);
	format->setRightColor(Format::COLOR_BLUE);
	format->setBottomColor(Format::COLOR_GREEN);
	
	sheet->write(row, 7, L"Combination", format);

	row += 2;
}

void showNumFormat(Worksheet* sheet, wstring name, Format::NumFormat numformat, wstring value = L"5000.4")
{
	static int row = 0;

	sheet->write(row, 0, name);	
	Format* format = xls->addFormat();								
	format->setNumFormat(numformat);
	sheet->write(row, 1, value, format);	

	row++;
}


void example() 
{
	Worksheet* sheet = xls->addWorksheet(L"Example");
	sheet->setLandscape();
	xls->setCustomColor(55, 0x33, 0x66, 0x99);

	Format* logoFormat = xls->addFormat();
	logoFormat->setSize(30);
	logoFormat->setBgColor(55);
	logoFormat->setTextColor(Format::COLOR_WHITE);

	sheet->write(0, 0, L"Libexcel", logoFormat);

	Format* logoDateFormat = xls->addFormat();
	logoDateFormat->setAlign(Format::ALIGN_RIGHT, Format::ALIGN_TOP);
	logoDateFormat->setNumFormat(Format::NUMFORMAT_CUSTOM_MDYYYY_HMM);
	logoDateFormat->setBgColor(55);
	logoDateFormat->setTextColor(Format::COLOR_WHITE);

	sheet->write(L"H1", L"=now()", logoDateFormat);

	sheet->setMerge(0, 0, 0, 6);
	sheet->setMerge(1, 0, 1, 7);

	Format* headerFormat = xls->addFormat();
	headerFormat->setBorder(Format::BORDER_THIN);
	headerFormat->setBgColor(Format::COLOR_YELLOW);
	headerFormat->setBold();
	headerFormat->setAlignH(Format::ALIGN_CENTER);

	sheet->write(2, 0, L"No", headerFormat);
	sheet->write(2, 1, L"Date", headerFormat);
	sheet->write(2, 2, L"City", headerFormat);
	sheet->write(2, 3, L"Delivery", headerFormat);
	sheet->write(2, 4, L"Name", headerFormat);
	sheet->write(2, 5, L"Cost", headerFormat);
	sheet->write(2, 6, L"Qty", headerFormat);
	sheet->write(2, 7, L"Total", headerFormat);

	sheet->setColumn(0, 0, 5);
	sheet->setColumn(1, 1, 15);
	sheet->setColumn(2, 2, 15);
	sheet->setColumn(3, 3, 15);
	sheet->setColumn(4, 4, 15);
	sheet->setColumn(5, 5, 15);
	sheet->setColumn(7, 7, 15);
		
	Format* dateFormat = xls->addFormat();
	dateFormat->setNumFormat(Format::NUMFORMAT_DATE_MDY);
	
	for(int row = 3; row < 13; ++row) {
		sheet->write(row, 0, row-2);
		sheet->write(row, 1, L"06/28/2008", dateFormat);			
	}

	Format* textFormat = xls->addFormat();
	textFormat->setAlignH(Format::ALIGN_RIGHT);

	sheet->write(3, 2, L"London", textFormat);
	sheet->write(4, 2, L"New York", textFormat);
	sheet->write(5, 2, L"Tokyo", textFormat);
	sheet->write(6, 2, L"London", textFormat);
	sheet->write(7, 2, L"Paris", textFormat);
	sheet->write(8, 2, L"Los Angeles", textFormat);
	sheet->write(9, 2, L"New York", textFormat);
	sheet->write(10, 2, L"Moscow", textFormat);
	sheet->write(11, 2, L"New York", textFormat);
	sheet->write(12, 2, L"London", textFormat);

	sheet->write(3, 3, L"airplane", textFormat);
	sheet->write(4, 3, L"railway", textFormat);
	sheet->write(5, 3, L"sea", textFormat);
	sheet->write(6, 3, L"airplane", textFormat);
	sheet->write(7, 3, L"car", textFormat);
	sheet->write(8, 3, L"airplane", textFormat);
	sheet->write(9, 3, L"railway", textFormat);
	sheet->write(10, 3, L"car", textFormat);
	sheet->write(11, 3, L"airplane", textFormat);
	sheet->write(12, 3, L"airplane", textFormat);

	sheet->write(3, 4, L"monitor", textFormat);
	sheet->write(4, 4, L"washing machine", textFormat);
	sheet->write(5, 4, L"bananas", textFormat);
	sheet->write(6, 4, L"dvd player", textFormat);
	sheet->write(7, 4, L"tv", textFormat);
	sheet->write(8, 4, L"computer", textFormat);
	sheet->write(9, 4, L"fridge", textFormat);
	sheet->write(10, 4, L"air-conditioner", textFormat);
	sheet->write(11, 4, L"cpu", textFormat);
	sheet->write(12, 4, L"camera", textFormat);
	
	Format* formatMoney = xls->addFormat();
	formatMoney->setNumFormat(Format::NUMFORMAT_CURRENCY_NEGBRA);
	
	sheet->write(3, 5, 250, formatMoney);
	sheet->write(4, 5, 420, formatMoney);
	sheet->write(5, 5, 1.65, formatMoney);
	sheet->write(6, 5, 130, formatMoney);
	sheet->write(7, 5, 1340, formatMoney);
	sheet->write(8, 5, 900, formatMoney);
	sheet->write(9, 5, 650, formatMoney);
	sheet->write(10, 5, 580, formatMoney);
	sheet->write(11, 5, 180, formatMoney);
	sheet->write(12, 5, 300, formatMoney);
	
	sheet->write(3, 6, 12);
	sheet->write(4, 6, 50);
	sheet->write(5, 6, 4600);
	sheet->write(6, 6, 800);
	sheet->write(7, 6, 170);
	sheet->write(8, 6, 230);
	sheet->write(9, 6, 800);
	sheet->write(10, 6, 20);
	sheet->write(11, 6, 1000);
	sheet->write(12, 6, 2500);
	
	sheet->write(3, 7, L"=F4*G4", formatMoney);
	sheet->write(4, 7, L"=F5*G5", formatMoney);
	sheet->write(5, 7, L"=F6*G6", formatMoney);
	sheet->write(6, 7, L"=F7*G7", formatMoney);
	sheet->write(7, 7, L"=F8*G8", formatMoney);
	sheet->write(8, 7, L"=F9*G9", formatMoney);
	sheet->write(9, 7, L"=F10*G10", formatMoney);
	sheet->write(10, 7, L"=F11*G11", formatMoney);
	sheet->write(11, 7, L"=F12*G12", formatMoney);
	sheet->write(12, 7, L"=F13*G13", formatMoney);
	
	Format* totalLabelFormat = xls->addFormat();
	totalLabelFormat->setBold();
	totalLabelFormat->setAlignH(Format::ALIGN_RIGHT);

	sheet->write(L"G15", L"Total:", totalLabelFormat);

	Format* totalValueFormat = xls->addFormat();
	totalValueFormat->setBold();
	totalValueFormat->setBgColor(Format::COLOR_BRIGHTGREEN);
	totalValueFormat->setNumFormat(Format::NUMFORMAT_CURRENCY_NEGBRA);

	sheet->write(L"H15", L"=SUM(H4:H13)", totalValueFormat);
	
	sheet->protect("1");
}


void patterns() 
{	
	Worksheet* sheet = xls->addWorksheet(L"Patterns");			
		
	sheet->setColumn(0, 1, 35);
	
	showPattern(sheet, L"PATTERN_NOBACKGROUND", Format::PATTERN_NOBACKGROUND);		
	showPattern(sheet, L"PATTERN_SOLID", Format::PATTERN_SOLID);		
	showPattern(sheet, L"PATTERN_GRAY75", Format::PATTERN_GRAY75);		
	showPattern(sheet, L"PATTERN_GRAY50", Format::PATTERN_GRAY50);		
	showPattern(sheet, L"PATTERN_GRAY25", Format::PATTERN_GRAY25);		
	showPattern(sheet, L"PATTERN_GRAY12P5", Format::PATTERN_GRAY12P5);		
	showPattern(sheet, L"PATTERN_GRAY6P25", Format::PATTERN_GRAY6P25);		
	showPattern(sheet, L"PATTERN_HORSTRIPE", Format::PATTERN_HORSTRIPE);		
	showPattern(sheet, L"PATTERN_VERSTIPE", Format::PATTERN_VERSTIPE);		
	showPattern(sheet, L"PATTERN_REVDIAGSTRIPE", Format::PATTERN_REVDIAGSTRIPE);		
	showPattern(sheet, L"PATTERN_DIAGSTRIPE", Format::PATTERN_DIAGSTRIPE);		
	showPattern(sheet, L"PATTERN_DIAGCROSSHATCH", Format::PATTERN_DIAGCROSSHATCH);		
	showPattern(sheet, L"PATTERN_THICKDIAGCROSSHATCH", Format::PATTERN_THICKDIAGCROSSHATCH);		
	showPattern(sheet, L"PATTERN_THINHORSTRIPE", Format::PATTERN_THINHORSTRIPE);		
	showPattern(sheet, L"PATTERN_THINVERSTRIPE", Format::PATTERN_THINVERSTRIPE);		
	showPattern(sheet, L"PATTERN_THINREVDIAGSTRIPE", Format::PATTERN_THINREVDIAGSTRIPE);		
	showPattern(sheet, L"PATTERN_THINDIAGSTRIPE", Format::PATTERN_THINDIAGSTRIPE);		
	showPattern(sheet, L"PATTERN_THINHORCROSSHATCH", Format::PATTERN_THINHORCROSSHATCH);		
	showPattern(sheet, L"PATTERN_THINDIAGCROSSHATCH", Format::PATTERN_THINDIAGCROSSHATCH);			
}

void colors() 
{
	Worksheet* sheet = xls->addWorksheet(L"Colors");
	sheet->setColumn(0, 2, 35);
	
	showColor(sheet, L"COLOR_BLACK", Format::COLOR_BLACK);
	showColor(sheet, L"COLOR_WHITE", Format::COLOR_WHITE);
	showColor(sheet, L"COLOR_RED", Format::COLOR_RED);
	showColor(sheet, L"COLOR_BRIGHTGREEN", Format::COLOR_BRIGHTGREEN);
	showColor(sheet, L"COLOR_BLUE", Format::COLOR_BLUE);
	showColor(sheet, L"COLOR_YELLOW", Format::COLOR_YELLOW);
	showColor(sheet, L"COLOR_PINK", Format::COLOR_PINK);
	showColor(sheet, L"COLOR_TURQUOISE", Format::COLOR_TURQUOISE);
	showColor(sheet, L"COLOR_DARKRED", Format::COLOR_DARKRED);
	showColor(sheet, L"COLOR_GREEN", Format::COLOR_GREEN);
	showColor(sheet, L"COLOR_DARKBLUE", Format::COLOR_DARKBLUE);
	showColor(sheet, L"COLOR_DARKYELLOW", Format::COLOR_DARKYELLOW);
	showColor(sheet, L"COLOR_VIOLET", Format::COLOR_VIOLET);
	showColor(sheet, L"COLOR_TEAL", Format::COLOR_TEAL);
	showColor(sheet, L"COLOR_GRAY25", Format::COLOR_GRAY25);
	showColor(sheet, L"COLOR_GRAY50", Format::COLOR_GRAY50);
	showColor(sheet, L"COLOR_PERIWINKLE_CF", Format::COLOR_PERIWINKLE_CF);
	showColor(sheet, L"COLOR_PLUM_CF", Format::COLOR_PLUM_CF);
	showColor(sheet, L"COLOR_IVORY_CF", Format::COLOR_IVORY_CF);
	showColor(sheet, L"COLOR_LIGHTTURQUOISE_CF", Format::COLOR_LIGHTTURQUOISE_CF);
	showColor(sheet, L"COLOR_DARKPURPLE_CF", Format::COLOR_DARKPURPLE_CF);
	showColor(sheet, L"COLOR_CORAL_CF", Format::COLOR_CORAL_CF);
	showColor(sheet, L"COLOR_OCEANBLUE_CF", Format::COLOR_OCEANBLUE_CF);
	showColor(sheet, L"COLOR_ICEBLUE_CF", Format::COLOR_ICEBLUE_CF);
	showColor(sheet, L"COLOR_DARKBLUE_CL", Format::COLOR_DARKBLUE_CL);
	showColor(sheet, L"COLOR_PINK_CL", Format::COLOR_PINK_CL);
	showColor(sheet, L"COLOR_YELLOW_CL", Format::COLOR_YELLOW_CL);
	showColor(sheet, L"COLOR_TURQUOISE_CL", Format::COLOR_TURQUOISE_CL);
	showColor(sheet, L"COLOR_VIOLET_CL", Format::COLOR_VIOLET_CL);
	showColor(sheet, L"COLOR_DARKRED_CL", Format::COLOR_DARKRED_CL);
	showColor(sheet, L"COLOR_TEAL_CL", Format::COLOR_TEAL_CL);
	showColor(sheet, L"COLOR_BLUE_CL", Format::COLOR_BLUE_CL);
	showColor(sheet, L"COLOR_SKYBLUE", Format::COLOR_SKYBLUE);
	showColor(sheet, L"COLOR_LIGHTTURQUOISE", Format::COLOR_LIGHTTURQUOISE);
	showColor(sheet, L"COLOR_LIGHTGREEN", Format::COLOR_LIGHTGREEN);
	showColor(sheet, L"COLOR_LIGHTYELLOW", Format::COLOR_LIGHTYELLOW);
	showColor(sheet, L"COLOR_PALEBLUE", Format::COLOR_PALEBLUE);
	showColor(sheet, L"COLOR_ROSE", Format::COLOR_ROSE);
	showColor(sheet, L"COLOR_LAVENDER", Format::COLOR_LAVENDER);
	showColor(sheet, L"COLOR_TAN", Format::COLOR_TAN);
	showColor(sheet, L"COLOR_LIGHTBLUE", Format::COLOR_LIGHTBLUE);
	showColor(sheet, L"COLOR_AQUA", Format::COLOR_AQUA);
	showColor(sheet, L"COLOR_LIME", Format::COLOR_LIME);
	showColor(sheet, L"COLOR_GOLD", Format::COLOR_GOLD);
	showColor(sheet, L"COLOR_LIGHTORANGE", Format::COLOR_LIGHTORANGE);
	showColor(sheet, L"COLOR_ORANGE", Format::COLOR_ORANGE);
	showColor(sheet, L"COLOR_BLUEGRAY", Format::COLOR_BLUEGRAY);
	showColor(sheet, L"COLOR_GRAY40", Format::COLOR_GRAY40);
	showColor(sheet, L"COLOR_DARKTEAL", Format::COLOR_DARKTEAL);
	showColor(sheet, L"COLOR_SEAGREEN", Format::COLOR_SEAGREEN);
	showColor(sheet, L"COLOR_DARKGREEN", Format::COLOR_DARKGREEN);
	showColor(sheet, L"COLOR_OLIVEGREEN", Format::COLOR_OLIVEGREEN);
	showColor(sheet, L"COLOR_BROWN", Format::COLOR_BROWN);
	showColor(sheet, L"COLOR_PLUM", Format::COLOR_PLUM);
	showColor(sheet, L"COLOR_INDIGO", Format::COLOR_INDIGO);
	showColor(sheet, L"COLOR_GRAY80", Format::COLOR_GRAY80);												
}

void borders() 
{
	Worksheet* sheet = xls->addWorksheet(L"Borders");
	sheet->setColumn(1, 1, 22);
	sheet->setColumn(3, 3, 22);
	sheet->setColumn(5, 5, 22);
	sheet->setColumn(7, 7, 22);		

	showBorder(sheet, L"BORDER_NONE", Format::BORDER_NONE, Format::COLOR_BLACK);
	showBorder(sheet, L"BORDER_THIN", Format::BORDER_THIN, Format::COLOR_RED);
	showBorder(sheet, L"BORDER_THICK", Format::BORDER_THICK, Format::COLOR_GREEN);
	showBorder(sheet, L"BORDER_DASH", Format::BORDER_DASH, Format::COLOR_BLUE);
	showBorder(sheet, L"BORDER_DOT", Format::BORDER_DOT, Format::COLOR_LIME);
	showBorder(sheet, L"BORDER_SUPERTHICK", Format::BORDER_SUPERTHICK, Format::COLOR_YELLOW);
	showBorder(sheet, L"BORDER_DOUBLE", Format::BORDER_DOUBLE, Format::COLOR_PINK);
}

void aligns()
{
	Worksheet* sheet = xls->addWorksheet(L"Aligns");

	sheet->setColumn(1, 1, 22);
	sheet->setColumn(3, 3, 22);
	sheet->setRow(1, 50);
	sheet->setRow(3, 50);
	sheet->setRow(5, 50);
	sheet->setRow(7, 50);
	sheet->setRow(9, 50);
	sheet->setRow(11, 50);
	sheet->setRow(13, 50);

	Format* format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_LEFT, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(1, 1, L"ALIGN_LEFT", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(3, 1, L"ALIGN_CENTER", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_RIGHT, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(5, 1, L"ALIGN_RIGHT", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_FILL, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(7, 1, L"ALIGN_FILL", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_JUSTIFY, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(9, 1, L"This cell use ALIGN_JUSTIFY style", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_MERGE, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(11, 1, L"This cell use ALIGN_MERGE style", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_EQUAL_SPACE, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(13, 1, L"This cell use ALIGN_EQUAL_SPACE style", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_TOP);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(1, 3, L"ALIGN_TOP", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VCENTER);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(3, 3, L"ALIGN_VCENTER", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_BOTTOM);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(5, 3, L"ALIGN_BOTTOM", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VJUSTIFY);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(7, 3, L"This cell use ALIGN_VJUSTIFY style", format);

	format = xls->addFormat();	
	format->setBold();
	format->setAlign(Format::ALIGN_CENTER, Format::ALIGN_VEQUAL_SPACE);
	format->setBgColor(Format::COLOR_TAN);
	sheet->write(9, 3, L"This cell use ALIGN_VEQUAL_SPACE style", format);
}

void fonts() 
{
	Worksheet* sheet = xls->addWorksheet(L"Fonts");
	
	Format* format = xls->addFormat();
	format->setSize(20);
	sheet->write(1, 1, L"Normal", format);

	format = xls->addFormat();
	format->setSize(20);
	format->setBold();
	sheet->write(2, 1, L"Bold", format);

	format = xls->addFormat();
	format->setSize(20);
	format->setItalic();
	sheet->write(3, 1, L"Italic", format);

	format = xls->addFormat();
	format->setSize(20);
	format->setUnderline();
	sheet->write(4, 1, L"Underline", format);

	format = xls->addFormat();
	format->setSize(20);
	format->setStrikeOut();
	sheet->write(5, 1, L"Strikeout", format);
	
	format = xls->addFormat();
	format->setSize(20);		
	sheet->write(1, 4, L"Arial", format);

	format = xls->addFormat();
	format->setSize(20);		
	format->setFont("Times");
	sheet->write(2, 4, L"Times", format);

	format = xls->addFormat();
	format->setSize(20);		
	format->setFont("Courier New");
	sheet->write(3, 4, L"Courier New", format);

	format = xls->addFormat();
	format->setSize(20);		
	format->setFont("Verdana");
	sheet->write(4, 4, L"Verdana", format);

	format = xls->addFormat();
	format->setSize(20);		
	format->setFont("Comic Sans MS");
	sheet->write(5, 4, L"Comic Sans MS", format);

	format = xls->addFormat();
	format->setSize(10);				
	sheet->write(1, 8, L"Size 10", format);

	format = xls->addFormat();
	format->setSize(15);				
	sheet->write(2, 8, L"Size 15", format);

	format = xls->addFormat();
	format->setSize(20);				
	sheet->write(3, 8, L"Size 20", format);

	format = xls->addFormat();
	format->setSize(25);				
	sheet->write(4, 8, L"Size 25", format);

	format = xls->addFormat();
	format->setSize(30);				
	sheet->write(5, 8, L"Size 30", format);

	format = xls->addFormat();		
	format->setTextRotation(10);
	format->setSize(20);
	sheet->write(7, 1, L"Rotation 10", format);

	format = xls->addFormat();		
	format->setTextRotation(45);
	format->setSize(20);
	sheet->write(7, 3, L"Rotation 45", format);

	format = xls->addFormat();		
	format->setTextRotation(90);
	format->setSize(20);
	sheet->write(7, 5, L"Rotation 90", format);

	format = xls->addFormat();		
	format->setTextRotation(-60);
	format->setSize(20);
	sheet->write(7, 7, L"Rotation -60", format);

	format = xls->addFormat();		
	format->setTextRotation(-90);
	format->setSize(20);
	sheet->write(7, 8, L"Rotation -90", format);

	format = xls->addFormat();		
	format->setTextRotation(0);
	format->setSize(12);
	sheet->write(7, 9, L"Vertical", format);

	format = xls->addFormat();				
	format->setSize(18);
	format->setScript(Format::SCRIPT_NONE);
	sheet->write(9, 1, L"SCRIPT_NONE", format);

	format = xls->addFormat();				
	format->setSize(18);
	format->setScript(Format::SCRIPT_SUPERSCRIPT);
	sheet->write(9, 4, L"SCRIPT_SUPERSCRIPT", format);

	format = xls->addFormat();				
	format->setSize(18);
	format->setScript(Format::SCRIPT_SUBSCRIPT);
	sheet->write(9, 7, L"SCRIPT_SUBSCRIPT", format);

	format = xls->addFormat();						
	sheet->write(11, 1, L"This is a default style", format);

	format = xls->addFormat();				
	format->setTextWrap();
	sheet->write(11, 9, L"This is a text wrap style", format);	
}

void numformats()
{
	Worksheet* sheet = xls->addWorksheet(L"NumFormats");

	sheet->setColumn(0, 0, 30);
	sheet->setColumn(1, 1, 22);

	showNumFormat(sheet, L"GENERAL", Format::NUMFORMAT_GENERAL, L"50.4");
	showNumFormat(sheet, L"NUMBER", Format::NUMFORMAT_NUMBER, L"300.724");
	showNumFormat(sheet, L"NUMBER_D2", Format::NUMFORMAT_NUMBER_D2, L"900");
	showNumFormat(sheet, L"NUMBER_SEP", Format::NUMFORMAT_NUMBER_SEP, L"9000000");
	showNumFormat(sheet, L"NUMBER_SEP_D2", Format::NUMFORMAT_NUMBER_SEP_D2, L"1200.85");
	showNumFormat(sheet, L"CURRENCY_NEGBRA", Format::NUMFORMAT_CURRENCY_NEGBRA, L"-600.5");
	showNumFormat(sheet, L"CURRENCY_NEGBRARED", Format::NUMFORMAT_CURRENCY_NEGBRARED, L"-600.5");
	showNumFormat(sheet, L"CURRENCY_D2_NEGBRA", Format::NUMFORMAT_CURRENCY_D2_NEGBRA, L"-600.5");
	showNumFormat(sheet, L"CURRENCY_D2_NEGBRARED", Format::NUMFORMAT_CURRENCY_D2_NEGBRARED, L"-600.5");
	showNumFormat(sheet, L"PERCENT", Format::NUMFORMAT_PERCENT, L"0.75");
	showNumFormat(sheet, L"PERCENT_D2", Format::NUMFORMAT_PERCENT_D2, L"0.759");
	showNumFormat(sheet, L"SCIENTIFIC_D2", Format::NUMFORMAT_SCIENTIFIC_D2, L"50.4");
	showNumFormat(sheet, L"FRACTION_ONEDIG", Format::NUMFORMAT_FRACTION_ONEDIG, L"50.4");
	showNumFormat(sheet, L"FRACTION_TWODIG", Format::NUMFORMAT_FRACTION_TWODIG, L"50.4");

	showNumFormat(sheet, L"DATE_MDY", Format::NUMFORMAT_DATE_MDY, L"3/14/2008");

	showNumFormat(sheet, L"CUSTOM_D-MON-YY", Format::NUMFORMAT_CUSTOM_D_MON_YY, L"3/14/2008");
	showNumFormat(sheet, L"CUSTOM_D-MON", Format::NUMFORMAT_CUSTOM_D_MON, L"3/14/2008");
	showNumFormat(sheet, L"CUSTOM_MON-YY", Format::NUMFORMAT_CUSTOM_MON_YY, L"03/14/2008");
	showNumFormat(sheet, L"CUSTOM_HMM_AM", Format::NUMFORMAT_CUSTOM_HMM_AM, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_HMMSS_AM", Format::NUMFORMAT_CUSTOM_HMMSS_AM, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_HMM", Format::NUMFORMAT_CUSTOM_HMM, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_HMMSS", Format::NUMFORMAT_CUSTOM_HMMSS, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_MDYYYY_HMM", Format::NUMFORMAT_CUSTOM_MDYYYY_HMM, L"03/14/2008 8:30:55 PM");

	showNumFormat(sheet, L"NUMBER_SEP_NEGBRA", Format::NUMFORMAT_NUMBER_SEP_NEGBRA, L"-4000.85");
	showNumFormat(sheet, L"NUMBER_SEP_NEGBRARED", Format::NUMFORMAT_NUMBER_SEP_NEGBRARED, L"-4000.85");
	showNumFormat(sheet, L"NUMBER_D2_SEP_NEGBRA", Format::NUMFORMAT_NUMBER_D2_SEP_NEGBRA, L"-6000.45");
	showNumFormat(sheet, L"NUMBER_D2_SEP_NEGBRARED", Format::NUMFORMAT_NUMBER_D2_SEP_NEGBRARED, L"-6000.45");
	showNumFormat(sheet, L"ACCOUNT", Format::NUMFORMAT_ACCOUNT);
	showNumFormat(sheet, L"ACCOUNT_CUR", Format::NUMFORMAT_ACCOUNT_CUR);
	showNumFormat(sheet, L"ACCOUNT_D2", Format::NUMFORMAT_ACCOUNT_D2);
	showNumFormat(sheet, L"ACCOUNT_D2_CUR", Format::NUMFORMAT_ACCOUNT_D2_CUR);

	showNumFormat(sheet, L"CUSTOM_MMSS", Format::NUMFORMAT_CUSTOM_MMSS, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_HMMSS", Format::NUMFORMAT_CUSTOM_H0MMSS, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_MMSS0", Format::NUMFORMAT_CUSTOM_MMSS0, L"8:30:55 PM");
	showNumFormat(sheet, L"CUSTOM_000P0E_PLUS0", Format::NUMFORMAT_CUSTOM_000P0E_PLUS0, L"15200");
	showNumFormat(sheet, L"TEXT", Format::NUMFORMAT_TEXT);
}


int main(int argc, char* argv[])
{
	try {

		xls = new Workbook("demo.xls");			
		
		example();		
		patterns();			
		colors();		
		borders();
		aligns();
		fonts();
		numformats();		

		xls->close();
		delete xls;
					
	} catch(const Error& e) {		
		std::wcout << "message: " << e.message() << std::endl;		
	}

	cout << "press any key to exit..." << endl; _getch();
	return 0;
}
