Imports System.Reflection
Imports System.IO

Public Class Form1

    Private Sub buttonCallEmbeddedAssembly_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonCallEmbeddedAssembly.Click
        Dim assembly1 As Assembly
        assembly1 = Assembly.LoadFrom(Application.StartupPath + "\ManagedDll1.dll")
        Dim obj As Object
        obj = assembly1.CreateInstance("ManagedDll1.Class1")
        Dim args(0) As Object
        args(0) = "Hi!"
        obj.GetType().GetMethod("ShowMessage").Invoke(obj, args)
    End Sub

    Private Sub linkLabel1_LinkClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles linkLabel1.LinkClicked
        System.Diagnostics.Process.Start("http://www.boxedapp.com/")
    End Sub

    Private Sub linkLabel2_LinkClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles linkLabel2.LinkClicked
        System.Diagnostics.Process.Start("http://www.boxedapp.com/order.html")
    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        BoxedAppSDK.NativeMethods.BoxedAppSDK_Init()

        CreateDLLInMemory(Application.StartupPath + "\ManagedDll1.dll", Assembly.GetExecutingAssembly().GetManifestResourceStream("Sample2_AssemblyEmbedding.ManagedDll1.bin"))
    End Sub

    Private Shared Sub CreateDLLInMemory(ByVal strVirtualPath As String, ByVal stream As Stream)

        ' We enable option DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL
        ' So all changes will be virtual
        ' We can create new file, it will be created as a virtual file
        BoxedAppSDK.NativeMethods.BoxedAppSDK_EnableOption(BoxedAppSDK.NativeMethods.DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL, True)

        Dim fs As Stream
        fs = New System.IO.FileStream(strVirtualPath, IO.FileMode.CreateNew, IO.FileAccess.Write)
        Dim buffer(stream.Length) As Byte
        stream.Read(buffer, 0, stream.Length)
        fs.Write(buffer, 0, stream.Length)
        fs.Close()

        ' Disable option DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL
        BoxedAppSDK.NativeMethods.BoxedAppSDK_EnableOption(BoxedAppSDK.NativeMethods.DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL, False)
    End Sub
End Class
