Imports System
Imports System.Runtime.InteropServices
Imports System.Text

Namespace BoxedAppSDK
    Class NativeMethods
        <DllImport("BoxedAppSDK.dll")> Public Shared Function BoxedAppSDK_Init() As Boolean
        End Function
        <DllImport("BoxedAppSDK.dll")> Public Shared Sub BoxedAppSDK_Exit()
        End Sub

        <Flags()> _
        Public Enum EFileAccess : uint
            GenericRead = &H80000000
            GenericWrite = &H40000000
            GenericExecute = &H20000000
            GenericAll = &H1000000
        End Enum

        <Flags()> _
        Public Enum EFileShare : uint
            None = &H0
            Read = &H1
            Write = &H2
            Delete = &H4
        End Enum

        Public Enum ECreationDisposition : uint
            CreateNew = 1
            CreateAlways = 2
            OpenExisting = 3
            OpenAlways = 4
            TruncateExisting = 5
        End Enum

        <Flags()> _
        Public Enum EFileAttributes : uint
            FileReadonly = &H1
            Hidden = &H2
            System = &H4
            Directory = &H10
            Archive = &H20
            Device = &H40
            Normal = &H80
            Temporary = &H100
            SparseFile = &H200
            ReparsePoint = &H400
            Compressed = &H800
            Offline = &H1000
            NotContentIndexed = &H2000
            Encrypted = &H4000
            Write_Through = &H80000000
            Overlapped = &H40000000
            NoBuffering = &H20000000
            RandomAccess = &H10000000
            SequentialScan = &H8000000
            DeleteOnClose = &H4000000
            BackupSemantics = &H2000000
            PosixSemantics = &H1000000
            OpenReparsePoint = &H200000
            OpenNoRecall = &H100000
            FirstPipeInstance = &H80000
        End Enum

        <DllImport("BoxedAppSDK.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
        Public Shared Function BoxedAppSDK_CreateVirtualFile( _
        ByVal lpFileName As String, _
        ByVal dwDesiredAccess As EFileAccess, _
        ByVal dwShareMode As EFileShare, _
        ByVal lpSecurityAttributes As IntPtr, _
        ByVal dwCreationDisposition As ECreationDisposition, _
        ByVal dwFlagsAndAttributes As EFileAttributes, _
        ByVal hTemplateFile As IntPtr) As IntPtr
        End Function

        Public Delegate Function FileProc(ByVal Param As IntPtr, ByVal Command As UInt32, ByVal Info As IntPtr) As UInt32

        <DllImport("BoxedAppSDK.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
        Public Shared Function BoxedAppSDK_CreateVirtualFileEx( _
        ByVal lpFileName As String, _
        ByVal dwDesiredAccess As EFileAccess, _
        ByVal dwShareMode As EFileShare, _
        ByVal lpSecurityAttributes As IntPtr, _
        ByVal dwCreationDisposition As ECreationDisposition, _
        ByVal dwFlagsAndAttributes As EFileAttributes, _
        ByVal hTemplateFile As IntPtr, _
        ByVal Param As IntPtr, _
        ByVal pFileProc As FileProc) As IntPtr
        End Function

        Public Const DEF_FILEPROC_COMMAND_CREATE_CONTEXT As UInt32 = 1
        Public Const DEF_FILEPROC_COMMAND_DELETE_CONTEXT As UInt32 = 2
        Public Const DEF_FILEPROC_COMMAND_READ As UInt32 = 3
        Public Const DEF_FILEPROC_COMMAND_WRITE As UInt32 = 4
        Public Const DEF_FILEPROC_COMMAND_SEEK As UInt32 = 5
        Public Const DEF_FILEPROC_COMMAND_GETSIZE As UInt32 = 6

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcCreateContext
            Public m_pContext As IntPtr
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcDeleteContext
            Public m_pContext As IntPtr
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcRead
            Public m_pContext As IntPtr

            Public m_pBuffer As IntPtr
            Public m_dwBufferSize As UInt32
            Public m_nReadBytes As UInt32
            Public m_bRes As Int32
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcWrite
            Public m_pContext As IntPtr

            Public m_pBuffer As IntPtr
            Public m_dwBufferSize As UInt32
            Public m_nWrittenBytes As UInt32
            Public m_bRes As Int32
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure LARGE_INTEGER
            Public LowPart As UInt32
            Public HighPart As UInt32
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcSeek
            Public m_pContext As IntPtr

            Public m_Distance As LARGE_INTEGER
            Public m_dwMoveMethod As UInt32
            Public m_NewPos As LARGE_INTEGER
            Public m_bRes As Int32
        End Structure

        <StructLayout(LayoutKind.Sequential)> _
        Public Structure SFileProcGetSize
            Public m_pContext As IntPtr

            Public m_Size As LARGE_INTEGER
        End Structure

        <DllImport("BoxedAppSDK.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
        Public Shared Function BoxedAppSDK_RegisterCOMLibraryInVirtualRegistry(ByVal lpFileName As String) As Integer
        End Function

        <DllImport("BoxedAppSDK.dll", SetLastError:=True, CharSet:=CharSet.Ansi)> _
        Public Shared Sub BoxedAppSDK_SetContext(ByVal code As String)
        End Sub

        Public Const DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL As UInt32 = 1

        <DllImport("BoxedAppSDK.dll", SetLastError:=True)> _
        Public Shared Sub BoxedAppSDK_EnableOption(ByVal dwOptionIndex As UInt32, ByVal bEnable As Boolean)
        End Sub

        <DllImport("BoxedAppSDK.dll", SetLastError:=True)> _
        Public Shared Function BoxedAppSDK_IsOptionEnabled(ByVal dwOptionIndex As UInt32) As Boolean
        End Function
    End Class
End Namespace
