using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;
using System.Runtime.InteropServices.ComTypes;

namespace Sample3_CustomVirtualFileSystem
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            BoxedAppSDK.NativeMethods.BoxedAppSDK_Init();

            // Our implementation of standard COM interface IStream
            // MyFileStream represents a "file" that begins at offset 1 byte (the second argument)
            // and occupies the rest of the "avi_with_offset._avi" (the first argument)
            CustomFileStream MyFileStream = new CustomFileStream("avi_with_offset._avi", 1 /* offset */);

            BoxedAppSDK.NativeMethods.BoxedAppSDK_CreateVirtualFileBasedOnIStream(
                @"1.avi", // name of the fake file
                BoxedAppSDK.NativeMethods.EFileAccess.GenericWrite, 
                BoxedAppSDK.NativeMethods.EFileShare.Read, 
                IntPtr.Zero, 
                BoxedAppSDK.NativeMethods.ECreationDisposition.New, 
                BoxedAppSDK.NativeMethods.EFileAttributes.Normal, 
                IntPtr.Zero, 
                MyFileStream);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());

            BoxedAppSDK.NativeMethods.BoxedAppSDK_Exit();
        }
    }
}