/*
 * Decompiled with CFR 0.152.
 */
package com.sciapp.demo;

import com.sciapp.demo.DataFeeder;
import com.sciapp.demo.PersonDataFeeder;
import com.sciapp.demo.PersonTableModel;
import com.sciapp.filter.CustomPopupFilterHeaderModel;
import com.sciapp.filter.FilterHeaderModel;
import com.sciapp.filter.FilterTableHeader;
import com.sciapp.renderers.DateRenderer;
import com.sciapp.table.AdvancedJScrollPane;
import com.sciapp.table.AdvancedJTable;
import com.sciapp.table.FilterTableModel;
import com.sciapp.table.ListTableModel;
import com.sciapp.table.SortTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractDemoPanel
extends JPanel {
    public JButton addButton;
    public JTextField rowField;
    public JButton removeButton;
    public JCheckBox showLastColumn;
    public JCheckBox singleMode;
    public JCheckBox autoCreateFilter;
    public JCheckBox reorderFirstColumn;
    public JTable table;
    public SortTableModel sortTableModel;
    public ListTableModel model;
    public FilterHeaderModel ft;
    public DataFeeder dataFeeder;
    protected a actionHandler = new a();
    static /* synthetic */ Class class$java$util$Date;

    public AbstractDemoPanel() {
        this(new PersonTableModel(), new PersonDataFeeder());
    }

    public AbstractDemoPanel(ListTableModel listTableModel, DataFeeder dataFeeder) {
        this.dataFeeder = dataFeeder;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = this.createTablePanel(listTableModel);
        JPanel jPanel2 = this.createTableFeaturePanel();
        this.add(jPanel);
        this.add(jPanel2);
    }

    protected void action(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.addRows();
        } else if (object == this.removeButton) {
            int[] nArray = this.table.getSelectedRows();
            this.model.removeRows(nArray);
        } else if (object == this.showLastColumn) {
            boolean bl = this.showLastColumn.isSelected();
            if (this.table instanceof AdvancedJTable) {
                ((AdvancedJTable)this.table).setShowDummyColumn(bl);
            }
        } else if (object == this.singleMode) {
            boolean bl = this.singleMode.isSelected();
            this.sortTableModel.setSortMode(bl ? 1 : 0);
        } else if (object == this.autoCreateFilter) {
            boolean bl = this.autoCreateFilter.isSelected();
            this.ft.setAutoCreateAllFilters(bl);
        } else if (object == this.reorderFirstColumn) {
            boolean bl = this.reorderFirstColumn.isSelected();
            if (this.table instanceof AdvancedJTable) {
                ((AdvancedJTable)this.table).setFirstColumnFixed(bl);
            }
        }
    }

    public void addRows() {
        String string = this.rowField.getText();
        if (string == null) {
            return;
        }
        int n = AbstractDemoPanel.parseStringToInt(string);
        this.addRows(n);
    }

    public void addRows(int n) {
        if (this.dataFeeder == null) {
            return;
        }
        if (n == 1) {
            Object object = this.dataFeeder.createObject();
            this.model.addRow(object);
        } else if (n > 1) {
            ArrayList arrayList = this.dataFeeder.createObjects(n);
            this.model.addRows(arrayList);
        }
    }

    protected abstract JTable createTable();

    protected JPanel createTableFeaturePanel() {
        JPanel jPanel = new JPanel();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new TitledBorder(" Features "), BorderFactory.createEmptyBorder(5, 10, 0, 20));
        jPanel.setBorder(compoundBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.addButton = new JButton("Add row(s)");
        this.addButton.addActionListener(this.actionHandler);
        this.rowField = new JTextField(6);
        this.rowField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    AbstractDemoPanel.this.addRows();
                }
            }
        });
        Dimension dimension = this.rowField.getMaximumSize();
        dimension.height = this.rowField.getPreferredSize().height;
        this.rowField.setMaximumSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.addButton);
        jPanel2.add(this.rowField);
        jPanel2.add(new JLabel("Enter the number of rows you want to add to the table."));
        jPanel.add(jPanel2);
        this.removeButton = new JButton("Remove row(s)");
        this.removeButton.addActionListener(this.actionHandler);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.removeButton);
        jPanel3.add(new JLabel("Remove the selected row(s)."));
        jPanel.add(jPanel3);
        this.showLastColumn = new JCheckBox("Show Last Column", true);
        this.showLastColumn.addActionListener(this.actionHandler);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.showLastColumn);
        this.singleMode = new JCheckBox("Multiple Column Sort Mode", true);
        this.singleMode.addActionListener(this.actionHandler);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.singleMode);
        this.autoCreateFilter = new JCheckBox("Auto-create filter", true);
        this.autoCreateFilter.addActionListener(this.actionHandler);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(this.autoCreateFilter);
        this.reorderFirstColumn = new JCheckBox("First column fixed", false);
        this.reorderFirstColumn.addActionListener(this.actionHandler);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        boolean bl = this.table instanceof AdvancedJTable ? ((AdvancedJTable)this.table).isFirstColumnFixed() : false;
        this.reorderFirstColumn.setSelected(bl);
        jPanel7.add(this.reorderFirstColumn);
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        jPanel.add(jPanel8);
        return jPanel;
    }

    protected abstract ListTableModel createTableModel(ListTableModel var1);

    public JPanel createTablePanel(ListTableModel listTableModel) {
        SortTableModel sortTableModel;
        ListTableModel listTableModel2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new TitledBorder(" Table "), BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setBorder(compoundBorder);
        ListTableModel listTableModel3 = listTableModel2 = listTableModel;
        FilterTableModel filterTableModel = new FilterTableModel(listTableModel3);
        this.sortTableModel = sortTableModel = new SortTableModel(filterTableModel);
        this.model = this.createTableModel(sortTableModel);
        this.table = this.createTable();
        this.table.setModel(this.model);
        AdvancedJScrollPane advancedJScrollPane = new AdvancedJScrollPane(22, 32);
        ((JScrollPane)advancedJScrollPane).setViewportView(this.table);
        sortTableModel.setHeader(this.table.getTableHeader());
        TableCellRenderer tableCellRenderer = this.table.getDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = AbstractDemoPanel.class$("java.util.Date")) : class$java$util$Date);
        if (tableCellRenderer instanceof DateRenderer) {
            ((DateRenderer)tableCellRenderer).setDateFormat(DateFormat.getDateInstance());
        }
        this.addRows(2);
        Color color = new Color(194, 194, 194);
        if (this.table instanceof AdvancedJTable) {
            ((AdvancedJTable)this.table).setOddColor(color);
        }
        jPanel.add((Component)advancedJScrollPane, "Center");
        this.ft = new CustomPopupFilterHeaderModel();
        this.ft.setTableHeader((FilterTableHeader)this.table.getTableHeader());
        this.ft.attachToTable(this.table);
        return jPanel;
    }

    public static int parseStringToInt(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class a
    implements ActionListener {
        private a() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDemoPanel.this.action(actionEvent);
        }
    }
}

