/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipResourceLoader {
    Hashtable resources = new Hashtable();
    URLStreamHandler handler = new URLStreamHandler(){

        protected URLConnection openConnection(URL uRL) {
            return new ZipURLConnection(uRL);
        }

        protected void parseURL(URL uRL, String string, int n, int n2) {
            String string2 = uRL.getFile();
            int n3 = string2.indexOf("/");
            if (n3 != -1) {
                String string3 = string2.substring(0, n3);
                this.setURL(uRL, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3 + "/" + string, uRL.getRef());
            } else {
                this.setURL(uRL, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string, uRL.getRef());
            }
        }

        protected String toExternalForm(URL uRL) {
            return "ziploader://" + uRL.getFile();
        }
    };

    public ZipResourceLoader(URL uRL) throws Exception {
        this(uRL.openStream());
    }

    public ZipResourceLoader(InputStream inputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            if (zipEntry.isDirectory()) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = zipInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            this.resources.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
        }
    }

    public InputStream getResourceAsStream(String string) throws MalformedURLException, IOException {
        return this.getResource(string).openStream();
    }

    public URL getResource(String string) throws MalformedURLException {
        if (this.resources.get(string) == null) {
            return null;
        }
        return new URL("ziploader", null, -1, string, this.handler);
    }

    public ZipResource getZipResource(String string) {
        return new ZipResource(string);
    }

    public ZipResource getZipResource(URL uRL) {
        return this.getZipResource(uRL.getFile());
    }

    public Enumeration entries() {
        return this.resources.keys();
    }

    public void dump() {
        Enumeration enumeration = this.resources.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " size = " + ((byte[])this.resources.get(string)).length);
        }
    }

    public void release() {
        this.resources.clear();
        this.resources = null;
    }

    private byte[] getURLContent(String string) {
        byte[] byArray = (byte[])this.resources.get(string);
        if (byArray == null && string.startsWith("/")) {
            byArray = (byte[])this.resources.get(string.substring(1));
        }
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        ZipResourceLoader zipResourceLoader = new ZipResourceLoader(new File(stringArray[0]).toURL());
        Enumeration enumeration = zipResourceLoader.entries();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string);
            URL uRL = zipResourceLoader.getResource(string);
            System.out.println(uRL);
            System.out.println(uRL.openStream());
            System.out.println(zipResourceLoader.getZipResource(string).getInputStream());
        }
    }

    class ZipURLConnection
    extends URLConnection {
        public ZipURLConnection(URL uRL) {
            super(uRL);
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])ZipResourceLoader.this.resources.get(this.getURL().getFile()));
            return byteArrayInputStream;
        }

        public void connect() throws IOException {
            if (ZipResourceLoader.this.resources == null || ZipResourceLoader.this.resources.get(this.getURL().getFile()) == null) {
                throw new IOException("No data for " + this.getURL());
            }
        }
    }

    public class ZipResource {
        String m_Name;

        public ZipResource(String string) {
            this.m_Name = string;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("http", null, -1, this.m_Name);
        }

        public InputStream getInputStream() {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ZipResourceLoader.this.getURLContent(this.m_Name));
            return byteArrayInputStream;
        }

        public byte[] getURLContent() {
            return ZipResourceLoader.this.getURLContent(this.m_Name);
        }
    }
}

