/*

  Copyright (C) 2004-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.jndi.mirror;

import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;


/**
 * <code>CopyHelper</code> provides utility method for copying the content of one <code>Context</code>
 * to another.
 */
public class CopyHelper {
    /**
     * The class should not be instantiated.
     */
    private CopyHelper() {}

    /**
     * Creates full copy of the <code>Context</code>.
     *
     * @param from Source context
     * @param to   Destination context
     * @throws NamingException If a naming exception is encountered
     */
    public static void copy(Context from, Context to) throws NamingException {
        NamingEnumeration namingEnumeration = from.list("");
        while (namingEnumeration.hasMore()) {
            try {
                NameClassPair nameClassPair = (NameClassPair) namingEnumeration.next();
                Object binding = from.lookup(nameClassPair.getName());
                if (binding instanceof Context)
                    copy((Context) binding, to.createSubcontext(nameClassPair.getName()));
                else
                    to.bind(nameClassPair.getName(), binding);
            } catch (NamingException e) {
            }
        }
    }
}
