program SubscriberDemo;

{$APPTYPE CONSOLE}

{%TogetherDiagram 'ModelSupport_SubscriberDemo\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\PublisherDemo\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTJMSClient\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTStompCustomClient\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\default.txvpck'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\PublisherDemo\default.txvpck'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTLogger\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTStompInterfaces\default.txaPackage'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTStompInterfaces\default.txvpck'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTLogger\default.txvpck'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTJMSClient\default.txvpck'}
{%TogetherDiagram 'ModelSupport_SubscriberDemo\BTStompCustomClient\default.txvpck'}

uses
  SysUtils,
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas',
  BTSupportInterfaces in '..\..\source\BTSupportInterfaces.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas',
  BTJMSConnection in '..\..\source\BTJMSConnection.pas',
  BTLogger in '..\..\source\BTLogger.pas';

const
  Dest = '/queue/a';

const
  EXPECTED = 2000;

var
  Connection: TBTJMSConnection;
  Session: ISession;
  Destination: IDestination;
  TextMessage: ITextMessage;
  Consumer: IMessageConsumer;
  L: ILogging;
  Compiler: string;
  I: Integer;

begin
{$IFDEF FPC}
  Compiler := 'Free Pascal';
{$ELSE}
  Compiler := 'Borland Delphi';
{$ENDIF}

  L := TSimpleLogger.Create;
  L.Info('Compiler: '  + Compiler);
  L.Info('Connect to server');

  Connection := TBTJMSConnection.MakeConnection('', '', 'localhost');
  Connection.Start;

  Session := Connection.CreateSession(False, amClientAcknowledge);

  try
    try
    L.Info(Format('Wait for %d incoming messages', [EXPECTED]));
    Destination := Session.CreateQueue(Dest);
    Consumer := Session.CreateConsumer(Destination);

    Sleep(1500);

    I := 0;

    while I < EXPECTED do
    begin
      TextMessage := ITextMessage(Consumer.Receive(1000));
      if Assigned(TextMessage) then
      begin
        Inc(I);
        Connection.Transport.Ack(TextMessage.MessageId);
        L.Info(Format('%d %s', [I, TextMessage.Text]));
      end;
    end;
    

    except
      on E:Exception do
      begin
        L.Info('Exception: ' + E.Message);        
      end;
    end;

  finally
    L.Info('Hit any key');
    ReadLn;
    Session.Close;
    Connection.Close;
  end;

end.

