unit SendObjectsFrm;

interface

uses
  ExampleClassUnit, BTSoapAdapter, Windows, Messages, SysUtils, Variants,
    Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, xmldom, XMLIntf, msxmldom, XMLDoc, AppEvnts;

type
  TSendObjectsForm = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Panel2: TPanel;
    XMLDocument1: TXMLDocument;
    EditTitle: TEdit;
    Label1: TLabel;
    MemoXML: TMemo;
    ApplicationEvents1: TApplicationEvents;
    Label2: TLabel;
    EditAuthors: TEdit;
    Label3: TLabel;
    EditListPrice: TEdit;
    Label4: TLabel;
    EditPages: TEdit;
    Label5: TLabel;
    EditReleasedOn: TEdit;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
  private
    { Private-Deklarationen }
    SoapAdapter: TBTSoapAdapter;

  public
    { Public-Deklarationen }

    ExampleObject: TExampleClass;

  end;

var
  SendObjectsForm: TSendObjectsForm;

implementation

{$R *.dfm}

procedure TSendObjectsForm.ApplicationEvents1Idle(Sender: TObject;
  var Done: Boolean);
begin

  ExampleObject.Name := EditTitle.Text;
  ExampleObject.Authors := EditAuthors.Text;
  ExampleObject.ListPrice := StrToFloatDef(EditListPrice.Text, 0);
  ExampleObject.Pages := StrToIntDef(EditPages.Text, 0);
  ExampleObject.PublishedOn := StrToDateTimeDef(EditReleasedOn.Text, 0);

  MemoXML.Text := SoapAdapter.ObjectToSOAP(ExampleObject, 'Name');
end;

procedure TSendObjectsForm.FormCreate(Sender: TObject);
begin
  SoapAdapter := TBTSoapAdapter.Create(Self);
  SoapAdapter.XMLDocument := XMLDocument1;
end;

procedure TSendObjectsForm.FormDestroy(Sender: TObject);
begin
  //
end;

procedure TSendObjectsForm.FormHide(Sender: TObject);
begin
  ExampleObject.Free;
end;

procedure TSendObjectsForm.FormShow(Sender: TObject);
begin
  ExampleObject := TExampleClass.Create;

  if MemoXML.Text <> '' then
  begin
    SoapAdapter.SOAPToObject(MemoXML.Text, ExampleObject);
    // Fill form fields
    EditTitle.Text := ExampleObject.Name;
    EditAuthors.Text := ExampleObject.Authors;
    EditListPrice.Text := FloatToStr(ExampleObject.ListPrice);
    EditPages.Text := IntToStr(ExampleObject.Pages);
    EditReleasedOn.Text := DateTimeToStr(ExampleObject.PublishedOn)
  end
  else
  begin
    // empty XML: default values
    EditTitle.Text :=
      'Domain-Driven Design: Tackling Complexity in the Heart of Software';
    EditAuthors.Text := 'Eric Evans';
    EditListPrice.Text := FloatToStr(59.99);
    EditPages.Text := IntToStr(560);
    EditReleasedOn.Text := DateToStr(EncodeDate(2003, 8, 30));
  end;

end;

end.

