unit ExampleClassUnit;

interface

uses
  InvokeRegistry;

type
  TExampleClass = class(TRemotable)
  private
    FName: string;
    FPublishedOn: TDateTime;
    FListPrice: Currency;
    FPages: Integer;
    FAuthors: string;
    procedure SetName(const Value: string);
    procedure SetAuthors(const Value: string);
    procedure SetListPrice(const Value: Currency);
    procedure SetPages(const Value: Integer);
    procedure SetPublishedOn(const Value: TDateTime);
  published
    property Name: string read FName write SetName;
    property ListPrice: Currency read FListPrice write SetListPrice;
    property Authors: string read FAuthors write SetAuthors;
    property Pages: Integer read FPages write SetPages;
    property PublishedOn: TDateTime read FPublishedOn write SetPublishedOn;
  end;

implementation

{ TExampleClass }

procedure TExampleClass.SetAuthors(const Value: string);
begin
  FAuthors := Value;
end;

procedure TExampleClass.SetListPrice(const Value: Currency);
begin
  FListPrice := Value;
end;

procedure TExampleClass.SetName(const Value: string);
begin
  FName := Value;
end;

procedure TExampleClass.SetPages(const Value: Integer);
begin
  FPages := Value;
end;

procedure TExampleClass.SetPublishedOn(const Value: TDateTime);
begin
  FPublishedOn := Value;
end;

end.
