unit DemoMainFrm;

interface

uses
  BTJMSInterfaces,
  BTCommInterfaces, BTSupportInterfaces,
  BTStompFrame, BTStompInterfaces,
  // everything else
  Windows, Messages, SysUtils,
  Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ActnList, Menus, ComCtrls;

type

  TDemoMainForm = class(TForm, IMessageListener)
    ActionList1: TActionList;
    ActionNewDest: TAction;
    ActionSub: TAction;
    ActionCloseSession: TAction;
    ActionSend: TAction;
    ActionConnect: TAction;
    ActionDisconnect: TAction;
    MainMenu1: TMainMenu;
    Connect1: TMenuItem;
    Quit1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    ActionOptionsSend: TAction;
    Connection1: TMenuItem;
    Connect2: TMenuItem;
    Disconnect1: TMenuItem;
    Destinations1: TMenuItem;
    New1: TMenuItem;
    Receive1: TMenuItem;
    Subscribe1: TMenuItem;
    Unsubscribe1: TMenuItem;
    Send1: TMenuItem;
    Send2: TMenuItem;
    Options1: TMenuItem;
    PageControl1: TPageControl;
    TbsSend: TTabSheet;
    TabSheet2: TTabSheet;
    Panel4: TPanel;
    CbxDebug: TCheckBox;
    MemoLog: TMemo;
    Panel5: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    EditHost: TEdit;
    EditPort: TEdit;
    Panel2: TPanel;
    Label2: TLabel;
    Button4: TButton;
    Panel3: TPanel;
    Label3: TLabel;
    Label5: TLabel;
    Button3: TButton;
    MemoText: TMemo;
    Button7: TButton;
    EditRepeat: TEdit;
    UpDown1: TUpDown;
    Panel6: TPanel;
    Label4: TLabel;
    LbxDest: TListBox;
    Button6: TButton;
    ComboBox1: TComboBox;
    EditDest: TEdit;
    FrameList: TListBox;
    TabSheet1: TTabSheet;
    JMSMessageList: TListView;
    ActionCommit: TAction;
    ActionAbort: TAction;
    StatusBar1: TStatusBar;
    ActionOptionsSubscribe: TAction;
    ActionClearLog: TAction;
    Options2: TMenuItem;
    Panel8: TPanel;
    Label7: TLabel;
    ComboCommLib: TComboBox;
    Button13: TButton;
    ActionSendFile: TAction;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SendFile1: TMenuItem;
    ransactions1: TMenuItem;
    Commit1: TMenuItem;
    Abort1: TMenuItem;
    Panel9: TPanel;
    Button14: TButton;
    ActionJMSDetails: TAction;
    JMSMessageLog1: TMenuItem;
    Details1: TMenuItem;
    Button12: TButton;
    Panel10: TPanel;
    Label8: TLabel;
    Button15: TButton;
    ActionSendObjects: TAction;
    ActionSession: TAction;
    Panel11: TPanel;
    Button8: TButton;
    Button5: TButton;
    Label9: TLabel;
    Button9: TButton;
    Button10: TButton;
    procedure Connect(Sender: TObject);
    procedure Disconnect(Sender: TObject);
    procedure Send(Sender: TObject);
    procedure Subscribe(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CloseSession(Sender: TObject);
    procedure FormShow(Sender: TObject);

    procedure CbxDebugClick(Sender: TObject);
    procedure ActionList1Update(Action: TBasicAction; var Handled: Boolean);
    procedure ActionNewDestExecute(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Quit1Click(Sender: TObject);

    procedure ActionOptionsSendExecute(Sender: TObject);

    procedure JMSMessageListDblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure ActionCommitExecute(Sender: TObject);
    procedure ActionAbortExecute(Sender: TObject);
    procedure ActionOptionsSubscribeExecute(Sender: TObject);
    procedure ActionClearLogExecute(Sender: TObject);
    procedure AdapterListClick(Sender: TObject);
    procedure SendFile(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ActionSendObjectsExecute(Sender: TObject);
    procedure ActionSessionExecute(Sender: TObject);

  private
    { Private-Deklarationen }

    JMSMessage: ITextMessage;

    JMSMessages: TInterfaceList;

    function SelectedDestination: string;

    function NewDest: string;

    procedure MyOnLog(const ALogMessage: WideString; const ALogLevel:
      TLogLevel);

    procedure MyOnError(Sender: TObject; Frame: IStompFrame);
    procedure MyOnMessage(Sender: TObject; Frame: IStompFrame);
    procedure MyOnConnect(Sender: TObject; Frame: IStompFrame);
    procedure MyOnReceipt(Sender: TObject; Frame: IStompFrame);

    procedure MyOnJMSTextMessage(Sender: TObject; JMSMessage: ITextMessage);

    procedure MyOnJMSBytesMessage(Sender: TObject; JMSMessage: IBytesMessage);

    procedure AddFrameToList(Frame: IStompFrame);

    procedure OnMessage(Message: IMessage);
    function SelectedDestinationType: string;

  public
    { Public-Deklarationen }
  end;

var
  DemoMainForm: TDemoMainForm;

implementation

uses
  // used forms
  OptionsSendFrm, OptionsSubscribeFrm, SendObjectsFrm,
  // used ActiveMQ classes
  BTAdapterRegistry,
  BTJMSConnection,
  // STOMP client
  BTJMSClient,
  BTStompConnection,
  BTStompTypes,
  // Delphi etc
  SyncObjs, OptionsSessionFrm;

{$R *.dfm}

const
  CRLF = #13#10;

var
  Transport: TBTJMSClient;
  Connection: TBTJMSConnection;
  Session: ISession;
  Logger: ILogging;
  CS: TCriticalSection;
  AcknowledgementMode: TAcknowledgementMode;

  // OptionsSubscribe (unused)
  PrefetchSize: Integer; // activemq.prefetchSize
  DispatchAsync: Boolean; // activemq.dispatchAsync

  //-----------------------------------------------------------
  //  FORM SETUP AND TEARDOWN
  //-----------------------------------------------------------

procedure TDemoMainForm.FormCreate(Sender: TObject);
begin

  // holds incommng JMS messages
  JMSMessages := TInterfaceList.Create;

  // Critical Section ?
  CS := TCriticalSection.Create;

  // Adapter
  ComboCommLib.Items.Text := AdapterNames;
  ComboCommLib.ItemIndex := 0;

  // OptionsSubscribe
  PrefetchSize := 0;
  DispatchAsync := False;

end;

procedure TDemoMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if Assigned(Transport) and Transport.StompConnected then
  begin
    Transport.Disconnect
  end;
end;

procedure TDemoMainForm.FormDestroy(Sender: TObject);
begin
  CS.Free;
  JMSMessages.Free;
end;

procedure TDemoMainForm.FormShow(Sender: TObject);
begin
  Caption := 'BTActiveMQClient GUI Demo (Delphi)';

  // default stomp port
  EditPort.Text := IntToStr(btPORT_STOMP);

  // set up gui
  PageControl1.ActivePageIndex := 0;
  LbxDest.ItemIndex := 0;
end;

// Show the message properties on double click

procedure TDemoMainForm.JMSMessageListDblClick(Sender: TObject);
var
  OptionsSendForm: TOptionsSendForm;
  TM: ITextMessage;
begin
  Application.CreateForm(TOptionsSendForm, OptionsSendForm);
  try
    if JMSMessageList.ItemIndex <> -1 then
    begin
      TM := ITextMessage(JMSMessages[JMSMessageList.ItemIndex]);
      if Assigned(TM) then
      begin
        OptionsSendForm.InitTextMessage(TM);
        OptionsSendForm.ShowModal;
      end;
    end;
  finally
    OptionsSendForm.Free;
  end;
end;

procedure TDemoMainForm.MyOnLog(const ALogMessage: WideString; const ALogLevel:
  TLogLevel);
begin
  CS.Enter;

  if System.IsConsole then
    // write to standard output
    WriteLn(Logger.FormatLogMessage(ALogMessage, ALogLevel))
  else
  begin
    // update GUI
    Application.ProcessMessages;
    // write to Memo
    MemoLog.Lines.Add(Logger.FormatLogMessage(ALogMessage, ALogLevel))
  end;

  CS.Leave;
end;

procedure TDemoMainForm.AdapterListClick(Sender: TObject);
begin
  // tell BTAdapterRegistry which adapter we want
  SetDefaultAdapter(ComboCommLib.Items[ComboCommLib.ItemIndex]);
end;

procedure TDemoMainForm.AddFrameToList(Frame: IStompFrame);
begin
  FrameList.Items.Add(Frame.Command + ' '
    + 'message-id=' + Frame.GetValue('message-id') + ' '
    + 'timestamp=' + Frame.GetValue('timestamp') + ' '
    + StringReplace(Frame.Body, CRLF, ' ', [rfReplaceAll]));
end;

procedure TDemoMainForm.ActionClearLogExecute(Sender: TObject);
begin
  MemoLog.Clear;
  FrameList.Clear;
  JMSMessages.Clear;
  JMSMessageList.Clear;
end;

//-----------------------------------------------------------
//  STOMP COMMUNICATION METHODS
//-----------------------------------------------------------

//-----------------------------------------------------------
//  Connect
//-----------------------------------------------------------

procedure TDemoMainForm.Connect(Sender: TObject);
begin
  // create JMS Connection
  Connection := TBTJMSConnection.MakeConnection('', '', EditHost.Text,
    StrToIntDef(EditPort.Text, btPORT_STOMP));

  Transport := Connection.Transport;

  // get a Logger
  Logger := Connection.Transport.Logger;

  // set log writer method
  Logger.OnLog := MyOnLog;

  // todo move these assignments to a custom event handler (onbeforeconnect)
  // of the communication adapter component
  // set low level (STOMP) event handlers
  Connection.Transport.OnStompConnect := MyOnConnect;
  Connection.Transport.OnStompMessage := MyOnMessage;
  Connection.Transport.OnStompReceipt := MyOnReceipt;
  Connection.Transport.OnStompError := MyOnError;

  // start
  Logger.Info('Connect with ' + Connection.Transport.Host);
  Connection.Start;
end;

//-----------------------------------------------------------
// Start Session
//-----------------------------------------------------------

procedure TDemoMainForm.ActionSessionExecute(Sender: TObject);
var
  OptionsSessionForm: TOptionsSessionForm;
  Transactional: Boolean;
begin
  AcknowledgementMode := amTransactional;

  Application.CreateForm(TOptionsSessionForm, OptionsSessionForm);
  with OptionsSessionForm do
  try
    // get Session Transactional Flag and AcknowledgementMode
    if OptionsSessionForm.ShowModal = mrOk then
    begin
      Transactional := GrpAckMode.ItemIndex = 0;
      case GrpAckMode.ItemIndex of
        0: AcknowledgementMode := amTransactional;
        1: AcknowledgementMode := amAutoAcknowledge;
        2: AcknowledgementMode := amClientAcknowledge;
      end;
    end
    else
    begin
      Exit;
    end;
  finally
    OptionsSessionForm.Free;
  end;

  // create JMS client session
  Session := Connection.CreateSession(Transactional, AcknowledgementMode);

  // value object for JMS message properties dialog
  JMSMessage := Session.CreateTextMessage;

end;

//-----------------------------------------------------------
// Disconnect
//-----------------------------------------------------------

procedure TDemoMainForm.Disconnect(Sender: TObject);
begin
  Logger.Info('Disconnect');

  Connection.Close;
  Connection.Free;

  Transport := nil;
end;

//-----------------------------------------------------------
//  Close the session
//-----------------------------------------------------------

procedure TDemoMainForm.CloseSession(Sender: TObject);
begin
  Logger.Info('Close session');

  Session.Close;
  Session := nil;
end;


//-----------------------------------------------------------
// Send Text
//-----------------------------------------------------------

procedure TDemoMainForm.Send(Sender: TObject);
var
  Destination: IDestination;
  Producer: IMessageProducer;
  Count: Integer;
  I: Integer;
begin
  JMSMessage.Text := MemoText.Lines.Text;
  Count := StrToIntDef(EditRepeat.Text, 1);

  Logger.Info(Format('Sending (%d): ' + Trim(JMSMessage.Text), [Count]));

  if SelectedDestinationType = 'q' then
    Destination := Session.CreateQueue(SelectedDestination)
  else
    Destination := Session.CreateTopic(SelectedDestination);

  Producer := Session.CreateProducer(Destination);

  for I := 0 to Count - 1 do
  begin
    Producer.Send(JMSMessage);
  end;

end;

//-----------------------------------------------------------
// Send File
//-----------------------------------------------------------

procedure TDemoMainForm.SendFile(Sender: TObject);
var
  Destination: IDestination;
  Producer: IMessageProducer;
  FileStream: TFileStream;
  S: TStringStream;
  BytesMessage: IBytesMessage;
begin
  if not OpenDialog1.Execute then
  begin
    Exit;
  end;

  if SelectedDestinationType = 'q' then
    Destination := Session.CreateQueue(SelectedDestination)
  else
    Destination := Session.CreateTopic(SelectedDestination);

  Producer := Session.CreateProducer(Destination);

  S := TStringStream.Create('');
  try
    FileStream := TFileStream.Create(OpenDialog1.FileName, fmOpenRead or
      fmShareDenyWrite);
    try
      S.CopyFrom(FileStream, FileStream.Size);
      BytesMessage := Session.CreateBytesMessage;
      BytesMessage.Content := S.DataString;
      Producer.Send(BytesMessage);
    finally
      FileStream.Free;
    end;
  finally
    S.Free;
  end;

end;

//-----------------------------------------------------------
//  Send Object
//-----------------------------------------------------------

procedure TDemoMainForm.ActionSendObjectsExecute(Sender: TObject);
var
  Destination: IDestination;
  Producer: IMessageProducer;
  SendObjectsForm: TSendObjectsForm;
begin
  Application.CreateForm(TSendObjectsForm, SendObjectsForm);
  try
    if SendObjectsForm.ShowModal = mrOk then
    begin
      Logger.Info('Send SOAP serialization');

      JMSMessage.Text := SendObjectsForm.MemoXML.Text;

      if SelectedDestinationType = 'q' then
        Destination := Session.CreateQueue(SelectedDestination)
      else
        Destination := Session.CreateTopic(SelectedDestination);

      Producer := Session.CreateProducer(Destination);

      Producer.Send(Destination, JMSMessage);

      SendObjectsForm.MemoXML.Clear;
    end;
  finally
    SendObjectsForm.Free;
  end;
end;

//-----------------------------------------------------------
// Subscribe
//-----------------------------------------------------------

procedure TDemoMainForm.Subscribe(Sender: TObject);
var
  Destination: IDestination;
  Consumer: IMessageConsumer;
begin
  Logger.Info('Subscribe ' + SelectedDestination);

  if SelectedDestinationType = 'q' then
    Destination := Session.CreateQueue(SelectedDestination)
  else
    Destination := Session.CreateTopic(SelectedDestination);

  Consumer := Session.CreateConsumer(Destination);
  Consumer.MessageListener := Self;

end;

//-----------------------------------------------------------
//  Commit Transaction
//-----------------------------------------------------------

procedure TDemoMainForm.ActionCommitExecute(Sender: TObject);
begin
  Logger.Info('Commit Transaction');
  Session.Commit;
end;

//-----------------------------------------------------------
//  Abort Transaction
//-----------------------------------------------------------

procedure TDemoMainForm.ActionAbortExecute(Sender: TObject);
begin
  Logger.Info('Abort Transaction');
  Session.Rollback;
end;

//-----------------------------------------------------------
//  Receive CONNECTED Frame
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnConnect(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info(Frame.Command);
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive MESSAGE Frame
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnMessage(Sender: TObject; Frame: IStompFrame);
begin
  if Frame.GetValue('content-length') <> '' then
    Logger.Info('Received: ' + IntToStr(Length(Frame.Body)) + ' bytes')
  else
    Logger.Info('Received: ' + Trim(Frame.Body));

  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive ERROR Frame
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnError(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info('Received ERROR: ' + Frame.GetValue('message') + ' ' +
    Frame.Body);
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  Receive RECEIPT Frame
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnReceipt(Sender: TObject; Frame: IStompFrame);
begin
  Logger.Info('Receipt: ' + Frame.GetValue('receipt-id'));
  AddFrameToList(Frame);
end;

//-----------------------------------------------------------
//  END OF STOMP COMMUNICATION METHODS
//-----------------------------------------------------------

//-----------------------------------------------------------
//  JMS METHODS START
//-----------------------------------------------------------

//-----------------------------------------------------------
//  Receive Generic Message - see IMessageConsumer
//-----------------------------------------------------------

procedure TDemoMainForm.OnMessage(Message: IMessage);
begin
  // Acknowledge the message
  if AcknowledgementMode = amClientAcknowledge then
    // todo Ack has a second parameter TransactionID
    Connection.Transport.Ack(Message.MessageId);
  // todo Session.acknowledge or Message.acknowledge

  if Supports(Message, ITextMessage) then
  begin
    MyOnJMSTextMessage(Self, ITextMessage(Message));
  end else if Supports(Message, IBytesMessage) then
  begin
    MyOnJMSBytesMessage(Self, IBytesMessage(Message));
  end;
end;

//-----------------------------------------------------------
//  Receive Text Message
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnJMSTextMessage(Sender: TObject; JMSMessage:
  ITextMessage);
begin
  with JMSMessageList.Items.Add do
  begin
    Caption := JMSMessage.MessageId;
    SubItems.Add(JMSMessage.CorrelationID);
    SubItems.Add(IntToStr(JMSMessage.Priority));
    SubItems.Add(JMSMessage.ReplyTo);
    SubItems.Add(DateTimeToStr(JMSMessage.Timestamp) + ' UTC');
  end;

  JMSMessages.Add(JMSMessage);
end;

//-----------------------------------------------------------
//  Receive Bytes Message
//-----------------------------------------------------------

procedure TDemoMainForm.MyOnJMSBytesMessage(Sender: TObject;
  JMSMessage: IBytesMessage);
begin
  with JMSMessageList.Items.Add do
  begin
    Caption := JMSMessage.MessageId;
    SubItems.Add(JMSMessage.CorrelationID);
    SubItems.Add(IntToStr(JMSMessage.Priority));
    SubItems.Add(JMSMessage.ReplyTo);
    SubItems.Add(DateTimeToStr(JMSMessage.Timestamp) + ' UTC');
  end;

  JMSMessages.Add(JMSMessage);
end;

//-----------------------------------------------------------
//  JMS METHODS END
//-----------------------------------------------------------

//-----------------------------------------------------------
//  Add a destination to the selection list
//-----------------------------------------------------------

procedure TDemoMainForm.ActionNewDestExecute(Sender: TObject);
begin
  LbxDest.Items.Add(NewDest);
  LbxDest.ItemIndex := LbxDest.Items.Count - 1;
end;

//-----------------------------------------------------------
//  Set SEND options for JMS text message
//-----------------------------------------------------------

procedure TDemoMainForm.ActionOptionsSendExecute(Sender: TObject);
var
  OptionsSendForm: TOptionsSendForm;
begin
  Application.CreateForm(TOptionsSendForm, OptionsSendForm);
  try
    if OptionsSendForm.ShowModal = mrOk then
    begin
      JMSMessage := OptionsSendForm.GetMessageOptions;
    end;
  finally
    OptionsSendForm.Free;
  end;
end;

//-----------------------------------------------------------
//  Set SUBSCRIBE options
//-----------------------------------------------------------

procedure TDemoMainForm.ActionOptionsSubscribeExecute(Sender: TObject);
var
  OptionsSubscribeForm: TOptionsSubscribeForm;
begin
  Application.CreateForm(TOptionsSubscribeForm, OptionsSubscribeForm);
  try
    if OptionsSubscribeForm.ShowModal = mrOk then
    begin
      PrefetchSize := StrToIntDef(OptionsSubscribeForm.EditPrefetchSize.Text,
        0);
    end;
  finally
    OptionsSubscribeForm.Free;
  end;
end;

//-----------------------------------------------------------
// Set log detail level
//-----------------------------------------------------------

procedure TDemoMainForm.CbxDebugClick(Sender: TObject);
begin
  if CbxDebug.Checked then
    Logger.LogLevel := logDebug
  else
    Logger.LogLevel := logInfo
end;

//-----------------------------------------------------------
// Set enabled buttons
//-----------------------------------------------------------

procedure TDemoMainForm.ActionList1Update(Action: TBasicAction; var Handled:
  Boolean);
begin
  ActionConnect.Enabled := not (Assigned(Transport) and Transport.StompConnected);
  ActionDisconnect.Enabled := Assigned(Transport) and Transport.StompConnected;

  ActionSession.Enabled := Assigned(Transport) and Transport.StompConnected and not Assigned(Session);
  ActionCloseSession.Enabled := Assigned(Session);

  ActionNewDest.Enabled := (LbxDest.Items.IndexOf(NewDest) = -1) and Assigned(Transport) and
    Transport.StompConnected;

  ActionSub.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionOptionsSubscribe.Enabled := False;

  ActionSend.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionSendFile.Enabled := (SelectedDestination <> '') and Assigned(Session);

  ActionSendObjects.Enabled := (SelectedDestination <> '') and Assigned(Session);
  ActionOptionsSend.Enabled := (SelectedDestination <> '') and Assigned(Session);

  ActionCommit.Enabled := Assigned(Session) and Session.Transacted;
  ActionAbort.Enabled := Assigned(Session) and Session.Transacted;

  ComboCommLib.Enabled := not (Assigned(Transport) and Transport.StompConnected);

  StatusBar1.SimpleText :=
    Format('Received %d messages (in %d STOMP frames)',
    [JMSMessages.Count, FrameList.Items.Count]);
end;

//-----------------------------------------------------------
// Returns the type of the selected destination ('q' or 't')
//-----------------------------------------------------------

function TDemoMainForm.SelectedDestinationType: string;
begin
  Result := Copy(LbxDest.Items[LbxDest.ItemIndex], 2, 1);
end;

//-----------------------------------------------------------
// Returns the selected destination
//-----------------------------------------------------------

function TDemoMainForm.SelectedDestination: string;
begin
  if LbxDest.ItemIndex = -1 then
    Result := ''
  else
    Result := LbxDest.Items[LbxDest.ItemIndex];
end;

//-----------------------------------------------------------
// Returns destination which cann be added to the list
//-----------------------------------------------------------

function TDemoMainForm.NewDest: string;
begin
  Result := '/' + ComboBox1.Items[ComboBox1.ItemIndex] + '/' + EditDest.Text;
end;

procedure TDemoMainForm.Quit1Click(Sender: TObject);
begin
  Close;
end;

//-----------------------------------------------------------
//  About me
//-----------------------------------------------------------

procedure TDemoMainForm.About1Click(Sender: TObject);
begin
  ShowMessage(Caption + #13#10 + 'www.mikejustin.com');
end;

end.

