/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.treetable;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.Arrays;
import java.util.List;


/**
 * Sample implementation of <code>TreeTable</code> node. It extends <code>DefaultMutableTreeNode</code>
 * and manages the list of it's column values.
 */
public class TreeTableNode extends DefaultMutableTreeNode {
    /**
     * List of column values.
     */
    protected List columnValues;

    /**
     * Creates a tree node with specified column values.
     *
     * @param columnValues list of column values
     */
    public TreeTableNode(List columnValues) {
        this.columnValues = columnValues;
    }

    /**
     * Creates a tree node with specified column values.
     *
     * @param columnValues array of column values
     */
    public TreeTableNode(Object[] columnValues) {
        this.columnValues = Arrays.asList(columnValues);
    }

    /**
     * Returns string presentation of the first value in the list.
     * It is needed to show this value in the JTree.
     *
     * @return string presentation of the node.
     */
    public String toString() {
        try {
            return columnValues.get(0).toString();
        } catch (Exception e) {
            return "No Value";
        }
    }

    /**
     * Returns value for the column.
     *
     * @param index index of the column
     * @return value for the column.
     */
    public Object getValueAt(int index) {
        return columnValues.get(index);
    }

    /**
     * Indicates whether the value for the column is editable.
     *
     * @param index index of the column
     * @return <code>true</code> if the value is editable, <code>false</code> otherwise.
     */
    public boolean isEditable(int index) {
        return true;
    }

    /**
     * Sets the value for the column.
     *
     * @param value new value
     * @param index index of the column
     */
    public void setValueAt(Object value, int index) {
        columnValues.set(index, value);
    }
}
