/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.treetable;

import javax.swing.tree.TreeModel;


/**
 * <code>TreeTableModel</code> is the model used by <code>JTreeTable</code>.
 * It extends <code>TreeModel</code> and defines methods required by <code>JTreeTable</code>.
 */
public interface TreeTableModel extends TreeModel {
    /**
     * Returns the number of columns.
     *
     * @return the number of columns.
     */
    public int getColumnCount();

    /**
     * Returns column's name.
     *
     * @param column index of column
     * @return column's name.
     */
    public String getColumnName(int column);

    /**
     * Returns column's class.
     *
     * @param column index of column
     * @return column's class.
     */
    public Class getColumnClass(int column);

    /**
     * Returns the value displayed for node <code>node</code>
     * at column index <code>column</code>.
     *
     * @param node   tree node
     * @param column index of column
     * @return displayed value.
     */
    public Object getValueAt(Object node, int column);

    /**
     * Indicates whether the value for node <code>node</code>
     * at column index <code>column</code> is editable.
     *
     * @param node   tree node
     * @param column index of column
     * @return <code>true</code> if the value is editable, <code>false</code> otherwise.
     */
    public boolean isCellEditable(Object node, int column);

    /**
     * Sets the value for node <code>node</code>
     * at column index <code>column</code>.
     *
     * @param value  new value
     * @param node   tree node
     * @param column index of column
     */
    public void setValueAt(Object value, Object node, int column);
}
