/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.treetable;

import javax.swing.tree.DefaultTreeModel;


/**
 * Sample <code>TreeTableModel</code> implementation.
 */
public class DefaultTreeTableModel extends DefaultTreeModel implements TreeTableModel {
    /**
     * Names of columns.
     */
    protected String[] columnNames = {"Name", "Value", "Description"};
    /**
     * Classes of columns.
     */
    protected Class[] columnClasses = {TreeTableModel.class, String.class, String.class};

    /**
     * Creates <code>DefaultTreeTableModel</code> object with specified root.
     *
     * @param root root of the tree
     */
    public DefaultTreeTableModel(TreeTableNode root) {
        super(root);
    }

    // TreeTableModel interface implementation

    /**
     * Returns the number of columns.
     *
     * @return the number of columns.
     */
    public int getColumnCount() {
        return columnNames.length;
    }

    /**
     * Returns column's name.
     *
     * @param column index of column
     * @return column's name.
     */
    public String getColumnName(int column) {
        return columnNames[column];
    }

    /**
     * Returns column's class.
     *
     * @param column index of column
     * @return column's class.
     */
    public Class getColumnClass(int column) {
        return columnClasses[column];
    }

    /**
     * Returns the value displayed for node <code>node</code>
     * at column index <code>column</code>.
     *
     * @param node   tree node
     * @param column index of column
     * @return displayed value.
     */
    public Object getValueAt(Object node, int column) {
        return ((TreeTableNode) node).getValueAt(column);
    }

    /**
     * Indicates whether the value for node <code>node</code>
     * at column index <code>column</code> is editable.
     *
     * @param node   tree node
     * @param column index of column
     * @return <code>true</code> if the value is editable, <code>false</code> otherwise.
     */
    public boolean isCellEditable(Object node, int column) {
        return ((TreeTableNode) node).isEditable(column);
    }

    /**
     * Sets the value for node <code>node</code>
     * at column index <code>column</code>.
     *
     * @param value  new value
     * @param node   tree node
     * @param column index of column
     */
    public void setValueAt(Object value, Object node, int column) {
        ((TreeTableNode) node).setValueAt(value, column);
    }
}
