/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.table;

import javax.swing.table.TableModel;


/**
 * Default implementation of {@link RowComparator} interface.
 */
public class DefaultRowComparator implements RowComparator {

    /**
     * Compares two rows for order. Returns a negative integer, zero,
     * or a positive integer as the first row is less than, equal to,
     * or greater than the second.
     *
     * @param row1       the first row to be compared
     * @param row2       the second row to be compared
     * @param column     sorting column
     * @param tableModel table's model
     * @return a negative integer, zero, or a positive integer as the
     *         first row is less than, equal to, or greater than the
     *         second.
     */
    public int compare(int row1, int row2, int column, TableModel tableModel) {
        Object o1 = tableModel.getValueAt(row1, column);
        Object o2 = tableModel.getValueAt(row2, column);
        // null is less than any object
        if (o1 == null && o2 == null)
            return 0;
        else if (o1 == null)
            return -1;
        else if (o2 == null)
            return 1;
        try {
            return ((Comparable) o1).compareTo(o2);
        } catch (Exception e) {
            return 0;
        }
    }
}
