/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.asc.outlookpanel.renderers;

import com.smardec.asc.outlookpanel.JOutlookButton;
import com.smardec.asc.outlookpanel.OutlookButtonRenderer;

import javax.swing.*;
import java.awt.*;


/**
 * Default <code>OutlookButtonRenderer</code> implementation.
 */
public class DefaultOutlookButtonRenderer extends JButton implements OutlookButtonRenderer {
    /**
     * Constructs <code>DefaultOutlookButtonRenderer</code> object.
     */
    public DefaultOutlookButtonRenderer() {
        setOpaque(true);
        setFocusPainted(false);
        setBorder(BorderFactory.createEtchedBorder());
        setText("");
    }

    /**
     * Returns the component whose paint() method will render the specified button.
     *
     * @param jOutlookButton the button we're painting
     * @param mouseOver      indicates that the mouse is over the tab header
     * @param mousePressed   indicates that the mouse is pressed on the tab header
     * @return the component whose paint() method will render the specified button.
     */
    public Component getOutlookButtonRendererComponent(JOutlookButton jOutlookButton, boolean mouseOver, boolean mousePressed) {
        if (jOutlookButton.getOutlookTab() != null && jOutlookButton.getOutlookTab().getOutlookPanel() != null) {
            setSize(jOutlookButton.getSize());
            if (mouseOver)
                if (mousePressed) {
                    getModel().setPressed(true);
                    getModel().setArmed(true);
                } else {
                    getModel().setPressed(false);
                    getModel().setArmed(false);
                }
            else {
                getModel().setPressed(false);
                getModel().setArmed(false);
            }

            setIcon(jOutlookButton.getIcon());
            setBackground(new Color(getBackground().getRGB(), false));
        }
        return this;
    }
}
