/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class NonPlsqlTTCDataSet
extends TTCDataSet {
    private NonPlsqlTTCColumn[] columns;
    private boolean streaming;

    protected NonPlsqlTTCDataSet(NonPlsqlTTCColumn[] nonPlsqlTTCColumnArray, int n2) {
        super(nonPlsqlTTCColumnArray, n2);
        this.columns = nonPlsqlTTCColumnArray != null ? nonPlsqlTTCColumnArray : new NonPlsqlTTCColumn[]{};
        this.streaming = false;
    }

    protected void marshalRow() throws SQLException, IOException {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.columns.length) {
            if (!this.columns[n3].sizeExceeded()) {
                if (this.columns[n3].type.isStream()) {
                    this.columns[n3].pushStream();
                } else {
                    this.columns[n3].marshal();
                }
            } else if (n2 != -1) {
                if (this.columns[n3].type.isStream()) {
                    this.columns[n3].pushStream();
                } else {
                    this.columns[n3].marshal();
                }
            } else {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 != -1) {
            if (this.columns[n2].type.isStream()) {
                this.columns[n2].pushStream();
            } else {
                this.columns[n2].marshal();
            }
        }
        ++this.marshaledRows;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        this.unmarshaledCols = -1;
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].clearNull();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.columns.length) {
            this.streaming = this.columns[n3].unmarshal();
            if (this.streaming) {
                return true;
            }
            this.incrementUnmarshaledcols();
            ++n3;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    protected boolean unmarshalRow(int n2, int n3) throws SQLException, IOException {
        this.streaming = false;
        int n4 = n2;
        while (n4 <= n3) {
            if (this.columns[n4].unmarshal()) {
                DBError.check_error(401);
            }
            this.incrementUnmarshaledcols();
            ++n4;
        }
        if (this.isLastCol()) {
            this.incrementeUnmarshaledRows();
        }
        return false;
    }

    public void processIndicator() throws IOException, SQLException {
        this.columns[this.unmarshaledCols].setItemOriginalSize(this.unmarshaledRows);
    }

    protected boolean next() {
        boolean bl = this.columns.length > 0 ? this.columns[0].moreRows() : false;
        return bl;
    }

    protected void print(int n2, int n3, int n4) {
        OracleLog.print(this, n2, n3, n4, "    ---- Enter: NonPlsqlTTCDataSet.print --- ");
        super.print(n2, n3, n4);
        OracleLog.print(this, n2, n3, n4, "   unmarshaledCols = " + this.unmarshaledCols);
        OracleLog.print(this, n2, n3, n4, "   streaming       = " + this.streaming);
        OracleLog.print(this, n2, n3, n4, "    ---- Exit: NonPlsqlTTCDataSet.print --- \n");
    }
}

