/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

public class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor m_desc;
    OracleTypeADT m_otype;
    OracleType[] m_types;

    public StructMetaData(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            DBError.check_error(1, "illegal operation: descriptor is null");
        }
        this.m_desc = structDescriptor;
        this.m_otype = structDescriptor.getOracleTypeADT();
        this.m_types = this.m_otype.getAttrTypes();
    }

    public int getColumnCount() throws SQLException {
        return this.m_types.length;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n2) throws SQLException {
        return false;
    }

    public boolean isCurrency(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3] instanceof OracleTypeNUMBER || this.m_types[n3] instanceof OracleTypeFLOAT;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3] instanceof OracleTypeCHAR;
    }

    public int isNullable(int n2) throws SQLException {
        return 1;
    }

    public boolean isSigned(int n2) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        if (this.m_types[n3] instanceof OracleTypeCHAR) {
            return ((OracleTypeCHAR)this.m_types[n3]).getLength();
        }
        if (this.m_types[n3] instanceof OracleTypeRAW) {
            return ((OracleTypeRAW)this.m_types[n3]).getLength();
        }
        return 0;
    }

    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    public String getColumnName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_otype.getAttributeName(n2);
    }

    public String getSchemaName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        if (this.m_types[n3] instanceof OracleTypeADT) {
            return ((OracleTypeADT)this.m_types[n3]).getSchemaName();
        }
        return "";
    }

    public int getPrecision(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3].getPrecision();
    }

    public int getScale(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3].getScale();
    }

    public String getTableName(int n2) throws SQLException {
        return null;
    }

    public String getCatalogName(int n2) throws SQLException {
        return null;
    }

    public int getColumnType(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3].getTypeCode();
    }

    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        int n4 = this.getValidColumnIndex(n2);
        switch (n3) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 91: {
                return "DATE";
            }
            case -104: {
                return "INTERVALDS";
            }
            case -103: {
                return "INTERVALYM";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return ((OracleTypeADT)this.m_types[n4]).getFullName();
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)this.m_types[n4]).getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        return false;
    }

    public boolean isWritable(int n2) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return false;
    }

    public String getColumnClassName(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -2: {
                return "byte[]";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "java.math.BigDecimal";
            }
            case 91: {
                return "java.sql.Timestamp";
            }
            case -103: {
                return "oracle.sql.INTERVALYM";
            }
            case 93: {
                return "oracle.sql.TIMESTAMP";
            }
            case -101: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case -102: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 2004: {
                return "oracle.sql.BLOB";
            }
            case 2005: {
                return "oracle.sql.CLOB";
            }
            case -13: {
                return "oracle.sql.BFILE";
            }
            case 2002: 
            case 2008: {
                return "oracle.sql.STRUCT";
            }
            case 2007: {
                return "oracle.sql.OPAQUE";
            }
            case 2003: {
                return "oracle.sql.ARRAY";
            }
            case 2006: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public String getOracleColumnClassName(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 1: 
            case 12: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2008: {
                return "JAVA_STRUCT";
            }
            case 2007: {
                return "OPAQUE";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    public int getLocalColumnCount() throws SQLException {
        return this.m_desc.getLocalAttributeCount();
    }

    public boolean isInherited(int n2) throws SQLException {
        return n2 <= this.getColumnCount() - this.getLocalColumnCount();
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_desc.getAttributeJavaName(n3);
    }

    private int getValidColumnIndex(int n2) throws SQLException {
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.m_types.length) {
            DBError.check_error(3, "getValidColumnIndex");
        }
        return n3;
    }

    public boolean isNCHAR(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.m_types[n3].isNCHAR();
    }
}

