rem : Module     - ssaudit.bat 1.5
rem : Updated    - 07/19/2004
rem :              Now calls xphysical_day_gen.bat using extended ssxphysical utility.
rem : Purpose    - Nightly SourceSafe database audit.

rem : Run From   - X:\Program Files\Microsoft Visual Studio\Common\Vss\utilities
rem                (Create as peer of ....\Vss\Win32 directory)

rem : Parameters  NOTE! Full path parameters MUST be quoted strings!
rem : - %1 Drive letter of drive containing the ...\vss\data directory e.g: X
rem : - %2 Full path to data directory e.g: X:\....\vss\data
rem : - %3 Drive letter of drive containing ...\Common\vss\win32 directory e.g.: C
rem : - %4 Full path to the vss install directory e.g.: c:\Program Files\...\Common\vss
rem : - %5 Configuration engineer email name
rem : - %6 Yourcompany.com
rem : - %7 Temporary directory free space left warning limit (Mb)

rem : Outputs    - Analyze.bad and analyze.log files and emails the log to you.
rem :            - physical.mon thru physical.sun files
rem :              (abcdaaaa physical to $/Project/... logical file mapping)
rem :            - physical.tot  : running project and file counts each day
rem :            - ss_openfiles  : Files open at the start of the run
rem :            - ssutility.log : record of utility processing.

rem : Pre-Req #1 - Run under the commercial Scheduler! The 'at' schedule service DOES NOT WORK!.
rem : Pre-Req #2 - wMailTo.exe must be in this directory.
rem : Pre-Req #3 - wMailTo.ini must be in the WINNT directory.
rem : Pre-Req #4 - wMessage.txt must be in this directory.
rem : Pre-Req #5 - Program dirsize must be in the Utilities directory.
rem :              This is used to monitor the size of the temp directory.
rem : Pre-Req #6 - The NT loginId used to log into the Sourcesafe server
rem :              (default loginId is 'Administrator') must also have
rem :              access rights defined using SSAdmin.exe to access the
rem :              Sourcesafe project specified to contain the analyze.log.
rem :            - If cp/co/ci fail with 'Access to file ..\um.dat denied'
rem :              do 'ss whoami' to get current username (Administrator)
rem :              and use SSadmin.exe to give rights to the username
rem :              to access the ss project containing analyze.log.

rem -------------------------------------------------------------------------
rem : Remove quotes from parameter 2
set ssparm2=%2
set ssparm2=%ssparm2:"=%
set ssparm2=%ssparm2:"=%

rem : Remove quotes from parameter 4
set ssparm4=%4
set ssparm4=%ssparm4:"=%
set ssparm4=%ssparm4:"=%

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

net send %4% SourceSafe audit.bat started
echo exit|cmd /q /k prompt $D $T ssaudit.bat : started. >> ssutility.log

rem : generate database-logical file concordance
call xphysical_day_gen.bat null null %3 %4 %5

:Mail
rem : Email Configuration engineer if the temp directory exceeds the threshold (MB)
dirsize "%ssparm4%\temp" %7%
rem Report exit return from dirsize
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=
net send %5% audit.bat : dirsize exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T ssaudit.bat : dirsize exit code = %ERLVL% >> ssutility.log

if ERRORLEVEL 1 if not ERRORLEVEL 2 goto TmpHi
if ERRORLEVEL 0 if not ERRORLEVEL 1 goto TempLo

:TempHi
wmailto %5%@%6% "-sSourceSafe Temp directory size EXCEEDS threshold" --<dirsize.txt
net send %5% SourceSafe audit.bat : Temp Dir above threshold. Continuing...
goto Analyze

:TempLo
net send %5% audit.bat : Temp Dir below threshold. Continuing...
goto Analyze

:Analyze
rem : switch to the vss database tree drive
%1%:

rem : clean out yesterday's logs on the database drive
c:\winnt\system32\attrib -r analyze.*
erase "%ssparm2%\backup\analyze.*"

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

rem : remove last night's analyze.log
c:\winnt\system32\attrib -r analyze.*
erase analyze.log

rem : list open files
net files > ss_openfiles.txt
wmailto %5%@%6% "-sSourceSafe Open Files immediately prior to analyze -x run" --<ss_openfiles.txt

rem : v3 show all errors and inconsistencies
net send %5% audit.bat : analyze started in -x (analyse-while-open) mode.
echo exit|cmd /q /k prompt $D $T ssaudit.bat : analyze started in -x [analyze-while-open] mode. >> ssutility.log

analyze %2 -x -v3 -i-

net send %5% SourceSafe audit.bat : analyze pass completed.
echo exit|cmd /q /k prompt $D $T ssaudit.bat : analyze utility ended. >> ssutility.log

rem : copy the analyse log to the utility directory
copy "%ssparm2%\backup\analyze.*"

wmailto -ianalyze.log %4%@%5% "-sSourceSafe overnight analyze log" --<wMessage.txt

:Exit
net send %5% SourceSafe audit.bat completed.
echo exit|cmd /q /k prompt $D $T ssaudit.bat : ended. >> ssutility.log

exit
