package Tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;

import unity.jdbc.UnityConnection;
import unity.jdbc.UnityResultSet;

public class MyDataModel extends AbstractTableModel implements Comparator  
{
		private static final long serialVersionUID = 1L;
		private Connection con;
		private ResultSet rs;
		private Statement stmt;
		private ArrayList results;
		private ArrayList columnNames;
		private int count;
		private long queryStartTime;
		private JTextArea messageBox;
		
		public MyDataModel()
		{	results = new ArrayList();
			columnNames = new ArrayList();
		}

		public Object getValueAt(int r, int c) 	{
			try {
			ArrayList row = (ArrayList) results.get(r);
			CellData cd = (CellData) row.get(c);
			if (cd.isMultiValue())
				return cd.getDataArray();
			else
				return cd.getData();
			}
			catch (Exception e)
			{	// Discard errors that occur due to synchronization problems (query updating table and event queue trying to display it)	
				return null;
			}
		}
		public int getRowCount() 				{ return count; }// {  if (count > 1000) return 1000; else return count; }//return results.size(); }
  		public int getColumnCount() 			{ return columnNames.size(); }
 		public String getColumnName(int c) 		{ return (String) columnNames.get(c); }
		public Class getColumnClass(int c) {	// JTable calls this method to automatically create correct type in cell
            Object obj = getValueAt(0, c);
            if (obj != null)
            	return obj.getClass();
            else
            	return Object.class;
        }
		public boolean isCellEditable(int r, int c) {
        //	Indicate that cells with multivalues are editable so they can use the combobox
        	ArrayList row = (ArrayList) results.get(r);
			CellData cd = (CellData) row.get(c);
			if (cd.isMultiValue())
				return true;
			else
				return false;
        }

		public void doQuery(String sql, long startTime, JTextArea msgBox) throws SQLException
		{		// Indicate table changes when start query
//				columnNames.removeAllElements();
				fireTableChanged(null);
				fireTableDataChanged();
				queryStartTime = startTime;
				messageBox = msgBox;
				stmt = con.createStatement();
				rs = stmt.executeQuery(sql);
				bufferResults();
				stmt.close();
		}

		public void closeDBConnection()
		{	if (con != null)
			{	try { con.close(); }
				catch (SQLException ex) { System.err.println("SQLException: " + ex.getMessage()); }
			}
			con = null;
		}

		public void makeDBConnection(String url)
		{
			con = null;

			try {
				Class.forName("unity.jdbc.UnityDriver");
			}
			catch (java.lang.ClassNotFoundException e) {
				System.err.println("ClassNotFoundException: " +e.getMessage());
			}

			// Initiate connection
			try {	
				con = DriverManager.getConnection(url,"unity","unity");
				//con = DriverManager.getConnection(url);
                
			} catch (SQLException ex) {
				System.err.println("SQLException: " + ex.getMessage());
			}
		}

		public ArrayList getDatabases()
		{	return ((UnityConnection) con).getDatabases();
		}

		
		private void bufferResults() throws SQLException
		{
			UnityResultSet urs = (UnityResultSet) rs;
			results = new ArrayList();

			// Retrieve column names
			ResultSetMetaData rsmd = rs.getMetaData();
			int numcols = rsmd.getColumnCount();
			columnNames = new ArrayList();
			
			for (int i=1; i <= numcols; i++)
				columnNames.add(rsmd.getColumnName(i));

			// Only buffering first 1,000,000
			count = 0;
			
			while (urs.next())
			{
				count++;
				
				if (count == 1 || count == 10 || count== 100 || count == 1000 || count == 10000 || count == 100000)
				{	long currentTime = System.currentTimeMillis();
					long timeDiff = currentTime - queryStartTime;
					messageBox.append("Query result "+count+" at time: "+timeDiff+"\n");
					fireTableChanged(null);	// Fire during download so results appear quicker
					fireTableDataChanged();
				}
								
				if (count < 1000000)
				{
					ArrayList v = new ArrayList();

					for (int i=1; i <= numcols; i++)
					{	Object obj = rs.getObject(i);

						// Multi-values currently not supported in this release
						if (!(obj instanceof ArrayList))	// If ArrayList, must be multi-value object
						{	// One value
							CellData cd = new CellData(obj,false,null);
							v.add(cd);
						}
						else
						{
							CellData cd = new CellData(obj,true, (ArrayList) obj);
							v.add(cd);
						}
					}
					results.add(v);
				}
			}
			fireTableChanged(null);
			fireTableDataChanged();
		}

		private class CellData implements Comparable
		{	private Object data;
			private boolean multiValue;
			private ArrayList dataVals;

			public CellData() 						{ dataVals = null; data = null;}
			public CellData(Object d, boolean b, ArrayList a)
			{	data = d; multiValue = b; dataVals = a; }

			public Object getData()					{ return data; }
			public void setData(Object o)			{ data = o; }
			public boolean isMultiValue()			{ return multiValue; }
			public void setMultiValue(boolean b)	{ multiValue = b; }
			public ArrayList getDataArray()			{ return dataVals; }
			public void setDataArray(ArrayList a)	{ dataVals = a; }

			public int compareTo(Object o)
			{	if (o.getClass() != CellData.class)
					return -1;	// Incompatible classes

				CellData other = (CellData) o;
				Comparable thisData, otherData;

				if (other.isMultiValue())
					otherData = (Comparable) other.dataVals.get(0);
				else
					otherData = (Comparable) other.data;

				if (otherData == null)
					return -1;

				if (this.isMultiValue())
					thisData = (Comparable) this.dataVals.get(0);
				else
					thisData = (Comparable) this.data;

				if (thisData == null)
					return 1;

				return otherData.compareTo(thisData);
			}

		}

	 int sortColumn = -1;
	 boolean sortAsc = false;

	 public void sortColumn(int sortColumn) {
		 if (sortColumn == this.sortColumn)
		 	sortAsc = !sortAsc;  	// Flip sort order

		 this.sortColumn = sortColumn;
		 Collections.sort(results,this);
	 }

	 public int compare(Object o1, Object o2)  {
		  if (o1 == null) return -1;
		  if (o2 == null) return 1;

		  ArrayList vect1 = (ArrayList) o1;
		  ArrayList vect2 = (ArrayList) o2;

		  Comparable col1 = (Comparable) vect1.get(sortColumn);
		  Comparable col2 = (Comparable) vect2.get(sortColumn);
		  if (sortAsc)
			  return col1.compareTo(col2);
		  else
			  return col2.compareTo(col1);
	 }
}
