/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import unity.jdbc.LocalResultSetMetaData;

public class LocalResultSet
implements ResultSet {
    protected SQLWarning _warnings = null;
    protected boolean _wasNullFlag = false;
    protected boolean _reallyResult = false;
    protected int _resultSetType = 0;
    protected int _resultSetConcurrency = 0;
    protected boolean _closed = false;
    protected long _updateID = -1L;
    protected long _updateCount;
    protected int _fetchsize;
    protected ArrayList dataRows;
    protected ArrayList metadata;
    private String[] columnHeaders;
    private int cursor;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;
    int HOLD_CURSORS_OVER_COMMIT = 1;
    public int CLOSE_CURSORS_AT_COMMIT = 2;

    public LocalResultSet(ArrayList data, String[] headers, ArrayList md) throws SQLException {
        this.dataRows = data;
        this.metadata = md;
        this.cursor = -1;
        this.columnHeaders = headers;
    }

    public boolean next() throws SQLException {
        ++this.cursor;
        return this.cursor < this.dataRows.size();
    }

    public void close() throws SQLException {
        this.dataRows = null;
        this._closed = true;
    }

    public String getString(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public byte getByte(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0;
        }
        return (Byte)obj;
    }

    public short getShort(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0;
        }
        return (Short)obj;
    }

    public int getInt(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0;
        }
        return (Integer)obj;
    }

    public long getLong(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0L;
        }
        return (Long)obj;
    }

    public float getFloat(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0.0f;
        }
        return ((Float)obj).floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return 0.0;
        }
        return (Double)obj;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        return (byte[])obj;
    }

    public Date getDate(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        return (Date)obj;
    }

    public Time getTime(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        return (Time)obj;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        return (Timestamp)obj;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        Object obj = currentRow.get(columnIndex - 1);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        byte[] b = this.getBytes(columnIndex);
        return new ByteArrayInputStream(b);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new LocalResultSetMetaData(this.columnHeaders, this.metadata);
    }

    public Object getObject(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return currentRow.get(columnIndex - 1);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        String columnNameCleaned = columnName.trim();
        int i = 0;
        while (i < this.columnHeaders.length) {
            if (columnNameCleaned.equalsIgnoreCase(this.columnHeaders[i])) {
                return i + 1;
            }
            ++i;
        }
        throw new SQLException("Syntax Error: Unknown column name " + columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (BigDecimal)currentRow.get(columnIndex - 1);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.cursor < 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.cursor >= this.dataRows.size();
    }

    public boolean isFirst() throws SQLException {
        return this.cursor == 0;
    }

    public boolean isLast() throws SQLException {
        return this.cursor == this.dataRows.size() - 1;
    }

    public void beforeFirst() throws SQLException {
        this.cursor = -1;
    }

    public void afterLast() throws SQLException {
        this.cursor = this.dataRows.size();
    }

    public boolean first() throws SQLException {
        return this.cursor == 0;
    }

    public boolean last() throws SQLException {
        return this.cursor == this.dataRows.size() - 1;
    }

    public int getRow() throws SQLException {
        return this.cursor + 1;
    }

    public boolean absolute(int row) throws SQLException {
        this.cursor = row >= 0 ? row : this.dataRows.size() - 1 - row;
        return this.cursor >= 0 && this.cursor < this.dataRows.size();
    }

    public boolean relative(int rows) throws SQLException {
        this.cursor += rows;
        return this.cursor >= 0 && this.cursor < this.dataRows.size();
    }

    public boolean previous() throws SQLException {
        --this.cursor;
        return this.cursor >= 0;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
        this._fetchsize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this._fetchsize;
    }

    public int getType() throws SQLException {
        return this._resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void deleteRow() throws SQLException {
    }

    public void refreshRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (Ref)currentRow.get(i);
    }

    public Blob getBlob(int i) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (Blob)currentRow.get(i);
    }

    public Clob getClob(int i) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (Clob)currentRow.get(i);
    }

    public Array getArray(int i) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (Array)currentRow.get(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    public URL getURL(int columnIndex) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (URL)currentRow.get(columnIndex - 1);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("Read-only resultset.  No updates are allowed.");
    }

    public boolean wasNull() throws SQLException {
        return this._wasNullFlag;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        ArrayList currentRow = (ArrayList)this.dataRows.get(this.cursor);
        return (BigDecimal)currentRow.get(columnIndex - 1);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(String ColumnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(ColumnName));
    }

    public BigDecimal getBigDecimal(String ColumnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(ColumnName), scale);
    }
}

