/*
 * Decompiled with CFR 0.152.
 */
package unity.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import unity.util.XMLEncryptDecrypt;

public class FileManager {
    public static BufferedReader openTextInputFile(String fname) throws FileNotFoundException {
        return new BufferedReader(new FileReader(fname));
    }

    public static PrintWriter openTextOutputFile(String fname) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(fname)));
    }

    public static BufferedInputStream openInputFile(String fname) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(fname));
    }

    public static BufferedOutputStream openOutputFile(String fname) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(fname));
    }

    public static RandomAccessFile openInputOutputFile(String fname, String mode) throws FileNotFoundException {
        RandomAccessFile x = new RandomAccessFile(fname, mode);
        return x;
    }

    public static void closeFile(RandomAccessFile f) throws IOException {
        f.close();
    }

    public static void closeFile(BufferedReader breader) throws IOException {
        breader.close();
    }

    public static void closeFile(PrintWriter pwriter) throws IOException {
        pwriter.close();
    }

    public static void closeFile(BufferedInputStream f) throws IOException {
        f.close();
    }

    public static void closeFile(BufferedOutputStream f) throws IOException {
        f.close();
    }

    public static String getFileName(String pathName) {
        int idx = pathName.lastIndexOf("/");
        if (idx == -1) {
            return pathName;
        }
        return pathName.substring(idx + 1);
    }

    public static String getPath(String pathName) {
        int idx = pathName.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return pathName.substring(0, idx + 1);
    }

    public static String createTempFileName(String hint) {
        long time = System.currentTimeMillis();
        return String.valueOf(hint) + "_" + time + ".dat";
    }

    public static String getTemporaryPath() throws IOException {
        File out = null;
        out = File.createTempFile("tempBatch", "");
        String tempPath = out.getPath();
        out.delete();
        out = new File(tempPath);
        if (out.mkdirs()) {
            out.deleteOnExit();
        }
        return out.getPath();
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileManager.deleteDirectory(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static void deleteFile(String fname) {
        File f = new File(fname);
        f.delete();
    }

    public static String getXMLFile(String resource) throws IOException {
        if (resource.indexOf("jdbc:Unity://") == 0) {
            resource = resource.substring(13);
        }
        if (new File(resource).exists() || resource.indexOf("http") >= 0) {
            return resource;
        }
        String context = resource.substring(0, resource.indexOf(47));
        String name = resource.substring(resource.indexOf(47) + 1, resource.length());
        String out = null;
        URL url = FileManager.JarFind(String.valueOf(context) + "/" + name);
        out = url.toString().replaceAll("%20", " ");
        return out;
    }

    public static InputStream getStream(String fileName) throws IOException {
        InputStream in = null;
        if (fileName.indexOf("jar") >= 0) {
            String jarFileStr = fileName.substring(10, fileName.indexOf("!"));
            String contextName = fileName.substring(fileName.indexOf("!") + 2);
            JarFile jar = null;
            jar = new JarFile(jarFileStr);
            ZipEntry need = jar.getEntry(contextName);
            in = jar.getInputStream(need);
        } else if (fileName.indexOf("http") >= 0) {
            String urlStr = fileName.substring(fileName.indexOf("http"));
            URL myUrl = new URL(urlStr);
            URLConnection conn = myUrl.openConnection();
            conn.connect();
            in = conn.getInputStream();
        } else {
            try {
                if (fileName.indexOf("file:") >= 0) {
                    fileName = fileName.substring(fileName.indexOf("file:"));
                }
                in = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Input file not found: " + fileName);
            }
        }
        return in;
    }

    public static InputStream getDecryptedStream(String fileName, String password) throws IOException {
        InputStream in = FileManager.getStream(fileName);
        XMLEncryptDecrypt data = new XMLEncryptDecrypt(password);
        InputStream newIn = data.getDecryptStream(in);
        return newIn;
    }

    public static URL JarFind(String fileName) throws IOException {
        URL url = ClassLoader.getSystemClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException("File not found in Jar.");
        }
        return url;
    }
}

