/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import unity.annotation.CommonMethods;
import unity.annotation.SourceTable;
import unity.util.StringFunc;

public class SourceField {
    protected String tableCatalog;
    protected String tableSchema;
    protected String tableName;
    protected String columnName;
    protected String dataTypeName;
    protected String remarks;
    protected String defaultValue;
    protected String isNullable;
    protected String scopeCatalog;
    protected String scopeSchema;
    protected String scopeTable;
    protected int dataType;
    protected int columnSize;
    protected int decimalDigits;
    protected int numberPrecisionRadix;
    protected int nullable;
    protected int characterOctetLength;
    protected int ordinalPosition;
    protected int sourceDataType;
    protected int numDistinctValues;
    protected SourceTable parentTable;

    public SourceField() {
    }

    public SourceField(String cat, String schema, String table, String name, int type, String typeName, int size, int digits, int precision, int n, String rem, String def, int octetLength, int position, String isNull) {
        this.tableCatalog = cat;
        this.tableSchema = schema;
        this.tableName = table;
        this.columnName = name;
        this.dataType = type;
        this.dataTypeName = typeName;
        this.columnSize = size;
        this.decimalDigits = digits;
        this.numberPrecisionRadix = precision;
        this.nullable = n;
        this.remarks = rem;
        this.defaultValue = def;
        this.characterOctetLength = octetLength;
        this.ordinalPosition = position;
        this.isNullable = isNull;
    }

    public void setParentTable(SourceTable table) {
        this.parentTable = table;
    }

    public SourceTable getParentTable() {
        return this.parentTable;
    }

    public void setTableCatalog(String cat) {
        this.tableCatalog = cat;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public void setTableSchema(String schema) {
        this.tableSchema = schema;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setColumnName(String name) {
        this.columnName = name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameWithTable() {
        return String.valueOf(this.tableName) + "." + this.columnName;
    }

    public String getColumnNameWithSchema() {
        return String.valueOf(this.parentTable.getNameWithSchema()) + "." + this.columnName;
    }

    public String getFullColumnName() {
        return String.valueOf(this.parentTable.getFullName()) + "." + this.columnName;
    }

    public String getSQLColumnName() {
        return StringFunc.delimitName(this.columnName);
    }

    public String getSQLColumnNameWithTable() {
        return String.valueOf(this.parentTable.getSQLTableName()) + "." + this.getSQLColumnName();
    }

    public String getSQLColumnNameWithSchema() {
        return String.valueOf(this.parentTable.getSQLTableNameWithSchema()) + "." + this.getSQLColumnName();
    }

    public String getFullSQLColumnName() {
        return String.valueOf(this.parentTable.getFullSQLTableName()) + "." + this.getSQLColumnName();
    }

    public void setDataTypeName(String typeName) {
        this.dataTypeName = typeName;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setColumnSize(int size) {
        this.columnSize = size;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setDecimalDigits(int digits) {
        this.decimalDigits = digits;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setNumberPrecisionRadix(int precision) {
        this.numberPrecisionRadix = precision;
    }

    public int getNumberPrecisionRadix() {
        return this.numberPrecisionRadix;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setRemarks(String rem) {
        this.remarks = rem;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setDefaultValue(String def) {
        this.defaultValue = def;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setCharacterOctetLength(int octetLength) {
        this.characterOctetLength = octetLength;
    }

    public int getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setOrdinalPosition(int position) {
        this.ordinalPosition = position;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setIsNullable(String isNull) {
        this.isNullable = isNull;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public int getNumDistinctValues() {
        return this.numDistinctValues;
    }

    public void setNumDistinctValues(int numDistinctValues) {
        this.numDistinctValues = numDistinctValues;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(2000);
        buf.append("           Field Name: " + this.columnName + "\n");
        buf.append("            Table Catalog: " + this.tableCatalog + "\n");
        buf.append("            Table Schema: " + this.tableSchema + "\n");
        buf.append("            Table Name: " + this.tableName + "\n");
        buf.append("            Data Type: " + this.dataType + "\n");
        buf.append("            Data Type: " + this.dataTypeName + "\n");
        buf.append("            size: " + this.columnSize + "\n");
        buf.append("            Field Size: " + this.columnSize + "\n");
        buf.append("            Decimal Digits: " + this.decimalDigits + "\n");
        buf.append("            Radix Precision: " + this.numberPrecisionRadix + "\n");
        buf.append("            Nullable: " + this.nullable + "\n");
        buf.append("            Remarks: " + this.remarks + "\n");
        buf.append("            Default Value: " + this.defaultValue + "\n");
        buf.append("            Character Length: " + this.characterOctetLength + "\n");
        buf.append("            Ordinal Position: " + this.ordinalPosition + "\n");
        buf.append("            Is Nullable: " + this.isNullable + "\n");
        buf.append("            # distinct values: " + this.numDistinctValues + "\n");
        return buf.toString();
    }

    public String toStringField(int depth) {
        StringBuffer buf = new StringBuffer(2000);
        String spacing = StringFunc.spaces(depth);
        buf.append(String.valueOf(spacing) + " Field Name: " + this.columnName + "\n");
        buf.append(String.valueOf(spacing) + "  Table Schema: " + this.tableSchema + "\n");
        buf.append(String.valueOf(spacing) + "  Table Name: " + this.tableName + "\n");
        buf.append(String.valueOf(spacing) + "  Data Type: " + this.dataType + "\n");
        buf.append(String.valueOf(spacing) + "  Data Type: " + this.dataTypeName + "\n");
        buf.append(String.valueOf(spacing) + "  size: " + this.columnSize + "\n");
        buf.append(String.valueOf(spacing) + "  Field Size: " + this.columnSize + "\n");
        buf.append(String.valueOf(spacing) + "  Decimal Digits: " + this.decimalDigits + "\n");
        buf.append(String.valueOf(spacing) + "  Radix Precision: " + this.numberPrecisionRadix + "\n");
        buf.append(String.valueOf(spacing) + "  Remarks: " + this.remarks + "\n");
        buf.append(String.valueOf(spacing) + "  Default Value: " + this.defaultValue + "\n");
        buf.append(String.valueOf(spacing) + "  Character Length: " + this.characterOctetLength + "\n");
        buf.append(String.valueOf(spacing) + "  Ordinal Position: " + this.ordinalPosition + "\n");
        buf.append(String.valueOf(spacing) + "  Is Nullable: " + this.isNullable + "\n");
        buf.append(String.valueOf(spacing) + "  # distinct values: " + this.numDistinctValues + "\n");
        return buf.toString();
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(2000);
        buf.append("        <fieldName>" + this.columnName + "</fieldName>\n");
        buf.append("        <dataType>" + this.dataType + "</dataType>\n");
        buf.append("        <dataTypeName>" + CommonMethods.exportString(this.dataTypeName) + "</dataTypeName>\n");
        buf.append("        <fieldSize>" + this.columnSize + "</fieldSize>\n");
        buf.append("        <decimalDigits>" + this.decimalDigits + "</decimalDigits>\n");
        buf.append("        <numberRadixPrecision>" + this.numberPrecisionRadix + "</numberRadixPrecision>\n");
        buf.append("        <remarks>" + CommonMethods.exportString(this.remarks) + "</remarks>\n");
        buf.append("        <defaultValue>" + CommonMethods.exportString(this.defaultValue) + "</defaultValue>\n");
        buf.append("        <characterOctetLength>" + this.characterOctetLength + "</characterOctetLength>\n");
        buf.append("        <ordinalPosition>" + this.ordinalPosition + "</ordinalPosition>\n");
        buf.append("        <isNullable>" + this.isNullable + "</isNullable>\n");
        buf.append("        <numDistinctValues>" + this.numDistinctValues + "</numDistinctValues>");
        return buf.toString();
    }

    public String toXMLKey() {
        return "<fieldName>" + this.columnName + "</fieldName>";
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isBlob() {
        return this.dataType == 2004 || this.dataType == 2005 || this.dataType == -4 || this.dataType == -1;
    }
}

