/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.protocol;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.protocol.ProtocolManager;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolHandler<T>
implements ProtocolManager,
Runnable {
    private static XLogger logger = XLogger.getLogger(AbstractProtocolHandler.class);
    private List<SelectableChannel> toAdd = new LinkedList<SelectableChannel>();
    private List<SelectableChannel> toRemove = new LinkedList<SelectableChannel>();
    private Selector selector;
    private HashMap<SocketChannel, T> clients = new HashMap();
    private Executor serviceQueue;

    protected AbstractProtocolHandler() throws IOException {
        this.selector = Selector.open();
        this.serviceQueue = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    public synchronized void addClient(SocketChannel socketChannel) {
        this.clients.put(socketChannel, this.createClient());
        this.toAdd.add(socketChannel);
        this.selector.wakeup();
    }

    public synchronized void removeClient(SocketChannel socketChannel) {
        this.toRemove.add(socketChannel);
        T t = this.clients.remove(socketChannel);
        this.closeClient(t);
        this.selector.wakeup();
        logger.debug((Object)("connectedClients=" + this.clients.size()));
    }

    protected Iterator<T> clientIterator() {
        return this.clients.values().iterator();
    }

    protected abstract T createClient();

    protected abstract void closeClient(T var1);

    private synchronized void updateSelector() {
        try {
            for (SelectableChannel selectableChannel : this.toAdd) {
                selectableChannel.configureBlocking(false);
                SelectionKey selectionKey = selectableChannel.register(this.selector, 1);
                selectionKey.attach(new Long(System.currentTimeMillis()));
            }
            this.toAdd.clear();
            for (SelectableChannel selectableChannel : this.toRemove) {
                selectableChannel.close();
            }
            this.toRemove.clear();
            this.selector.selectNow();
        }
        catch (Exception exception) {
            XLogger.getLogger((String)"Server").error((Object)("error is " + exception.getMessage()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        AbstractProtocolHandler.logger.debug((Object)"DNG - protocol handler ready");
        var1_1 = null;
        block10: while (true) {
            try {
                block11: while (true) {
                    this.updateSelector();
                    this.selector.select();
                    var2_2 = this.selector.selectedKeys();
                    if (var2_2.size() > 0) {
                        for (SelectionKey var4_9 : var2_2) {
                            var4_9.attach(new Long(System.currentTimeMillis()));
                            if (!var4_9.isReadable()) continue;
                            var1_1 = (SocketChannel)var4_9.channel();
                            var5_11 = this.clients.get(var1_1);
                            if (var5_11 == null) {
                                AbstractProtocolHandler.logger.debug((Object)"in service - client ctx is null - return");
                                this.removeClient(var1_1);
                                return;
                            }
                            var6_12 = this.service(var1_1, var5_11);
                            if (var6_12 == null) continue;
                            this.serviceQueue.execute((Runnable)var6_12);
                        }
                        var2_2.clear();
                        if (Props.XDB_SELECTOR_SLEEP_NANO <= 0) continue;
                        try {
                            Thread.sleep(0L, Props.XDB_SELECTOR_SLEEP_NANO);
                            continue block10;
                        }
                        catch (InterruptedException var3_6) {
                            continue;
                        }
                    }
                    if (this.toAdd.size() > 0 || this.toRemove.size() > 0) continue;
                    var3_5 = this.selector.keys();
                    var4_10 = System.currentTimeMillis();
                    var6_12 = var3_5.iterator();
                    while (true) {
                        if (var6_12.hasNext()) ** break;
                        continue block11;
                        var7_13 = (SelectionKey)var6_12.next();
                        var8_14 = (Long)var7_13.attachment();
                        var9_15 = var4_10 - var8_14;
                        if (var9_15 <= 1000L) continue;
                        var1_1 = (SocketChannel)var7_13.channel();
                        var7_13.attach(var4_10);
                        this.testLink(var1_1);
                    }
                    break;
                }
            }
            catch (IOException var2_3) {}
            finally {
                try {
                    this.abortSession(var1_1);
                }
                catch (Throwable var3_7) {
                }
                continue;
            }
            break;
        }
    }

    protected abstract void testLink(SocketChannel var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortSession(SocketChannel socketChannel) throws IOException {
        try {
            this.removeClient(socketChannel);
        }
        finally {
            socketChannel.close();
        }
    }

    protected abstract Runnable service(SocketChannel var1, T var2);
}

