/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.OutputFormatter;
import com.edb.gridsql.util.LockUnlockTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class XdbImpEx {
    private String dbTable;
    private String dbDriverClass;
    private String jdbcUrl;
    private Statement dbStatement;
    private Connection dbConnection;
    static String sFieldSep;
    static String nullValue;
    static String sTerminator;
    private StringBuffer buffer = null;
    private String sImportFile;
    private String sExportFile;
    private String sErrorFile;
    private String sExtractQuery;
    private String formatFileName;
    private String sPosFormatted;
    private String quoted;
    private int startingLine = 1;
    private int endLine = 0;
    private int sMaxErrors = 1;
    private int sCommitInt = 0;
    private int notCommitted = 0;
    private int numErrors = 0;
    private int rowsProcessed = 0;
    private int notifyInterval = 0;
    private boolean overWrite = false;
    private boolean lock = false;
    private boolean silent = false;
    private boolean ignore = false;
    private boolean parallelMode = false;
    static boolean trimTrailingSpaces;
    private static String stmtTerminator;
    private String lockClass;
    private BufferedReader in = null;
    private OutputStream outStream = null;
    private BufferedWriter errorStream = null;
    private ColumnDef[] columns;
    private String baseInsert;
    static boolean hasTrailingDelimiter;

    public static void main(String[] stringArray) {
        new XdbImpEx(stringArray);
    }

    public XdbImpEx(String[] stringArray) {
        this.parseCommandLine(stringArray);
        if (this.notifyInterval == 0) {
            this.notifyInterval = this.sCommitInt;
        }
        if (this.notifyInterval == 0) {
            this.notifyInterval = 1000;
        }
        if (this.formatFileName != null) {
            try {
                this.loadFormatFile(new File(this.formatFileName));
            }
            catch (IOException iOException) {
                this.exitWithError(iOException.toString());
            }
        }
        this.checkInputParameters();
        this.instantiateDrivers();
        try {
            this.openConnections();
            if (this.sImportFile != null) {
                this.importData();
            } else if (this.sExportFile != null) {
                this.exportData();
            }
            this.closeConnections();
        }
        catch (SQLException sQLException) {
            this.exitWithError("SQL Error: " + sQLException.getMessage());
        }
    }

    private void parseCommandLine(String[] stringArray) {
        String string = "";
        String string2 = null;
        try {
            block32: for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                char c = string.charAt(1);
                switch (c) {
                    case 'P': 
                    case 'T': 
                    case 'a': 
                    case 'g': 
                    case 'h': 
                    case 'l': 
                    case 'w': {
                        break;
                    }
                    default: {
                        if (string.charAt(0) != '-') {
                            this.badArgs();
                        }
                        string2 = string.length() > 2 ? string.substring(2) : stringArray[++i];
                    }
                }
                switch (c) {
                    case 'a': {
                        hasTrailingDelimiter = true;
                        continue block32;
                    }
                    case 'b': {
                        this.lockClass = string2;
                        continue block32;
                    }
                    case 'c': {
                        this.sCommitInt = Integer.parseInt(string2);
                        continue block32;
                    }
                    case 'n': {
                        this.notifyInterval = Integer.parseInt(string2);
                        continue block32;
                    }
                    case 'd': {
                        sFieldSep = string2;
                        continue block32;
                    }
                    case 'e': {
                        this.endLine = Integer.parseInt(string2);
                        continue block32;
                    }
                    case 'f': {
                        this.formatFileName = string2;
                        continue block32;
                    }
                    case 'g': {
                        this.ignore = true;
                        continue block32;
                    }
                    case 'h': {
                        this.silent = true;
                        continue block32;
                    }
                    case 'i': {
                        this.sImportFile = string2;
                        continue block32;
                    }
                    case 'j': {
                        this.jdbcUrl = string2;
                        continue block32;
                    }
                    case 'l': {
                        this.lock = true;
                        continue block32;
                    }
                    case 'm': {
                        this.sMaxErrors = Integer.parseInt(string2);
                        continue block32;
                    }
                    case 'p': {
                        this.sPosFormatted = string2;
                        continue block32;
                    }
                    case 'q': {
                        this.quoted = string2;
                        continue block32;
                    }
                    case 'r': {
                        this.sErrorFile = string2;
                        continue block32;
                    }
                    case 's': {
                        this.startingLine = Integer.parseInt(string2);
                        continue block32;
                    }
                    case 't': {
                        this.dbTable = string2;
                        continue block32;
                    }
                    case 'w': {
                        this.overWrite = true;
                        continue block32;
                    }
                    case 'x': {
                        this.sExportFile = string2;
                        continue block32;
                    }
                    case 'y': {
                        this.sExtractQuery = string2;
                        continue block32;
                    }
                    case 'z': {
                        sTerminator = string2;
                        continue block32;
                    }
                    case 'C': {
                        this.dbDriverClass = string2;
                        continue block32;
                    }
                    case 'N': {
                        nullValue = string2;
                        continue block32;
                    }
                    case 'T': {
                        trimTrailingSpaces = true;
                        continue block32;
                    }
                    default: {
                        System.err.println("Poorly formed command line arguments.");
                        this.badArgs();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error processing command line arguments.");
            this.badArgs();
        }
    }

    private void checkInputParameters() {
        if (sFieldSep == null) {
            sFieldSep = "\t";
        }
        if (nullValue == null) {
            nullValue = "\\N";
        }
        if (this.dbDriverClass == null) {
            this.dbDriverClass = "com.edb.Driver";
        }
        if (this.dbTable == null && this.sExtractQuery == null) {
            System.err.println("Error: no database table specified");
            this.badArgs();
        }
        if (this.sImportFile != null && this.sExportFile != null) {
            System.err.println();
            System.err.println("import/ export operations are mutually exclusive");
            this.badArgs();
        }
        if (this.sExtractQuery != null && this.dbTable != null) {
            System.err.println();
            System.err.println("Extract query and table options are mutually exclusive ");
            this.badArgs();
        }
        if (this.lock && this.lockClass == null) {
            this.exitWithError("Error: Lock Class should be provided for  -lock option");
        }
    }

    private void badArgs() {
        System.err.println();
        System.err.println("\tUsage to Import: gs-bimpex -f formatFile -i importfile");
        System.err.println("\tUsage to Export: gs-impex -f formatFile -x exportfile");
        System.err.println();
        System.exit(1);
    }

    private void loadFormatFile(File file) throws IOException {
        int n;
        if (!file.exists()) {
            this.exitWithError("Format file does not exist");
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        if (this.dbDriverClass == null) {
            this.dbDriverClass = this.getPropertyTrim(properties, "DRIVERCLASS");
        }
        if (this.jdbcUrl == null) {
            this.jdbcUrl = this.getPropertyTrim(properties, "JDBC_URL");
        }
        if (this.sImportFile == null) {
            this.sImportFile = this.getPropertyTrim(properties, "INFILE");
        }
        if (this.dbTable == null) {
            this.dbTable = this.getPropertyTrim(properties, "TARGET");
        }
        if (this.sExportFile == null) {
            this.sExportFile = this.getPropertyTrim(properties, "OUTFILE");
        }
        if (this.sErrorFile == null) {
            this.sErrorFile = this.getPropertyTrim(properties, "DATA_ERROR_FILE");
        }
        if (this.quoted == null) {
            this.quoted = this.getPropertyTrim(properties, "QUOTED");
        }
        if (sFieldSep == null) {
            sFieldSep = this.getPropertyTrim(properties, "DELIMITER");
        }
        if (sTerminator == null) {
            sTerminator = this.getPropertyTrim(properties, "TERMINATOR");
        }
        if (this.sPosFormatted == null) {
            this.sPosFormatted = this.getPropertyTrim(properties, "POSITION_FORMATTED");
        }
        if (this.sExtractQuery == null) {
            this.sExtractQuery = this.getPropertyTrim(properties, "EXTRACT");
        }
        if (this.startingLine == 1 && this.getPropertyTrim(properties, "START_LINE") != null) {
            this.startingLine = Integer.parseInt(this.getPropertyTrim(properties, "START_LINE"));
        }
        if (this.endLine == 0 && this.getPropertyTrim(properties, "END_LINE") != null) {
            this.endLine = Integer.parseInt(this.getPropertyTrim(properties, "END_LINE"));
        }
        if (this.sMaxErrors == 1 && this.getPropertyTrim(properties, "MAX_ERRORS") != null) {
            this.sMaxErrors = Integer.parseInt(this.getPropertyTrim(properties, "MAX_ERRORS"));
        }
        if (this.sCommitInt <= 1 && this.getPropertyTrim(properties, "COMMIT_INTERVAL") != null) {
            this.sCommitInt = Integer.parseInt(this.getPropertyTrim(properties, "COMMIT_INTERVAL"));
        }
        if (this.getPropertyTrim(properties, "OVERWRITING") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "OVERWRITING"))) == 1) {
            this.overWrite = true;
        }
        if (this.getPropertyTrim(properties, "IGNORE") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "IGNORE"))) == 1) {
            this.ignore = true;
        }
        if (this.getPropertyTrim(properties, "SILENT") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "SILENT"))) == 1) {
            this.silent = true;
        }
        if (this.getPropertyTrim(properties, "TRIM_TRAILING_SPACES") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "TRIM_TRAILING_SPACES"))) == 1) {
            trimTrailingSpaces = true;
        }
        if (this.getPropertyTrim(properties, "ADDED_TRAILING_DELIMITER") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "ADDED_TRAILING_DELIMITER"))) == 1) {
            hasTrailingDelimiter = true;
        }
        if (this.getPropertyTrim(properties, "LOCK") != null && (n = Integer.parseInt(this.getPropertyTrim(properties, "LOCK"))) == 1) {
            this.lock = true;
        }
        if (this.lockClass == null) {
            this.lockClass = this.getPropertyTrim(properties, "LOCK_CLASS");
        }
    }

    private String getPropertyTrim(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private void instantiateDrivers() {
        try {
            Class.forName(this.dbDriverClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.exitWithError("Error: could not find the database driver class.");
        }
        catch (Exception exception) {
            this.exitWithError("Error: could not create the database driver class");
        }
    }

    private void openConnections() throws SQLException {
        this.dbConnection = DriverManager.getConnection(this.jdbcUrl);
        if (!this.parallelMode) {
            this.dbConnection.setAutoCommit(false);
        }
        this.dbStatement = this.dbConnection.createStatement();
        if (this.lock) {
            this.lockTable();
        }
        if (this.parallelMode) {
            this.dbStatement.execute("set asyncbatchmode=1");
        }
        if (this.jdbcUrl.indexOf("jdbc:xdb:") == 0) {
            Statement statement = this.dbConnection.createStatement();
            statement.execute("CREATE TEMP TABLE dummy0 (col1 int) on node 1");
        }
    }

    private void closeConnections() throws SQLException {
        if (this.lock) {
            this.unlockTable();
        }
        try {
            Statement statement = this.dbConnection.createStatement();
            statement.execute("DROP TABLE dummy0");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.dbStatement.close();
        this.dbConnection.close();
    }

    private void lockTable() {
        try {
            Class<?> clazz = Class.forName(this.lockClass);
            Object obj = clazz.newInstance();
            LockUnlockTable lockUnlockTable = (LockUnlockTable)obj;
            String string = lockUnlockTable.getLockString(this.dbTable);
            this.dbStatement.execute(string);
        }
        catch (Exception exception) {
            this.exitWithError(exception.getMessage());
        }
    }

    private void unlockTable() {
        try {
            Class<?> clazz = Class.forName(this.lockClass);
            Object obj = clazz.newInstance();
            LockUnlockTable lockUnlockTable = (LockUnlockTable)obj;
            String string = lockUnlockTable.getUnlockString(this.dbTable);
            this.dbStatement.execute(string);
        }
        catch (InstantiationException instantiationException) {
            this.exitWithError(instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.exitWithError(classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            this.exitWithError(exception.getMessage());
        }
    }

    private void importData() {
        this.baseInsert = null;
        if (sTerminator == null) {
            sTerminator = "\n";
        }
        String string = null;
        int n = 0;
        this.rowsProcessed = 0;
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        if (this.startingLine > this.endLine && this.endLine != 0) {
            this.exitWithError("END_LINE option has smaller value than the START_LINE option");
        }
        try {
            int n2;
            String[] stringArray;
            System.err.println("Loading: " + this.sImportFile);
            this.processResultSet();
            if (this.sImportFile == null || this.sImportFile.length() == 0) {
                this.in = new BufferedReader(new InputStreamReader(System.in));
            } else {
                stringArray = new File(this.sImportFile);
                if (!stringArray.exists()) {
                    this.exitWithError("Data Import File does not exist...");
                }
                this.in = new BufferedReader(new FileReader(this.sImportFile));
            }
            if (this.sErrorFile == null) {
                this.sErrorFile = "data_error_file";
            }
            this.errorStream = new BufferedWriter(new FileWriter(this.sErrorFile));
            if (this.startingLine > 1) {
                for (int i = 1; i < this.startingLine && (string = this.readLine()) != null; ++i) {
                    ++n;
                }
                if (n + 1 < this.startingLine) {
                    this.exitWithError("Number of data lines in the import file less than the -s option given");
                }
            }
            string = this.readLine();
            stringArray = new String[this.columns.length];
            String[] stringArray2 = new String[this.columns.length];
            if (this.sPosFormatted == null) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = this.columns[n2].columnName;
                }
            } else {
                n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(this.sPosFormatted, ",");
                stringArray = new String[stringTokenizer.countTokens()];
                stringArray2 = new String[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken(",");
                    string2 = string2.trim();
                    int n3 = string2.indexOf(" ", 0);
                    stringArray[n2++] = string2.substring(0, n3);
                }
            }
            this.notCommitted = 0;
            String[] stringArray3 = null;
            if (this.sCommitInt > 0) {
                if (!this.parallelMode) {
                    this.dbConnection.setAutoCommit(false);
                }
                stringArray3 = new String[this.sCommitInt];
            }
            int n4 = 0;
            while (string != null && (this.endLine <= 0 || ++n <= this.endLine)) {
                block85: {
                    Object object;
                    int n5;
                    int n6;
                    int n7 = this.getFieldCounts(string);
                    if (n7 != this.columns.length) {
                        ++this.numErrors;
                        this.errorStream.write(string);
                        this.errorStream.write(sTerminator);
                        this.errorStream.flush();
                        System.err.print("Data file " + this.sImportFile + ": Error at line #" + n);
                        System.err.println("\t Column Mismatch");
                        System.err.println("delimCount = " + n7 + "; numCols = " + this.columns.length);
                        if (this.sMaxErrors != 0 && this.numErrors >= this.sMaxErrors) break;
                        string = this.readLine();
                        continue;
                    }
                    for (n6 = 0; n6 < stringArray2.length; ++n6) {
                        stringArray2[n6] = null;
                    }
                    try {
                        if (this.sPosFormatted == null) {
                            n6 = 0;
                            n5 = 0;
                            for (int i = 0; i < stringArray2.length - 1; ++i) {
                                n5 = string.indexOf(sFieldSep, n6);
                                stringArray2[i] = string.substring(n6, n5);
                                if (stringArray2[i].equals(nullValue)) {
                                    stringArray2[i] = null;
                                }
                                n6 = n5 + 1;
                            }
                            object = string.substring(string.lastIndexOf(sFieldSep));
                            object = ((String)object).length() > 1 ? ((String)object).substring(1) : "";
                            stringArray2[stringArray2.length - 1] = object;
                            if (stringArray2[stringArray2.length - 1].equals(nullValue)) {
                                stringArray2[stringArray2.length - 1] = null;
                            }
                        } else {
                            for (n6 = 0; n6 < stringArray2.length; ++n6) {
                                int n8 = this.sPosFormatted.indexOf(stringArray[n6]);
                                if (n8 != -1) {
                                    stringArray2[n6] = this.getColumnData(string, n8);
                                    continue;
                                }
                                this.exitWithError("Error reading columns");
                            }
                        }
                    }
                    catch (Exception exception) {
                        ++this.numErrors;
                        this.errorStream.write(string);
                        this.errorStream.write(sTerminator);
                        this.errorStream.flush();
                        System.err.println("Data file " + this.sImportFile + ": Error at line #" + n);
                        if (this.sMaxErrors != 0 && this.numErrors >= this.sMaxErrors) {
                            System.err.println(exception.getMessage());
                            exception.printStackTrace();
                            break;
                        }
                        string = this.readLine();
                        continue;
                    }
                    if (this.baseInsert == null) {
                        this.baseInsert = "INSERT INTO \"" + this.dbTable + "\" (";
                        for (n6 = 0; n6 < stringArray.length - 1; ++n6) {
                            this.baseInsert = this.baseInsert + "\"" + stringArray[n6] + "\", ";
                        }
                        this.baseInsert = this.baseInsert + "\"" + stringArray[stringArray.length - 1] + "\") ";
                        this.baseInsert = this.baseInsert + " VALUES (";
                        if (this.sCommitInt > 0) {
                            this.dbStatement.addBatch("TEMPLATE_START:" + this.baseInsert);
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n5 = 0; n5 < stringArray2.length - 1; ++n5) {
                        if (stringArray2[n5] == null) {
                            stringBuffer.append("null");
                        } else if (this.quoteDataType(this.columns[n5].columnSQLType)) {
                            stringBuffer.append(this.quote(stringArray2[n5]));
                        } else {
                            stringBuffer.append(stringArray2[n5]);
                        }
                        stringBuffer.append(", ");
                    }
                    if (this.quoteDataType(this.columns[stringArray2.length - 1].columnSQLType)) {
                        stringBuffer.append(this.quote(stringArray2[stringArray2.length - 1]));
                    } else if (stringArray2[stringArray2.length - 1].length() == 0) {
                        stringBuffer.append("null");
                    } else {
                        stringBuffer.append(stringArray2[stringArray2.length - 1]);
                    }
                    stringBuffer.append(")");
                    stringBuffer.append(stmtTerminator);
                    String string3 = stringBuffer.toString();
                    try {
                        if (this.sCommitInt > 0) {
                            this.dbStatement.addBatch(string3);
                            stringArray3[n4++] = string;
                        } else {
                            this.dbStatement.execute(this.baseInsert + string3);
                        }
                        ++this.rowsProcessed;
                        ++this.notCommitted;
                        if (n % this.notifyInterval == 0 && !this.silent) {
                            System.err.println("Number of lines read so far :" + n);
                        }
                        if (this.notCommitted == this.sCommitInt) {
                            n4 = 0;
                            if (!this.parallelMode) {
                                object = this.dbStatement.executeBatch();
                                this.processUpdateCounts((int[])object, stringArray3);
                            } else {
                                linkedList.add(stringArray3);
                                stringArray3 = new String[this.sCommitInt];
                                object = this.dbStatement.executeBatch();
                                this.processUpdateCounts((int[])object, linkedList);
                            }
                        }
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        if (!this.parallelMode) {
                            this.processUpdateCounts(batchUpdateException.getUpdateCounts(), stringArray3);
                        } else {
                            stringArray3 = new String[this.sCommitInt];
                            this.processUpdateCounts(batchUpdateException.getUpdateCounts(), linkedList);
                        }
                    }
                    catch (SQLException sQLException) {
                        Object object2;
                        if (!this.ignore) {
                            if (!this.overWrite) {
                                ++this.numErrors;
                                this.errorStream.write(string);
                                this.errorStream.write(sTerminator);
                                this.errorStream.flush();
                                System.err.println("Data file " + this.sImportFile + ": Error at line #" + n);
                                System.err.println(sQLException.getMessage());
                                sQLException.printStackTrace();
                                if (this.sMaxErrors != 0 && this.numErrors >= this.sMaxErrors) {
                                    break;
                                }
                            } else {
                                string3 = "UPDATE " + this.dbTable;
                                string3 = string3 + " SET ";
                                for (int i = 0; i < stringArray.length - 1; ++i) {
                                    string3 = this.quoteDataType(this.columns[i].columnSQLType) ? string3 + stringArray[i] + "=" + this.quote(stringArray2[i]) + "," : string3 + stringArray[i] + "=" + stringArray2[i] + ",";
                                }
                                object2 = this.getPrimaryKey();
                                string3 = this.quoteDataType(this.columns[stringArray.length - 1].columnSQLType) ? string3 + stringArray[stringArray.length - 1] + "=" + this.quote(stringArray2[stringArray.length - 1]) : string3 + stringArray[stringArray.length - 1] + "=" + stringArray2[stringArray.length - 1];
                                string3 = string3 + " WHERE " + (String)object2 + "=";
                                try {
                                    int n9;
                                    for (n9 = 0; n9 < stringArray.length && !((String)object2).equals(stringArray[n9]); ++n9) {
                                    }
                                    string3 = string3 + stringArray2[n9] + stmtTerminator;
                                    System.err.println(string3);
                                    if (this.sCommitInt > 0) {
                                        this.dbStatement.addBatch(string3);
                                    } else {
                                        this.dbStatement.execute(string3);
                                    }
                                    ++this.rowsProcessed;
                                }
                                catch (Exception exception) {
                                    ++this.numErrors;
                                    this.errorStream.write(string);
                                    this.errorStream.write(sTerminator);
                                    this.errorStream.flush();
                                    System.err.println("Data file " + this.sImportFile + ": Error at line #" + n);
                                    System.err.println(sQLException.getMessage());
                                    sQLException.printStackTrace();
                                    if (this.sMaxErrors != 0 && this.numErrors >= this.sMaxErrors) break;
                                }
                            }
                        }
                        ++this.notCommitted;
                        if (this.notCommitted == this.sCommitInt) {
                            try {
                                if (!this.parallelMode) {
                                    object2 = this.dbStatement.executeBatch();
                                    this.processUpdateCounts((int[])object2, stringArray3);
                                } else {
                                    linkedList.add(stringArray3);
                                    stringArray3 = new String[this.sCommitInt];
                                    object2 = this.dbStatement.executeBatch();
                                    this.processUpdateCounts((int[])object2, linkedList);
                                }
                            }
                            catch (BatchUpdateException batchUpdateException) {
                                if (!this.parallelMode) {
                                    this.processUpdateCounts(batchUpdateException.getUpdateCounts(), stringArray3);
                                } else {
                                    stringArray3 = new String[this.sCommitInt];
                                    this.processUpdateCounts(batchUpdateException.getUpdateCounts(), linkedList);
                                }
                            }
                            catch (Exception exception) {
                                System.err.println(sQLException.getMessage());
                            }
                        }
                        if (n % this.notifyInterval != 0 || this.silent) break block85;
                        System.err.println("Number of rows loaded so far :" + n);
                    }
                }
                string = this.readLine();
            }
            if (this.notCommitted > 0 && this.sCommitInt > 0) {
                try {
                    int[] nArray;
                    if (!this.parallelMode) {
                        nArray = this.dbStatement.executeBatch();
                        this.processUpdateCounts(nArray, stringArray3);
                    } else {
                        linkedList.add(stringArray3);
                        stringArray3 = new String[this.sCommitInt];
                        nArray = this.dbStatement.executeBatch();
                        this.processUpdateCounts(nArray, linkedList);
                    }
                }
                catch (BatchUpdateException batchUpdateException) {
                    if (!this.parallelMode) {
                        this.processUpdateCounts(batchUpdateException.getUpdateCounts(), stringArray3);
                    } else {
                        stringArray3 = new String[this.sCommitInt];
                        this.processUpdateCounts(batchUpdateException.getUpdateCounts(), linkedList);
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            while (this.parallelMode && !linkedList.isEmpty()) {
                try {
                    int[] nArray = this.dbStatement.executeBatch();
                    if (nArray == null) break;
                    this.processUpdateCounts(nArray, linkedList);
                }
                catch (BatchUpdateException batchUpdateException) {
                    this.processUpdateCounts(batchUpdateException.getUpdateCounts(), linkedList);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            System.err.println("Total number of rows loaded :" + this.rowsProcessed);
            if (this.numErrors > 0) {
                System.err.println("# errors encountered=" + this.numErrors + ". Maximum #errors allowed=" + this.sMaxErrors + ".");
            }
            this.in.close();
            this.errorStream.close();
        }
        catch (Exception exception) {
            System.err.println("Data file " + this.sImportFile + ": Error at line #" + n);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private int getFieldCounts(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (string != null && n < string.length() && (n3 = string.indexOf(sFieldSep, n)) >= 0) {
            ++n2;
            n = n3 + 1;
        }
        return hasTrailingDelimiter ? n2 : n2 + 1;
    }

    private String readLine() {
        String string = null;
        this.buffer = new StringBuffer();
        try {
            int n;
            while ((n = this.in.read()) != -1 && (char)n != sTerminator.charAt(0)) {
                this.buffer.append((char)n);
            }
            string = this.buffer.length() > 0 ? this.buffer.toString() : null;
        }
        catch (Exception exception) {
            System.err.println("Could not read from file: " + this.sImportFile);
            System.exit(1);
        }
        return string;
    }

    private void processUpdateCounts(int[] nArray, String[] stringArray) throws SQLException {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -3) continue;
                --this.rowsProcessed;
                ++this.numErrors;
                this.errorStream.write(stringArray[i]);
                this.errorStream.write(sTerminator);
                this.errorStream.flush();
                System.err.println("Data file " + this.sImportFile + ":Error during batch update :" + stringArray[i]);
            }
            this.dbConnection.commit();
        }
        catch (Exception exception) {
            System.err.println("Error while writing to error stream");
        }
        this.notCommitted = 0;
        stringArray = new String[this.sCommitInt];
        this.dbStatement.addBatch("TEMPLATE_START:" + this.baseInsert);
    }

    private void processUpdateCounts(int[] nArray, LinkedList linkedList) {
        try {
            if (nArray != null && nArray.length > 0) {
                String[] stringArray = (String[])linkedList.removeFirst();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != -3) continue;
                    --this.rowsProcessed;
                    ++this.numErrors;
                    this.errorStream.write(stringArray[i]);
                    this.errorStream.write(sTerminator);
                    this.errorStream.flush();
                    System.err.println("Data file " + this.sImportFile + ":Error during batch update :" + stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error while writing to error stream");
        }
        this.notCommitted = 0;
    }

    private boolean quoteDataType(int n) {
        boolean bl;
        switch (n) {
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultSet() throws SQLException {
        ResultSet resultSet = this.dbConnection.getMetaData().getColumns(this.dbConnection.getCatalog(), "%", this.dbTable, "%");
        try {
            ArrayList<ColumnDef> arrayList = new ArrayList<ColumnDef>();
            while (resultSet.next()) {
                arrayList.add(new ColumnDef(resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE")));
            }
            this.columns = arrayList.toArray(new ColumnDef[arrayList.size()]);
        }
        finally {
            resultSet.close();
        }
    }

    private String getColumnData(String string, int n) {
        int n2 = this.sPosFormatted.indexOf(" ", n);
        n2 = XdbImpEx.skipWhiteSpaces(n2, this.sPosFormatted);
        int n3 = this.sPosFormatted.indexOf(":", n2);
        String string2 = this.sPosFormatted.substring(n2 + 1, n3);
        int n4 = this.sPosFormatted.indexOf(",", n3);
        String string3 = null;
        string3 = n4 < 0 ? this.sPosFormatted.substring(n3 + 1, this.sPosFormatted.length()) : this.sPosFormatted.substring(n3 + 1, this.sPosFormatted.indexOf(",", n3));
        int n5 = Integer.parseInt(string2);
        int n6 = Integer.parseInt(string3);
        return string.substring(n5 - 1, n6);
    }

    public static int skipWhiteSpaces(int n, String string) {
        char[] cArray = string.toCharArray();
        while (cArray[n + 1] == ' ') {
            ++n;
        }
        return n;
    }

    private String quote(String string) {
        if (this.quoted == null && string != null) {
            return "'" + string + "'";
        }
        return string;
    }

    private void exportData() {
        if (sTerminator == null) {
            sTerminator = "\n";
        }
        try {
            String string;
            StringTokenizer stringTokenizer = null;
            if (this.sExtractQuery != null) {
                stringTokenizer = new StringTokenizer(this.sExtractQuery);
                if (stringTokenizer.countTokens() == 1) {
                    this.dbTable = stringTokenizer.nextToken();
                    string = "SELECT * FROM \"" + this.dbTable + "\"" + stmtTerminator;
                } else {
                    string = this.sExtractQuery;
                }
            } else {
                string = "SELECT * FROM \"" + this.dbTable + "\"" + stmtTerminator;
            }
            if (this.sCommitInt > 0) {
                this.dbStatement.setFetchSize(this.sCommitInt);
            }
            ResultSet resultSet = this.dbStatement.executeQuery(string);
            this.outStream = this.sExportFile == null || this.sExportFile.length() == 0 ? System.out : new FileOutputStream(this.sExportFile);
            OutputFormatter outputFormatter = new OutputFormatter(this.sPosFormatted);
            outputFormatter.setHasTrailingDelimiter(hasTrailingDelimiter);
            outputFormatter.setTrimTrailingSpaces(trimTrailingSpaces);
            outputFormatter.setSFieldSep(sFieldSep);
            outputFormatter.setNullValue(nullValue);
            outputFormatter.setSTerminator(sTerminator);
            outputFormatter.setQuoteInfo(this.quoted, null, null);
            long l = outputFormatter.printRS(resultSet, this.outStream);
            System.err.println("Total number of rows processed :" + l);
            this.outStream.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getPrimaryKey() {
        String string = null;
        try {
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, this.dbTable);
            while (resultSet.next()) {
                string = resultSet.getString(6);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Error finding the  primary key ");
        }
        return string;
    }

    private void exitWithError(String string) {
        System.err.println(string);
        System.exit(1);
    }

    static {
        trimTrailingSpaces = false;
        stmtTerminator = "";
        hasTrailingDelimiter = false;
    }

    private class ColumnDef {
        private String columnName;
        private int columnSQLType;

        private ColumnDef(String string, int n) {
            this.columnName = string;
            this.columnSQLType = n;
        }
    }
}

