/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.engine.io.MessageTypes;
import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.PasswordPrompt;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util
implements MessageTypes {
    private static final int SAMPLE_SIZE = 100;

    private static void padPrint(PrintWriter printWriter, String string, int n, String string2, int n2) {
        int n3 = n - string.length();
        while (n2 == 1 && n3-- > 0) {
            printWriter.print(" ");
        }
        int n4 = 0;
        if (n3 > 0 && n2 == 3) {
            int n5 = n3 / 2;
            if (n5 == 0) {
                n5 = 1;
            }
            n4 = n3 - n5;
            while (n5-- > 0) {
                printWriter.print(" ");
            }
        }
        printWriter.print(" ");
        printWriter.print(string);
        while (n2 == 2 && n3-- > 0) {
            printWriter.print(" ");
        }
        while (n2 == 3 && n4-- > 0) {
            printWriter.print(" ");
        }
        printWriter.print(" ");
        printWriter.print(string2);
    }

    private static void printTableLine(PrintWriter printWriter, int n, String string) {
        printWriter.print("+");
        while (n-- > 0) {
            printWriter.print("-");
        }
        printWriter.println("+");
    }

    public static void dumpRsTable(ResultSet resultSet, PrintWriter printWriter, String string) throws SQLException {
        Object object;
        int n;
        int n2;
        Object object2;
        if (!resultSet.next()) {
            printWriter.println("no rows to display");
            printWriter.flush();
            return;
        }
        int n3 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        ArrayList arrayList = new ArrayList(100);
        int[] nArray = new int[n4];
        int n5 = 0;
        String string2 = null;
        do {
            object2 = new ArrayList(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                String string3 = resultSet.getString(n2 + 1);
                string2 = string3 == null ? "" : string3.toString();
                nArray[n2] = Math.max(nArray[n2], string2.length());
                ((ArrayList)object2).add(string2);
            }
            arrayList.add(object2);
        } while (++n5 < 100 && resultSet.next());
        object2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            object2[n2] = resultSetMetaData.getColumnType(n2 + 1);
            nArray[n2] = Math.max(nArray[n2], resultSetMetaData.getColumnLabel(n2 + 1).length());
            n3 += nArray[n2] + 2;
        }
        Util.printTableLine(printWriter, n3 += n4 - 1, string);
        printWriter.print(string);
        for (n2 = 0; n2 < n4; ++n2) {
            Util.padPrint(printWriter, resultSetMetaData.getColumnLabel(n2 + 1), nArray[n2], string, 3);
        }
        printWriter.println();
        Util.printTableLine(printWriter, n3, string);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            printWriter.print(string);
            object = (List)arrayList.get(n);
            for (int i = 0; i < n4; ++i) {
                Util.padPrint(printWriter, (String)object.get(i), nArray[i], string, DataTypes.isNumeric((int)object2[i]) ? 1 : 2);
            }
            printWriter.println();
        }
        printWriter.flush();
        while (resultSet.next()) {
            printWriter.print(string);
            for (n = 0; n < n4; ++n) {
                object = resultSet.getString(n + 1);
                Util.padPrint(printWriter, object == null ? "" : ((String)object).toString(), nArray[n], string, DataTypes.isNumeric((int)object2[n]) ? 1 : 2);
            }
            printWriter.println();
            printWriter.flush();
            ++n2;
        }
        Util.printTableLine(printWriter, n3, string);
        printWriter.println(n2 + " row(s).");
        printWriter.flush();
    }

    public static void dumpRs(ResultSet resultSet, PrintWriter printWriter, String string, boolean bl) throws SQLException {
        int n;
        if (!resultSet.next()) {
            printWriter.println("no rows to display");
            printWriter.flush();
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n + 1);
            printWriter.print(resultSetMetaData.getColumnLabel(n + 1).toUpperCase() + string);
        }
        printWriter.println();
        n = 0;
        do {
            for (int i = 0; i < n2; ++i) {
                String string2 = resultSet.getString(i + 1);
                printWriter.print(string2 == null ? "null" : string2.toString().trim());
                if (!bl && i >= n2 - 1) continue;
                printWriter.print(string);
            }
            printWriter.println();
            printWriter.flush();
            ++n;
        } while (resultSet.next());
        printWriter.println(n + " rows dumped");
        printWriter.flush();
    }

    public static Connection connect(Map<String, List<String>> map) throws SQLException {
        return Util.connect(map, false);
    }

    public static Connection connect(Map<String, List<String>> map, boolean bl) throws SQLException {
        String string = "localhost";
        int n = 6453;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Connection connection = null;
        String string5 = ParseArgs.getStrArg(map, "j");
        if (string5 == null) {
            String string6 = ParseArgs.getStrArg(map, "h");
            if (string6 != null) {
                string = string6;
            }
            if ((string6 = ParseArgs.getStrArg(map, "s")) != null) {
                try {
                    n = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl && (string2 = ParseArgs.getStrArg(map, "d")) == null) {
                System.out.println("Please, specify database");
                throw new SQLException("Database name is not specified");
            }
            string3 = ParseArgs.getStrArg(map, "u");
            if (string3 == null) {
                System.out.println("Please, specify user name");
                throw new SQLException("User name is not specified");
            }
            string4 = ParseArgs.getStrArg(map, "p");
            string5 = "jdbc:edb://" + string + ":" + n + "/" + (bl ? Props.XDB_ADMIN_DATABASE : string2);
        }
        try {
            Class.forName("com.edb.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("JDBC driver is not available");
        }
        if (string3 == null) {
            connection = DriverManager.getConnection(string5);
        } else if (string4 == null) {
            for (int i = 0; i < 3; ++i) {
                try {
                    try {
                        string4 = PasswordPrompt.getPassword("password: ");
                    }
                    catch (IOException iOException) {
                        throw new SQLException("Can not get password: " + iOException.getMessage());
                    }
                    connection = DriverManager.getConnection(string5, string3, string4);
                    break;
                }
                catch (SQLException sQLException) {
                    if ("Invalid login".equals(sQLException.getMessage())) continue;
                    throw sQLException;
                }
            }
        } else {
            connection = DriverManager.getConnection(string5, string3, string4);
        }
        if (connection == null) {
            throw new SQLException("Can not connect to server");
        }
        return connection;
    }
}

