/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.Encoding;
import com.edb.core.PGBindException;
import com.edb.core.VisibleBufferedInputStream;
import com.edb.core.charset.nsDetector;
import com.edb.core.charset.nsICharsetDetectionObserver;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.Socket;
import java.sql.SQLException;

public class PGStream {
    private final String host;
    private final int port;
    private final byte[] _int4buf;
    private final byte[] _int2buf;
    private Socket connection;
    private VisibleBufferedInputStream pg_input;
    private OutputStream pg_output;
    private byte[] streamBuffer;
    private Encoding encoding;
    private Writer encodingWriter;
    private Encoding messageEncoding = null;
    private boolean detectMessageEncoding = false;

    public PGStream(String host, int port, boolean detectMessageEncoding, String srvmsgEncoding) throws IOException {
        this.host = host;
        this.port = port;
        this.detectMessageEncoding = detectMessageEncoding;
        this.changeSocket(new Socket(host, port));
        this.setEncoding(Encoding.getJVMEncoding("UTF8"));
        if (srvmsgEncoding != null) {
            this.messageEncoding = Encoding.getJVMEncoding(srvmsgEncoding);
        }
        this._int2buf = new byte[2];
        this._int4buf = new byte[4];
    }

    public PGStream(String host, int port) throws IOException {
        this(host, port, false, null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.pg_input = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.pg_output){

            public void flush() throws IOException {
            }

            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void SendChar(int val) throws IOException {
        this.pg_output.write(val);
    }

    public void SendInteger4(int val) throws IOException {
        this._int4buf[0] = (byte)(val >>> 24);
        this._int4buf[1] = (byte)(val >>> 16);
        this._int4buf[2] = (byte)(val >>> 8);
        this._int4buf[3] = (byte)val;
        this.pg_output.write(this._int4buf);
    }

    public void SendInteger2(int val) throws IOException {
        if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + val);
        }
        this._int2buf[0] = (byte)(val >>> 8);
        this._int2buf[1] = (byte)val;
        this.pg_output.write(this._int2buf);
    }

    public void Send(byte[] buf) throws IOException {
        this.pg_output.write(buf);
    }

    public void Send(byte[] buf, int siz) throws IOException {
        this.Send(buf, 0, siz);
    }

    public void Send(byte[] buf, int off, int siz) throws IOException {
        int bufamt = buf.length - off;
        this.pg_output.write(buf, off, bufamt < siz ? bufamt : siz);
        for (int i = bufamt; i < siz; ++i) {
            this.pg_output.write(0);
        }
    }

    public int ReceiveChar() throws IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int ReceiveInteger4() throws IOException {
        if (this.pg_input.read(this._int4buf) != 4) {
            throw new EOFException();
        }
        return (this._int4buf[0] & 0xFF) << 24 | (this._int4buf[1] & 0xFF) << 16 | (this._int4buf[2] & 0xFF) << 8 | this._int4buf[3] & 0xFF;
    }

    public int ReceiveInteger2() throws IOException {
        if (this.pg_input.read(this._int2buf) != 2) {
            throw new EOFException();
        }
        return (this._int2buf[0] & 0xFF) << 8 | this._int2buf[1] & 0xFF;
    }

    public String ReceiveErrorString(int len) throws IOException {
        if (!this.pg_input.ensureBytes(len)) {
            throw new EOFException();
        }
        Encoding enc = this.encoding;
        byte[] b = new byte[len];
        System.arraycopy(this.pg_input.getBuffer(), 0, b, 0, len);
        if (this.detectMessageEncoding) {
            enc = this.detectDecoding(b);
        } else if (this.messageEncoding != null) {
            enc = this.messageEncoding;
        }
        String res = enc.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
        this.pg_input.skip(len);
        return res;
    }

    public String ReceiveString(int len) throws IOException {
        if (!this.pg_input.ensureBytes(len)) {
            throw new EOFException();
        }
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
        this.pg_input.skip(len);
        return res;
    }

    public String ReceiveString() throws IOException {
        int len = this.pg_input.scanCStringLength();
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len - 1);
        this.pg_input.skip(len);
        return res;
    }

    public byte[][] ReceiveTupleV3() throws IOException, OutOfMemoryError {
        int l_msgSize = this.ReceiveInteger4();
        int l_nf = this.ReceiveInteger2();
        byte[][] answer = new byte[l_nf][];
        OutOfMemoryError oom = null;
        for (int i = 0; i < l_nf; ++i) {
            int l_size = this.ReceiveInteger4();
            if (l_size == -1) continue;
            try {
                answer[i] = new byte[l_size];
                this.Receive(answer[i], 0, l_size);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.Skip(l_size);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[][] ReceiveTupleV2(int nf, boolean bin) throws IOException, OutOfMemoryError {
        int bim = (nf + 7) / 8;
        byte[] bitmask = this.Receive(bim);
        byte[][] answer = new byte[nf][];
        int whichbit = 128;
        int whichbyte = 0;
        OutOfMemoryError oom = null;
        for (int i = 0; i < nf; ++i) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if ((whichbit >>= 1) == 0) {
                ++whichbyte;
                whichbit = 128;
            }
            if (isNull) continue;
            int len = this.ReceiveInteger4();
            if (!bin) {
                len -= 4;
            }
            if (len < 0) {
                len = 0;
            }
            try {
                answer[i] = new byte[len];
                this.Receive(answer[i], 0, len);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.Skip(len);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[] Receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.Receive(answer, 0, siz);
        return answer;
    }

    public void Receive(byte[] buf, int off, int siz) throws IOException {
        int w;
        for (int s = 0; s < siz; s += w) {
            w = this.pg_input.read(buf, off + s, siz - s);
            if (w >= 0) continue;
            throw new EOFException();
        }
    }

    public void Skip(int size) throws IOException {
        for (long s = 0L; s < (long)size; s += this.pg_input.skip((long)size - s)) {
        }
    }

    public void SendStream(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            int readCount;
            int count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
            try {
                readCount = inStream.read(this.streamBuffer, 0, count);
                if (readCount < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", new Object[]{new Integer(expectedLength), new Integer(expectedLength - remaining)}));
                }
            }
            catch (IOException ioe) {
                while (remaining > 0) {
                    this.Send(this.streamBuffer, count);
                    count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                }
                throw new PGBindException(ioe);
            }
            this.Send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pg_output.flush();
    }

    public void ReceiveEOF() throws SQLException, IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            return;
        }
        throw new PSQLException(GT.tr("Expected an EOF from server, got: {0}", new Integer(c)), PSQLState.COMMUNICATION_ERROR);
    }

    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }

    private Encoding detectDecoding(byte[] b) {
        if (b == null || b.length == 0) {
            return this.encoding;
        }
        if (this.isBig5(b)) {
            return Encoding.getJVMEncoding("BIG5");
        }
        return this.encoding;
    }

    private boolean isBig5(byte[] b) {
        final nsDetector det = new nsDetector();
        final StringBuffer charSet = new StringBuffer();
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                det.Done();
                charSet.append(charset);
            }
        });
        boolean isAscii = det.isAscii(b, b.length);
        if (!isAscii) {
            det.DoIt(b, b.length, false);
        }
        det.DataEnd();
        if (isAscii) {
            return false;
        }
        return charSet.toString().equalsIgnoreCase("BIG5");
    }
}

