/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.constraintchecker.UpdateForeignKeyChecker;
import com.edb.gridsql.constraintchecker.UpdateForeignReferenceChecker;
import com.edb.gridsql.constraintchecker.UpdatePrimaryKeyChecker;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.misc.RSHelper;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.Lexer;
import com.edb.gridsql.parser.ParserHelper;
import com.edb.gridsql.parser.SqlModifyTable;
import com.edb.gridsql.parser.core.syntaxtree.SetUpdateClause;
import com.edb.gridsql.parser.core.syntaxtree.UpdateTable;
import com.edb.gridsql.parser.core.syntaxtree.WhereClause;
import com.edb.gridsql.parser.core.visitor.ObjectVisitor;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.SQLExpressionHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUpdateTable
extends SqlModifyTable {
    private static final XLogger logger = XLogger.getLogger(SqlUpdateTable.class);
    private Map<String, SqlExpression> setClause = new LinkedHashMap<String, SqlExpression>();
    private QueryCondition filterCondition;
    private QueryTree aQueryTree;
    private Collection<SysColumn> sysColumnList;
    private Collection<SysColumn> modifiedColumnList;
    private int maxSuppliedSerial = -1;
    private boolean doRowMove;

    public SqlUpdateTable(XDBSessionContext xDBSessionContext) {
        super(xDBSessionContext);
        this.commandToExecute = new Command(2, this, new QueryTreeTracker(), xDBSessionContext);
        this.aQueryTree = new QueryTree();
    }

    @Override
    public Object visit(UpdateTable updateTable, Object object) {
        Object var3_3 = null;
        QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
        queryTreeTracker.registerTree(this.aQueryTree);
        RelationNode relationNode = this.aQueryTree.newRelationNode();
        relationNode.setNodeType(2);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        updateTable.f1.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        relationNode.setTableName(tableNameHandler.getTableName());
        relationNode.setTemporaryTable(tableNameHandler.isTemporary());
        relationNode.setClient(this.commandToExecute.getClientContext());
        relationNode.setAlias(tableNameHandler.getReferenceName());
        updateTable.f3.accept(this, object);
        updateTable.f4.accept(this, object);
        updateTable.f5.accept(this, object);
        QueryTreeHandler.checkAndExpand(this.aQueryTree.getProjectionList(), this.aQueryTree.getRelationNodeList(), this.database, this.commandToExecute);
        for (SqlExpression sqlExpression : this.setClause.values()) {
            QueryTreeHandler.SetBelongsToTree(sqlExpression, this.aQueryTree);
        }
        List<SqlExpression> list = QueryTreeHandler.checkAndFillTableNames(this.aQueryTree.getProjectionList(), this.aQueryTree.getRelationNodeList(), new ArrayList<SqlExpression>(), 1, this.commandToExecute.getaQueryTreeTracker(), this.database);
        this.aQueryTree.getSelectOrphans().addAll((Collection<SqlExpression>)list);
        QueryTreeHandler.FillAllExprDataTypes(this.aQueryTree, this.database);
        QueryTreeHandler.setOwnerShipColumns(this.aQueryTree);
        return var3_3;
    }

    @Override
    public Object visit(SetUpdateClause setUpdateClause, Object object) {
        Object object2;
        Object var3_3 = null;
        if (setUpdateClause.f0.present()) {
            object2 = new TableNameHandler(this.client);
            setUpdateClause.f0.accept((ObjectVisitor)object2, object);
            if (!this.tableName.equalsIgnoreCase(((TableNameHandler)object2).getTableName())) {
                throw new XDBServerException("Column prefix does not match to target table name");
            }
        }
        object2 = (String)setUpdateClause.f1.accept(new IdentifierHandler(), object);
        SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
        setUpdateClause.f3.accept(sQLExpressionHandler, this.aQueryTree);
        this.setClause.put((String)object2, sQLExpressionHandler.aroot);
        this.aQueryTree.getProjectionList().add(sQLExpressionHandler.aroot);
        return var3_3;
    }

    @Override
    public Object visit(WhereClause whereClause, Object object) {
        Object var3_3 = null;
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
        whereClause.f1.accept(queryConditionHandler, this.aQueryTree);
        this.filterCondition = queryConditionHandler.aRootCondition;
        if (this.filterCondition != null) {
            this.aQueryTree.setWhereRootCondition(this.filterCondition);
            QueryTreeHandler.ProcessWhereCondition(this.filterCondition, this.aQueryTree, this.commandToExecute.getaQueryTreeTracker(), this.database);
        }
        return var3_3;
    }

    @Override
    public Collection<SysTable> getReadTables() {
        Collection<SysTable> collection = super.getReadTables();
        collection.add(this.getTargetTable());
        return collection;
    }

    @Override
    protected Collection<SysColumn> getColumnsInvolved() {
        if (this.modifiedColumnList == null) {
            this.sysColumnList = new LinkedHashSet<SysColumn>();
            this.modifiedColumnList = new LinkedHashSet<SysColumn>();
            for (String string : this.setClause.keySet()) {
                this.modifiedColumnList.add(this.getTargetTable().getSysColumn(string));
            }
        }
        return this.modifiedColumnList;
    }

    @Override
    protected IConstraintChecker getPKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        UpdatePrimaryKeyChecker updatePrimaryKeyChecker = new UpdatePrimaryKeyChecker(this.getTargetTable(), this.client);
        collection.addAll(updatePrimaryKeyChecker.scanConstraints(this.getColumnsInvolved()));
        return updatePrimaryKeyChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getFKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        UpdateForeignKeyChecker updateForeignKeyChecker = new UpdateForeignKeyChecker(this.getTargetTable(), this.client);
        collection.addAll(updateForeignKeyChecker.scanConstraints(this.getColumnsInvolved()));
        UpdateForeignKeyChecker updateForeignKeyChecker2 = updateForeignKeyChecker;
        return updateForeignKeyChecker2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getFRChecker(SysTable sysTable, Collection<SysColumn> collection) {
        UpdateForeignReferenceChecker updateForeignReferenceChecker = new UpdateForeignReferenceChecker(this.getTargetTable(), this.client);
        collection.addAll(updateForeignReferenceChecker.scanConstraints(this.getColumnsInvolved()));
        UpdateForeignReferenceChecker updateForeignReferenceChecker2 = updateForeignReferenceChecker;
        return updateForeignReferenceChecker2;
    }

    @Override
    protected SysTable createTempTableMetadata(SysTable sysTable, Collection<SysColumn> collection) throws Exception {
        String string;
        boolean bl = true;
        if (this.validators.isEmpty()) {
            bl = false;
        }
        if (!bl && (string = sysTable.getPartitionColumn()) != null && this.setClause.containsKey(string)) {
            bl = true;
        }
        if (!bl && this.filterCondition != null && !this.filterCondition.isSimple()) {
            bl = true;
        }
        if (bl) {
            Object object;
            Object object2;
            Object object3;
            int n;
            string = sysTable.getPartitionColumn();
            if (string != null && this.setClause.containsKey(string)) {
                this.doRowMove = true;
                for (SysColumn entry : sysTable.getColumns()) {
                    n = entry.getNativeColDef().indexOf(entry.getColName()) + entry.getColName().length();
                    object3 = entry.getNativeColDef().substring(0, n) + "_new" + entry.getNativeColDef().substring(n);
                    object2 = new SysColumn(sysTable, 0, 0, entry.getColName() + "_new", entry.getColType(), entry.getColLength(), entry.getColScale(), entry.getColPrecision(), entry.isNullable(), entry.isSerial(), (String)object3, entry.getSelectivity(), entry.getDefaultExpr());
                    this.sysColumnList.add((SysColumn)object2);
                    object = this.setClause.get(entry.getColName());
                    if (object == null) {
                        object = new SqlExpression();
                        ((SqlExpression)object).setExprString(entry.getColName());
                        ((SqlExpression)object).setExprType(4);
                        ((SqlExpression)object).setColumn(new AttributeColumn());
                        ((SqlExpression)object).getColumn().columnName = entry.getColName();
                        this.aQueryTree.getProjectionList().add((SqlExpression)object);
                    } else {
                        this.aQueryTree.getProjectionList().remove(object);
                        this.aQueryTree.getProjectionList().add((SqlExpression)object);
                    }
                    ((SqlExpression)object).setAlias(((SysColumn)object2).getColName());
                    ((SqlExpression)object).setOuterAlias(((SysColumn)object2).getColName());
                    ((SqlExpression)object).setExprDataType(new ExpressionType());
                    ((SqlExpression)object).getExprDataType().setExpressionType(((SysColumn)object2).getColType(), ((SysColumn)object2).getColLength(), ((SysColumn)object2).getColPrecision(), ((SysColumn)object2).getColScale());
                }
            } else {
                for (Map.Entry<String, SqlExpression> n3 : this.setClause.entrySet()) {
                    String string2 = n3.getKey();
                    object3 = sysTable.getSysColumn(string2);
                    if (object3 == null) {
                        throw new XDBServerException("Column " + string2 + " is not found in table " + this.tableName);
                    }
                    int n2 = ((SysColumn)object3).getNativeColDef().indexOf(string2) + string2.length();
                    object = ((SysColumn)object3).getNativeColDef().substring(0, n2) + "_new" + ((SysColumn)object3).getNativeColDef().substring(n2);
                    SysColumn sysColumn = new SysColumn(sysTable, 0, 0, ((SysColumn)object3).getColName() + "_new", ((SysColumn)object3).getColType(), ((SysColumn)object3).getColLength(), ((SysColumn)object3).getColScale(), ((SysColumn)object3).getColPrecision(), ((SysColumn)object3).isNullable(), ((SysColumn)object3).isSerial(), (String)object, ((SysColumn)object3).getSelectivity(), ((SysColumn)object3).getDefaultExpr());
                    this.sysColumnList.add(sysColumn);
                }
            }
            for (SysColumn sysColumn : sysTable.getRowID()) {
                n = sysColumn.getNativeColDef().indexOf(sysColumn.getColName()) + sysColumn.getColName().length();
                object3 = sysColumn.getNativeColDef().substring(0, n) + "_old" + sysColumn.getNativeColDef().substring(n);
                object2 = new SysColumn(sysTable, 0, 0, sysColumn.getColName() + "_old", sysColumn.getColType(), sysColumn.getColLength(), sysColumn.getColScale(), sysColumn.getColPrecision(), sysColumn.isNullable(), sysColumn.isSerial(), (String)object3, sysColumn.getSelectivity(), sysColumn.getDefaultExpr());
                this.sysColumnList.add((SysColumn)object2);
                object = new SqlExpression();
                ((SqlExpression)object).setExprString(sysColumn.getColName());
                ((SqlExpression)object).setExprType(4);
                ((SqlExpression)object).setColumn(new AttributeColumn());
                ((SqlExpression)object).getColumn().columnName = sysColumn.getColName();
                ((SqlExpression)object).setAlias(((SysColumn)object2).getColName());
                ((SqlExpression)object).setOuterAlias(((SysColumn)object2).getColName());
                ((SqlExpression)object).setExprDataType(new ExpressionType());
                ((SqlExpression)object).getExprDataType().setExpressionType(((SysColumn)object2).getColType(), ((SysColumn)object2).getColLength(), ((SysColumn)object2).getColPrecision(), ((SysColumn)object2).getColScale());
                this.aQueryTree.getProjectionList().add((SqlExpression)object);
            }
            SysColumn sysColumn = sysTable.getPartitionedColumn();
            if (sysColumn != null) {
                int n3 = sysColumn.getNativeColDef().indexOf(sysColumn.getColName()) + sysColumn.getColName().length();
                String string3 = sysColumn.getNativeColDef().substring(0, n3) + "_old" + sysColumn.getNativeColDef().substring(n3);
                object3 = new SysColumn(sysTable, 0, 0, sysColumn.getColName() + "_old", sysColumn.getColType(), sysColumn.getColLength(), sysColumn.getColScale(), sysColumn.getColPrecision(), sysColumn.isNullable(), sysColumn.isSerial(), string3, sysColumn.getSelectivity(), sysColumn.getDefaultExpr());
                if (!this.sysColumnList.contains(object3)) {
                    object2 = new SqlExpression();
                    ((SqlExpression)object2).setExprString(sysColumn.getColName());
                    ((SqlExpression)object2).setExprType(4);
                    ((SqlExpression)object2).setColumn(new AttributeColumn());
                    ((SqlExpression)object2).getColumn().columnName = sysColumn.getColName();
                    ((SqlExpression)object2).setAlias(((SysColumn)object3).getColName());
                    ((SqlExpression)object2).setOuterAlias(((SysColumn)object3).getColName());
                    ((SqlExpression)object2).setExprDataType(new ExpressionType());
                    ((SqlExpression)object2).getExprDataType().setExpressionType(((SysColumn)object3).getColType(), ((SysColumn)object3).getColLength(), ((SysColumn)object3).getColPrecision(), ((SysColumn)object3).getColScale());
                    this.aQueryTree.getProjectionList().add((SqlExpression)object2);
                }
            }
            if (this.doRowMove) {
                SysColumn sysColumn2 = new SysColumn(sysTable, 0, 0, "XDB__NODE__ID_new", 4, -1, -1, -1, false, false, IdentifierHandler.quote("XDB__NODE__ID_new") + " INT NOT NULL", 1.0, null);
                this.sysColumnList.add(sysColumn2);
                SysColumn sysColumn3 = new SysColumn(sysTable, 0, 0, "XDB__NODE__ID_old", 4, -1, -1, -1, false, false, IdentifierHandler.quote("XDB__NODE__ID_old") + " INT NOT NULL", 1.0, null);
                this.sysColumnList.add(sysColumn3);
            }
            return super.createTempTableMetadata(sysTable, this.sysColumnList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareDataSource(SysTable sysTable, SysTable sysTable2) throws Exception {
        QueryProcessor queryProcessor = null;
        if (sysTable2 != null) {
            queryProcessor = new QueryProcessor(this.client, this.aQueryTree);
            queryProcessor.setSkipPermissionCheck(Collections.singleton(this.tableName));
            queryProcessor.prepare();
        }
        QueryProcessor queryProcessor2 = queryProcessor;
        return queryProcessor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object prepareFinalStatements(SysTable sysTable, SysTable sysTable2) throws Exception {
        Object object;
        Object object2;
        String string = sysTable.getTableName();
        if (sysTable2 == null) {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            stringBuffer.append(IdentifierHandler.quote(string)).append(" SET ");
            int n = 0;
            for (Map.Entry<String, SqlExpression> entry : this.setClause.entrySet()) {
                stringBuffer.append(IdentifierHandler.quote(entry.getKey())).append("=");
                SqlExpression sqlExpression = entry.getValue();
                SqlExpression.setExpressionResultType(sqlExpression, this.database);
                stringBuffer.append(sqlExpression.rebuildString()).append(", ");
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            if (this.filterCondition == null) return stringBuffer.toString();
            stringBuffer.append(" WHERE ").append(this.filterCondition.rebuildString());
            return stringBuffer.toString();
        }
        String string2 = sysTable2.getTableName();
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE == 1) {
            stringBuffer.append(IdentifierHandler.quote(string)).append(" SET (");
            object2 = new StringBuffer();
            for (String string3 : this.setClause.keySet()) {
                stringBuffer.append(IdentifierHandler.quote(string3)).append(", ");
                ((StringBuffer)object2).append(IdentifierHandler.quote(string3 + "_new")).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            ((StringBuffer)object2).setLength(((StringBuffer)object2).length() - 2);
            stringBuffer.append(")=(SELECT ");
            stringBuffer.append((StringBuffer)object2).append(" FROM ");
            stringBuffer.append(IdentifierHandler.quote(string2));
            stringBuffer.append(" WHERE ");
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            for (SysColumn sysColumn : sysTable.getRowID()) {
                object = sysColumn.getColName();
                if (sysColumn.isNullable()) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                stringBuffer.append(IdentifierHandler.quote((String)object)).append("=");
                stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer.append(IdentifierHandler.quote((String)object));
                if (sysColumn.isNullable()) {
                    stringBuffer.append(" OR ");
                    stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                    stringBuffer.append(IdentifierHandler.quote((String)object)).append(" IS NULL AND ");
                    stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                    stringBuffer.append(IdentifierHandler.quote((String)object + "_old")).append(" IS NULL");
                    stringBuffer.append(")");
                }
                stringBuffer.append(" AND ");
                stringBuffer2.append(IdentifierHandler.quote((String)object)).append(", ");
                stringBuffer3.append(IdentifierHandler.quote((String)object + "_old")).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 5);
            stringBuffer2.setLength(stringBuffer2.length() - 2);
            stringBuffer3.setLength(stringBuffer3.length() - 2);
            stringBuffer.append(") WHERE ");
            stringBuffer.append(stringBuffer2).append(" IN (SELECT ");
            stringBuffer.append(stringBuffer3).append(" FROM ");
            stringBuffer.append(IdentifierHandler.quote(string2));
            if (!this.doRowMove) {
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        } else if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE == 2) {
            stringBuffer.append(IdentifierHandler.quote(string)).append(" SET ");
            for (String string4 : this.setClause.keySet()) {
                stringBuffer.append(IdentifierHandler.quote(string4)).append("=");
                stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string4 + "_new")).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(" FROM ").append(IdentifierHandler.quote(string2)).append(" WHERE ");
            for (SysColumn sysColumn : sysTable.getRowID()) {
                String string5 = sysColumn.getColName();
                if (sysColumn.isNullable()) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string5)).append("=");
                stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string5 + "_old"));
                if (sysColumn.isNullable()) {
                    stringBuffer.append(" OR ");
                    stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                    stringBuffer.append(IdentifierHandler.quote(string5)).append(" IS NULL AND ");
                    stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                    stringBuffer.append(IdentifierHandler.quote(string5 + "_old")).append(" IS NULL");
                    stringBuffer.append(")");
                }
                stringBuffer.append(" AND ");
            }
            if (!this.doRowMove) {
                stringBuffer.setLength(stringBuffer.length() - 5);
                return stringBuffer.toString();
            }
        } else {
            if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE != 3) {
                throw new XDBServerException("Invalid xdb.sqlcommand.update.correlatedstyle value");
            }
            stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
            stringBuffer.append(IdentifierHandler.quote(string2)).append(" SET ");
            for (String string6 : this.setClause.keySet()) {
                stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string6)).append("=");
                stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string6 + "_new")).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(" WHERE ");
            for (SysColumn sysColumn : sysTable.getRowID()) {
                String string7 = sysColumn.getColName();
                if (sysColumn.isNullable()) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string7)).append("=");
                stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer.append(IdentifierHandler.quote(string7 + "_old"));
                if (sysColumn.isNullable()) {
                    stringBuffer.append(" OR ");
                    stringBuffer.append(IdentifierHandler.quote(string)).append(".");
                    stringBuffer.append(IdentifierHandler.quote(string7)).append(" IS NULL AND ");
                    stringBuffer.append(IdentifierHandler.quote(string2)).append(".");
                    stringBuffer.append(IdentifierHandler.quote(string7 + "_old")).append(" IS NULL");
                    stringBuffer.append(")");
                }
                stringBuffer.append(" AND ");
            }
            if (!this.doRowMove) {
                stringBuffer.setLength(stringBuffer.length() - 5);
                return stringBuffer.toString();
            }
        }
        object2 = new ArrayList(3);
        StringBuffer stringBuffer4 = new StringBuffer("INSERT INTO ");
        stringBuffer4.append(IdentifierHandler.quote(string)).append(" (");
        for (SysColumn sysColumn : sysTable.getColumns()) {
            stringBuffer4.append(IdentifierHandler.quote(sysColumn.getColName())).append(", ");
        }
        stringBuffer4.setLength(stringBuffer4.length() - 2);
        stringBuffer4.append(") SELECT ");
        for (SysColumn sysColumn : sysTable.getColumns()) {
            stringBuffer4.append(IdentifierHandler.quote(sysColumn.getColName() + "_new")).append(", ");
        }
        stringBuffer4.setLength(stringBuffer4.length() - 2);
        stringBuffer4.append(" FROM ").append(IdentifierHandler.quote(string2));
        StringBuffer stringBuffer5 = new StringBuffer("DELETE FROM ");
        stringBuffer5.append(IdentifierHandler.quote(string)).append(" WHERE EXISTS (SELECT 1 FROM ");
        stringBuffer5.append(IdentifierHandler.quote(string2)).append(" WHERE ");
        for (SysColumn sysColumn : sysTable.getRowID()) {
            object = sysColumn.getColName();
            if (sysColumn.isNullable()) {
                stringBuffer5.append("(");
            }
            stringBuffer5.append(IdentifierHandler.quote(string2)).append(".");
            stringBuffer5.append(IdentifierHandler.quote((String)object + "_old")).append("=");
            stringBuffer5.append(IdentifierHandler.quote(string)).append(".");
            stringBuffer5.append(IdentifierHandler.quote((String)object));
            if (sysColumn.isNullable()) {
                stringBuffer5.append(" OR ");
                stringBuffer5.append(IdentifierHandler.quote(string)).append(".");
                stringBuffer5.append(IdentifierHandler.quote((String)object)).append(" IS NULL AND ");
                stringBuffer5.append(IdentifierHandler.quote(string2)).append(".");
                stringBuffer5.append(IdentifierHandler.quote((String)object + "_old")).append(" IS NULL");
                stringBuffer5.append(")");
            }
            stringBuffer5.append(" AND ");
        }
        HashMap<DBNode, String> hashMap = new HashMap<DBNode, String>();
        HashMap<DBNode, String> hashMap2 = new HashMap<DBNode, String>();
        object = new HashMap();
        Iterator<DBNode> iterator = sysTable.getNodeList().iterator();
        while (true) {
            DBNode dBNode;
            if (!iterator.hasNext()) {
                ((ArrayList)object2).add(object);
                ((ArrayList)object2).add(hashMap2);
                ((ArrayList)object2).add(hashMap);
                return object2;
            }
            DBNode dBNode2 = dBNode = iterator.next();
            int n = dBNode2.getNodeId();
            String string8 = stringBuffer4.toString() + " WHERE " + IdentifierHandler.quote("XDB__NODE__ID_new") + " = " + n + " AND " + IdentifierHandler.quote("XDB__NODE__ID_old") + " <> " + n;
            hashMap.put(dBNode2, string8);
            if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE == 1) {
                string8 = stringBuffer.toString() + " WHERE " + IdentifierHandler.quote("XDB__NODE__ID_new") + " = " + n + " AND " + IdentifierHandler.quote("XDB__NODE__ID_old") + " = " + n + ")";
            } else if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE == 2) {
                string8 = stringBuffer.toString() + IdentifierHandler.quote("XDB__NODE__ID_new") + " = " + n + " AND " + IdentifierHandler.quote("XDB__NODE__ID_old") + " = " + n;
            } else {
                if (Props.XDB_SQLCOMMAND_UPDATE_CORELLATEDSTYLE != 3) {
                    throw new XDBServerException("Invalid xdb.sqlcommand.update.correlatedstyle value");
                }
                string8 = stringBuffer.toString() + IdentifierHandler.quote("XDB__NODE__ID_new") + " = " + n + " AND " + IdentifierHandler.quote("XDB__NODE__ID_old") + " = " + n;
            }
            hashMap2.put(dBNode2, string8);
            string8 = stringBuffer5.toString() + IdentifierHandler.quote("XDB__NODE__ID_new") + " <> " + n + " AND " + IdentifierHandler.quote("XDB__NODE__ID_old") + " = " + n + ")";
            object.put(dBNode2, string8);
        }
    }

    @Override
    protected int internalExecute(Object object, Engine engine) throws Exception {
        Collection<DBNode> collection;
        if (object instanceof Collection) {
            int[] nArray = new int[3];
            int n = 0;
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                int n2 = n++;
                nArray[n2] = nArray[n2] + super.internalExecute(iterator.next(), engine);
            }
            if (nArray[0] != nArray[2]) {
                // empty if block
            }
            return nArray[0] + nArray[1];
        }
        if (this.getTargetTable().getPartitionedColumn() != null && this.filterCondition != null && (collection = this.filterCondition.getPartitionedNode(this.client)) != null) {
            this.nodeList = collection;
        }
        return super.internalExecute(object, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void fillTempTable(Object object, SysTable sysTable, Engine engine) throws Exception {
        block31: {
            if (!(object instanceof IExecutable)) break block31;
            ResultSet resultSet = ((IExecutable)object).execute(engine).getResultSet();
            try {
                Object object3;
                Object object4;
                int n = 0;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
                ExpressionType expressionType = null;
                SysColumn sysColumn = this.getTargetTable().getPartitionedColumn();
                if (sysColumn != null) {
                    object4 = sysColumn.getColName() + "_new";
                    object3 = sysColumn.getColName() + "_old";
                    int n3 = 1;
                    for (SqlExpression sqlExpression : this.aQueryTree.getProjectionList()) {
                        if (((String)object4).equals(sqlExpression.getAlias())) {
                            n = n3;
                        } else if (((String)object3).equals(sqlExpression.getAlias())) {
                            n2 = n3;
                        }
                        ++n3;
                    }
                    expressionType = new ExpressionType(sysColumn);
                }
                object4 = null;
                object3 = null;
                stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(" (");
                for (SysColumn sysColumn2 : sysTable.getColumns()) {
                    String string = sysColumn2.getColName();
                    stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                    if (string.equals("XDB__NODE__ID_new")) {
                        object3 = sysColumn2;
                        continue;
                    }
                    if (!string.equals("XDB__NODE__ID_old")) continue;
                    object4 = sysColumn2;
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(") VALUES (");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    void var14_24;
                    Object var14_22 = null;
                    DBNode dBNode = null;
                    if (sysColumn != null) {
                        String string = resultSet.getString(n2);
                        DBNode dBNode2 = this.getTargetTable().getNode(SqlExpression.createConstantExpression(string, expressionType).getNormalizedValue()).iterator().next();
                        if (n > 0 && n <= n3) {
                            string = resultSet.getString(n);
                            if (string == null) {
                                string = sysColumn.getDefaultValue(this.client);
                            }
                            dBNode = this.getTargetTable().getNode(SqlExpression.createConstantExpression(string, expressionType).getNormalizedValue()).iterator().next();
                        } else {
                            dBNode = dBNode2;
                        }
                    }
                    int n4 = 1;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (SysColumn sysColumn3 : sysTable.getColumns()) {
                        if (sysColumn3 == object3) {
                            stringBuffer2.append(dBNode.getNodeId()).append(", ");
                        } else if (sysColumn3 == object4) {
                            stringBuffer2.append(var14_24.getNodeId()).append(", ");
                        } else {
                            String string = resultSet.getString(n4);
                            if (string != null && RSHelper.getQuoteInfo(sysColumn3)) {
                                string = "'" + string.replaceAll("'", "''") + "'";
                                switch (sysColumn3.getColType()) {
                                    case 92: {
                                        string = SqlExpression.normalizeTime(string);
                                        break;
                                    }
                                    case 93: {
                                        string = SqlExpression.normalizeTimeStamp(string);
                                        break;
                                    }
                                    case 91: {
                                        string = SqlExpression.normalizeDate(string);
                                        break;
                                    }
                                }
                            }
                            stringBuffer2.append(string).append(", ");
                            if (sysColumn3 == this.getTargetTable().getSerialColumn()) {
                                this.maxSuppliedSerial = Math.max(this.maxSuppliedSerial, Integer.parseInt(string));
                            }
                        }
                        ++n4;
                    }
                    if (stringBuffer2.length() <= 0) continue;
                    stringBuffer2.setLength(stringBuffer2.length() - 2);
                    String string = stringBuffer.toString() + stringBuffer2.toString() + ")";
                    if (var14_24 == null || this.validators != null && !this.validators.isEmpty()) {
                        if (!engine.addToBatchOnNodes(string, sysTable.getNodeList(), this.client)) continue;
                        this.executeCurrentBatch(engine);
                        continue;
                    }
                    if (engine.addToBatchOnNode(string, (DBNode)var14_24, this.client)) {
                        this.executeCurrentBatch(engine);
                    }
                    if (var14_24 == dBNode || !engine.addToBatchOnNode(string, dBNode, this.client)) continue;
                    this.executeCurrentBatch(engine);
                }
            }
            finally {
                resultSet.close();
            }
            this.executeCurrentBatch(engine);
        }
    }

    @Override
    protected short getPrivilege() {
        return 2;
    }

    public boolean manualParse(String string) {
        Object object;
        Lexer lexer = new Lexer(string);
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("UPDATE")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        this.tableName = lexer.nextToken();
        QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
        queryTreeTracker.registerTree(this.aQueryTree);
        RelationNode relationNode = this.aQueryTree.newRelationNode();
        relationNode.setNodeType(2);
        relationNode.setTableName(this.tableName);
        relationNode.setTemporaryTable(this.client.getTempTableName(this.tableName) != null);
        relationNode.setClient(this.commandToExecute.getClientContext());
        relationNode.setAlias("");
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("SET")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        String string2 = lexer.nextToken();
        XDBSessionContext xDBSessionContext = this.commandToExecute.getClientContext();
        while (true) {
            object = string2;
            if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("=")) {
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            SqlExpression sqlExpression = ParserHelper.createSimpleSqlExpression(lexer, xDBSessionContext.getSysDatabase().getSysTable(this.tableName), relationNode, xDBSessionContext);
            if (sqlExpression == null) {
                return false;
            }
            this.setClause.put((String)object, sqlExpression);
            this.aQueryTree.getProjectionList().add(sqlExpression);
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
            if (string2.equalsIgnoreCase("WHERE")) break;
            if (!string2.equals(",")) {
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
        }
        if (!string2.equalsIgnoreCase("WHERE")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        do {
            if ((object = ParserHelper.getSimpleCondition(lexer, xDBSessionContext.getSysDatabase().getSysTable(this.tableName), this.aQueryTree, xDBSessionContext)) == null) {
                return false;
            }
            this.filterCondition = this.filterCondition == null ? object : ParserHelper.chainQueryConditions(this.filterCondition, "AND", (QueryCondition)object);
        } while (lexer.hasMoreTokens() && lexer.nextToken().equalsIgnoreCase("AND"));
        if (this.filterCondition != null) {
            QueryTreeHandler.ProcessWhereCondition(this.filterCondition, this.aQueryTree, queryTreeTracker, this.database);
        }
        if (lexer.hasMoreTokens()) {
            string2 = lexer.nextToken();
            if (!string2.equals(";")) {
                return false;
            }
            if (lexer.hasMoreTokens()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getResultType() {
        return 17;
    }
}

