/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.constraintchecker.InsertForeignKeyChecker;
import com.edb.gridsql.constraintchecker.InsertPrimaryKeyChecker;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.NodeProducerThread;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.loader.Loader;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockType;
import com.edb.gridsql.misc.RSHelper;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.Lexer;
import com.edb.gridsql.parser.ParserHelper;
import com.edb.gridsql.parser.SqlModifyTable;
import com.edb.gridsql.parser.Tuple;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.InsertTable;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.SQLExpressionListItem;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.SQLExpressionHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlInsertTable
extends SqlModifyTable {
    public static final String GROUP_ROW_ID = "group__id";
    private static final XLogger logger = XLogger.getLogger(SqlInsertTable.class);
    public Tuple tuple;
    private Vector<String> columnList = new Vector();
    private Collection<SysColumn> sysColumnList;
    private Vector<SqlExpression> valueList = new Vector();
    private QueryTree aQueryTree = null;

    public SqlInsertTable(XDBSessionContext xDBSessionContext) {
        super(xDBSessionContext);
        this.commandToExecute = new Command(3, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public Object visit(InsertTable insertTable, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        insertTable.f2.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        insertTable.f3.accept(this, object);
        if (insertTable.f4.which == 0) {
            insertTable.f4.accept(this, object);
            this.tuple = new Tuple(this.getTableName(), new ArrayList<SysColumn>(this.getColumnsInvolved()), this.valueList, this.client);
        } else {
            QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
            this.aQueryTree = new QueryTree();
            insertTable.f4.choice.accept(queryTreeHandler, this.aQueryTree);
            this.addProjColsIfFoundNullColumn(this.aQueryTree, this.getColumnsInvolved().size());
        }
        return var3_3;
    }

    void addProjColsIfFoundNullColumn(QueryTree queryTree, int n) {
        List<SqlExpression> list = queryTree.getProjectionList();
        if (list.size() == 1 && list.get(0).getExprString() == null) {
            if (n > 1) {
                SqlExpression sqlExpression = list.get(0);
                list.clear();
                for (int i = 0; i < n; ++i) {
                    list.add(sqlExpression.copy());
                }
            }
        } else if (n == 0) {
            throw new XDBServerException("INSERT has more expressions than target columns");
        }
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.columnList.add((String)columnNameList.f0.accept(identifierHandler, object));
        for (Object e : columnNameList.f1.nodes) {
            NodeSequence nodeSequence = (NodeSequence)e;
            this.columnList.add((String)nodeSequence.elementAt(1).accept(identifierHandler, object));
        }
        return var3_3;
    }

    @Override
    public Object visit(SQLExpressionListItem sQLExpressionListItem, Object object) {
        Object var3_3 = null;
        SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
        SqlExpression sqlExpression = (SqlExpression)sQLExpressionListItem.f0.accept(sQLExpressionHandler, object);
        this.valueList.add(sqlExpression);
        return var3_3;
    }

    @Override
    public Object visit(Select select, Object object) {
        Object var3_3 = null;
        select.f0.accept(this, object);
        select.f1.accept(this, object);
        return var3_3;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        if (this.lockSpecs == null) {
            List list = Collections.emptyList();
            this.lockSpecs = new LockSpecification<SysTable>(this.getReadTables(), list);
            this.lockSpecs.add(this.getTargetTable(), LockType.get(1, false));
        }
        return this.lockSpecs;
    }

    @Override
    protected Collection<SysColumn> getColumnsInvolved() {
        block5: {
            if (this.sysColumnList != null) break block5;
            this.sysColumnList = new LinkedHashSet<SysColumn>();
            if (this.columnList.size() == 0) {
                for (SysColumn sysColumn : this.getTargetTable().getColumns()) {
                    if (sysColumn.getColName().equalsIgnoreCase("xrowid")) continue;
                    this.sysColumnList.add(sysColumn);
                    this.columnList.add(sysColumn.getColName());
                }
            } else {
                for (String string : this.columnList) {
                    SysColumn sysColumn = this.getTargetTable().getSysColumn(string);
                    if (sysColumn == null) {
                        throw new XDBServerException("Column " + string + " is not found in table " + this.tableName);
                    }
                    this.sysColumnList.add(sysColumn);
                }
            }
        }
        return this.sysColumnList;
    }

    public boolean isSelectInsert() {
        return this.aQueryTree == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getPKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        InsertPrimaryKeyChecker insertPrimaryKeyChecker = new InsertPrimaryKeyChecker(this.getTargetTable(), this.tuple, this.client);
        collection.addAll(insertPrimaryKeyChecker.scanConstraints(this.getColumnsInvolved()));
        InsertPrimaryKeyChecker insertPrimaryKeyChecker2 = insertPrimaryKeyChecker;
        return insertPrimaryKeyChecker2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getFKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        InsertForeignKeyChecker insertForeignKeyChecker = new InsertForeignKeyChecker(this.getTargetTable(), this.tuple, this.client);
        collection.addAll(insertForeignKeyChecker.scanConstraints(this.getColumnsInvolved()));
        InsertForeignKeyChecker insertForeignKeyChecker2 = insertForeignKeyChecker;
        return insertForeignKeyChecker2;
    }

    @Override
    protected IConstraintChecker getFRChecker(SysTable sysTable, Collection<SysColumn> collection) {
        return null;
    }

    @Override
    protected SysTable createTempTableMetadata(SysTable sysTable, Collection<SysColumn> collection) throws Exception {
        if (this.tuple == null) {
            for (SysColumn object2 : sysTable.getColumns()) {
                SysColumn sysColumn = object2;
                if (sysColumn.getDefaultExpr() == null || collection.contains(sysColumn)) continue;
                collection.add(sysColumn);
            }
            SysColumn sysColumn = sysTable.getSerialColumn();
            if (sysColumn != null && !collection.contains(sysColumn)) {
                collection.add(sysColumn);
            }
            SysTable sysTable2 = super.createTempTableMetadata(sysTable, collection);
            sysTable2.setTableTemporary(!Props.XDB_USE_LOAD_FOR_STEP);
            return sysTable2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareDataSource(SysTable sysTable, SysTable sysTable2) throws Exception {
        block3: {
            if (this.tuple != null) break block3;
            QueryProcessor queryProcessor = new QueryProcessor(this.client, this.aQueryTree);
            queryProcessor.prepare();
            QueryProcessor queryProcessor2 = queryProcessor;
            return queryProcessor2;
        }
        Tuple tuple = this.tuple;
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareFinalStatements(SysTable sysTable, SysTable sysTable2) throws Exception {
        block5: {
            if (this.tuple == null) break block5;
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(IdentifierHandler.quote(this.getTableName())).append(" (");
            StringBuffer stringBuffer2 = new StringBuffer(") VALUES (");
            for (SysColumn sysColumn : this.getTargetTable().getColumns()) {
                String string = sysColumn.getColName();
                stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                String string2 = this.tuple.getValue(sysColumn);
                stringBuffer2.append(string2).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer2.setLength(stringBuffer2.length() - 2);
            stringBuffer.append(stringBuffer2).append(")");
            String string = stringBuffer.toString();
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(" (");
        StringBuffer stringBuffer3 = new StringBuffer(") SELECT ");
        for (SysColumn sysColumn : sysTable.getColumns()) {
            if (!this.sysColumnList.contains(sysColumn)) continue;
            String string = sysColumn.getColName();
            stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
            stringBuffer3.append(IdentifierHandler.quote(string)).append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer3.setLength(stringBuffer3.length() - 2);
        stringBuffer.append(stringBuffer3);
        stringBuffer.append(" FROM ").append(IdentifierHandler.quote(sysTable2.getTableName()));
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void fillTempTable(Object object, SysTable sysTable, Engine engine) throws Exception {
        block26: {
            block28: {
                block29: {
                    Object object2;
                    if (this.tuple != null) break block26;
                    if (!(object instanceof QueryProcessor)) break block28;
                    QueryProcessor queryProcessor = (QueryProcessor)object;
                    if (this.getParamCount() > 0) {
                        queryProcessor.prepareParameters(this.commandToExecute.getParameters());
                        queryProcessor.resetExecPlan(this.commandToExecute.getParameters());
                    }
                    ResultSet resultSet = queryProcessor.execute(engine).getResultSet();
                    if (Props.XDB_USE_LOAD_FOR_STEP) {
                        Loader loader = new Loader(resultSet, null);
                        loader.setLocalTableInfo(sysTable, this.client, null, false);
                        try {
                            loader.prepareLoad(null);
                            boolean bl = false;
                            try {
                                NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Run Writers");
                                loader.runWriters();
                                bl = true;
                            }
                            finally {
                                NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Finish load");
                                loader.finishLoad(bl);
                            }
                            return;
                        }
                        catch (Exception exception) {
                            logger.catching(exception);
                            XDBServerException xDBServerException = new XDBServerException("Can not send data to Nodes", exception);
                            logger.throwing(xDBServerException);
                            throw xDBServerException;
                        }
                    }
                    int n = 0;
                    StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
                    stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(" (");
                    for (SysColumn object32 : sysTable.getColumns()) {
                        object2 = object32.getColName();
                        stringBuffer.append(IdentifierHandler.quote((String)object2)).append(", ");
                    }
                    SysColumn sysColumn = this.getTargetTable().getPartitionedColumn();
                    Object var9_16 = null;
                    if (sysColumn != null) {
                        n = sysTable.getSysColumn(sysColumn.getColName()).getColSeq() + 1;
                        ExpressionType expressionType = new ExpressionType(sysColumn);
                    }
                    stringBuffer.setLength(stringBuffer.length() - 2);
                    stringBuffer.append(") VALUES (");
                    object2 = resultSet.getMetaData();
                    int n2 = object2.getColumnCount();
                    while (resultSet.next()) {
                        void var9_18;
                        StringBuffer stringBuffer2 = new StringBuffer();
                        int n3 = 1;
                        String string = null;
                        if (n > 0 && n <= n2) {
                            string = resultSet.getString(n);
                        } else if (sysColumn != null) {
                            string = sysColumn.getDefaultValue(this.client);
                        }
                        Collection<DBNode> collection = this.getTargetTable().getNode(SqlExpression.createConstantExpression(string, (ExpressionType)var9_18).getNormalizedValue());
                        for (SysColumn sysColumn2 : sysTable.getColumns()) {
                            String string2 = n3 == n ? string : (n3 <= n2 ? resultSet.getString(n3) : sysColumn2.getDefaultValue(this.client));
                            if (string2 != null && RSHelper.getQuoteInfo(sysColumn2)) {
                                string2 = "'" + string2.replaceAll("'", "''") + "'";
                                switch (sysColumn2.getColType()) {
                                    case 92: {
                                        string2 = SqlExpression.normalizeTime(string2);
                                        break;
                                    }
                                    case 93: {
                                        string2 = SqlExpression.normalizeTimeStamp(string2);
                                        break;
                                    }
                                    case 91: {
                                        string2 = SqlExpression.normalizeDate(string2);
                                        break;
                                    }
                                }
                            }
                            stringBuffer2.append(string2);
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.setLength(stringBuffer2.length() - 2);
                        String string3 = stringBuffer.toString() + stringBuffer2.toString() + ")";
                        if (!engine.addToBatchOnNodes(string3, collection, this.client)) continue;
                        this.executeCurrentBatch(engine);
                    }
                    break block29;
                    finally {
                        resultSet.close();
                    }
                }
                this.executeCurrentBatch(engine);
                break block26;
            }
            XDBServerException xDBServerException = new XDBServerException("Data Source is not supported");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    @Override
    protected int internalExecute(Object object, Engine engine) throws Exception {
        if (this.tuple != null) {
            SysColumn sysColumn = this.getTargetTable().getPartitionedColumn();
            SqlExpression sqlExpression = null;
            if (sysColumn != null) {
                sqlExpression = engine.evaluate(this.client, this.tuple.getExpression(sysColumn));
            }
            this.nodeList = this.getTargetTable().getNode(sqlExpression == null ? null : sqlExpression.getNormalizedValue());
        }
        return super.internalExecute(object, engine);
    }

    @Override
    protected short getPrivilege() {
        return 1;
    }

    public boolean manualParse(String string) {
        Lexer lexer = new Lexer(string);
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("INSERT")) {
            return false;
        }
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("INTO")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        this.tableName = lexer.nextToken();
        this.client.getSysDatabase().getSysTable(this.tableName);
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        String string2 = lexer.nextToken();
        if (string2.equals("(")) {
            while (lexer.hasMoreTokens()) {
                if (!lexer.hasMoreTokens()) {
                    return false;
                }
                string2 = lexer.nextToken();
                this.columnList.add(string2);
                if (!lexer.hasMoreTokens()) {
                    return false;
                }
                string2 = lexer.nextToken();
                if (string2.equals(")")) break;
                if (string2.equals(",")) continue;
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
        }
        if (!string2.equalsIgnoreCase("VALUES")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        string2 = lexer.nextToken();
        if (!string2.equals("(")) {
            return false;
        }
        XDBSessionContext xDBSessionContext = this.commandToExecute.getClientContext();
        int n = 0;
        while (true) {
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            SqlExpression sqlExpression = ParserHelper.createSimpleSqlExpression(lexer, xDBSessionContext.getSysDatabase().getSysTable(this.tableName), null, xDBSessionContext);
            if (sqlExpression == null) {
                return false;
            }
            this.valueList.add(sqlExpression);
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
            if (string2.equals(")")) break;
            if (!string2.equals(",")) {
                return false;
            }
            ++n;
        }
        if (lexer.hasMoreTokens()) {
            string2 = lexer.nextToken();
            if (!string2.equals(";")) {
                return false;
            }
            if (lexer.hasMoreTokens()) {
                return false;
            }
        }
        this.tuple = new Tuple(this.getTableName(), new ArrayList<SysColumn>(this.getColumnsInvolved()), this.valueList, xDBSessionContext);
        return true;
    }

    @Override
    public int getResultType() {
        return 16;
    }
}

