/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.ExecDirect;
import com.edb.gridsql.parser.core.syntaxtree.NodeListOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecDirect
extends ObjectDepthFirst
implements IXDBSql,
IExecutable,
IPreparable {
    private XDBSessionContext client;
    private List<DBNode> nodeList;
    private String command;

    public SqlExecDirect(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(ExecDirect execDirect, Object object) {
        Object var3_3 = null;
        switch (execDirect.f3.which) {
            case 0: {
                this.nodeList = new ArrayList<DBNode>(this.client.getSysDatabase().getDBNodeList());
                break;
            }
            case 1: {
                this.nodeList = new ArrayList<DBNode>();
                NodeSequence nodeSequence = (NodeSequence)execDirect.f3.choice;
                NodeToken nodeToken = (NodeToken)nodeSequence.elementAt(1);
                int n = Integer.parseInt(nodeToken.tokenImage);
                this.nodeList.add(this.client.getSysDatabase().getDBNode(n));
                for (NodeSequence nodeSequence2 : ((NodeListOptional)nodeSequence.elementAt((int)2)).nodes) {
                    n = Integer.parseInt(((NodeToken)nodeSequence2.nodes.get((int)1)).tokenImage);
                    this.nodeList.add(this.client.getSysDatabase().getDBNode(n));
                }
                break;
            }
        }
        this.command = execDirect.f4.tokenImage;
        this.command = this.command.substring(1, this.command.length() - 1).replaceAll("''", "'");
        return var3_3;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.nodeList;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.nodeList);
        ArrayList<NodeMessage> arrayList = new ArrayList<NodeMessage>(multinodeExecutor.execute(this.command, this.nodeList, this.nodeList.size() == 1));
        TreeMap<Integer, ExecutionResult> treeMap = new TreeMap<Integer, ExecutionResult>();
        for (NodeMessage nodeMessage : arrayList) {
            if (nodeMessage.getMessageType() == 8) {
                treeMap.put(nodeMessage.getSourceNodeID(), ExecutionResult.createRowCountResult(-1, nodeMessage.getNumRowsResult()));
                continue;
            }
            if (nodeMessage.getMessageType() != 108) continue;
            treeMap.put(nodeMessage.getSourceNodeID(), ExecutionResult.createResultSetResult(-1, nodeMessage.getResultSet()));
        }
        return ExecutionResult.createMultipleResult(43, treeMap);
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

